/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.event;

import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingSphere;
import com.jme3.bounding.BoundingVolume;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResult;
import com.jme3.collision.CollisionResults;
import com.jme3.input.event.MouseButtonEvent;
import com.jme3.input.event.MouseMotionEvent;
import com.jme3.math.Ray;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Spatial;
import com.jme3.util.SafeArrayList;
import com.simsilica.lemur.event.AbstractCursorEvent;
import com.simsilica.lemur.event.CursorButtonEvent;
import com.simsilica.lemur.event.CursorEventControl;
import com.simsilica.lemur.event.CursorMotionEvent;
import com.simsilica.lemur.event.MouseEventControl;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PickEventSession {
    static Logger log = LoggerFactory.getLogger(PickEventSession.class);
    private Map<Collidable, RootEntry> roots = new LinkedHashMap<Collidable, RootEntry>();
    private SafeArrayList<RootEntry> rootList = new SafeArrayList(RootEntry.class);
    private Map<Camera, Ray> rayCache = new HashMap<Camera, Ray>();
    private String[] layerOrder = new String[]{"gui", "scene"};
    private Spatial hitTarget;
    private Spatial capture;
    private Set<Spatial> delivered = new HashSet<Spatial>();
    private boolean debug;
    private int lastScroll = 0;

    public PickEventSession() {
    }

    protected PickEventSession(Map<Collidable, RootEntry> roots) {
        this.roots.putAll(roots);
        this.rootList = null;
    }

    public void setDebugOn(boolean f) {
        this.debug = f;
    }

    public boolean isDebugOn() {
        return this.debug;
    }

    protected boolean isTraceEnabled() {
        return this.debug || log.isTraceEnabled();
    }

    protected void trace(String msg) {
        if (this.debug) {
            log.debug(msg);
        } else if (log.isTraceEnabled()) {
            log.trace(msg);
        }
    }

    public PickEventSession clone() {
        return new PickEventSession(this.roots);
    }

    public ViewPort findViewPort(Spatial s) {
        if (s == null) {
            return null;
        }
        for (Spatial root = s; root != null; root = root.getParent()) {
            RootEntry e = this.roots.get(root);
            if (e == null) continue;
            return e.viewport;
        }
        return null;
    }

    protected RootEntry findRootEntry(Spatial s) {
        if (s == null) {
            return null;
        }
        for (Spatial root = s; root != null; root = root.getParent()) {
            RootEntry e = this.roots.get(root);
            if (e == null) continue;
            return e;
        }
        return null;
    }

    public void addCollisionRoot(ViewPort viewPort) {
        this.addCollisionRoot(viewPort, null);
    }

    public void addCollisionRoot(ViewPort viewPort, String layer) {
        for (Spatial s : viewPort.getScenes()) {
            this.addCollisionRoot(s, viewPort, layer);
        }
    }

    public void addCollisionRoot(Spatial root, ViewPort viewPort) {
        this.addCollisionRoot(root, viewPort, null);
    }

    public void addCollisionRoot(Spatial root, ViewPort viewPort, String layer) {
        this.roots.put((Collidable)root, new RootEntry((Collidable)root, viewPort, layer));
        this.rootList = null;
    }

    public void removeCollisionRoot(ViewPort viewPort) {
        for (Spatial s : viewPort.getScenes()) {
            this.removeCollisionRoot(s);
        }
    }

    public void removeCollisionRoot(Spatial root) {
        RootEntry e = this.roots.remove(root);
        this.rootList = null;
    }

    public void setPickLayerOrder(String ... layers) {
        if (layers == null || layers.length == 0) {
            layers = new String[]{"scene", "gui"};
        }
        this.layerOrder = layers;
    }

    public String[] getPickLayerOrder() {
        return this.layerOrder;
    }

    public void clearHitTarget() {
        if (this.hitTarget == null) {
            return;
        }
        this.setCurrentHitTarget(null, null, new Vector2f(-1.0f, -1.0f), null);
    }

    public void close() {
        this.clearHitTarget();
        this.capture = null;
        this.rayCache.clear();
        this.delivered.clear();
        this.roots.clear();
        this.rootList = null;
    }

    protected Spatial findHitTarget(Spatial hit) {
        for (Spatial s = hit; s != null; s = s.getParent()) {
            CursorEventControl control1 = (CursorEventControl)s.getControl(CursorEventControl.class);
            if (control1 != null && control1.isEnabled()) {
                return s;
            }
            MouseEventControl control2 = (MouseEventControl)s.getControl(MouseEventControl.class);
            if (control2 == null || !control2.isEnabled()) continue;
            return s;
        }
        return null;
    }

    protected void setCurrentHitTarget(ViewPort viewport, Spatial s, Vector2f cursor, CollisionResult cr) {
        if (this.hitTarget == s) {
            return;
        }
        CursorMotionEvent event1 = null;
        MouseMotionEvent event2 = null;
        if (this.hitTarget != null) {
            if (this.hitTarget.getControl(MouseEventControl.class) != null) {
                event2 = new MouseMotionEvent((int)cursor.x, (int)cursor.y, 0, 0, 0, 0);
                ((MouseEventControl)this.hitTarget.getControl(MouseEventControl.class)).mouseExited(event2, this.hitTarget, this.capture);
            }
            if (this.hitTarget.getControl(CursorEventControl.class) != null) {
                event1 = new CursorMotionEvent(viewport, this.hitTarget, cursor.x, cursor.y, 0, 0, cr);
                ((CursorEventControl)this.hitTarget.getControl(CursorEventControl.class)).cursorExited(event1, this.hitTarget, this.capture);
            }
        }
        this.hitTarget = s;
        if (this.hitTarget != null) {
            if (this.hitTarget.getControl(MouseEventControl.class) != null) {
                if (event2 == null) {
                    event2 = new MouseMotionEvent((int)cursor.x, (int)cursor.y, 0, 0, 0, 0);
                }
                ((MouseEventControl)this.hitTarget.getControl(MouseEventControl.class)).mouseEntered(event2, this.hitTarget, this.capture);
            }
            if (this.hitTarget.getControl(CursorEventControl.class) != null) {
                if (event1 == null) {
                    event1 = new CursorMotionEvent(viewport, this.hitTarget, cursor.x, cursor.y, 0, 0, cr);
                }
                ((CursorEventControl)this.hitTarget.getControl(CursorEventControl.class)).cursorEntered(event1, this.hitTarget, this.capture);
            }
        }
    }

    protected SafeArrayList<RootEntry> getRootList() {
        if (this.rootList == null) {
            this.rootList = new SafeArrayList(RootEntry.class);
            for (String s : this.layerOrder) {
                int insert = this.rootList.size();
                for (RootEntry e : this.roots.values()) {
                    if (!Objects.equals(e.layer, s)) continue;
                    this.rootList.add(insert, (Object)e);
                }
            }
            HashSet<String> layers = new HashSet<String>(Arrays.asList(this.layerOrder));
            int insert = this.rootList.size();
            for (RootEntry e : this.roots.values()) {
                if (layers.contains(e.layer)) continue;
                this.rootList.add(insert, (Object)e);
            }
        }
        return this.rootList;
    }

    protected boolean viewContains(Camera cam, Vector2f cursor) {
        float x1 = cam.getViewPortLeft();
        float x2 = cam.getViewPortRight();
        float y1 = cam.getViewPortBottom();
        float y2 = cam.getViewPortTop();
        if (x1 == 0.0f && x2 == 1.0f && y1 == 0.0f && y2 == 1.0f) {
            return true;
        }
        float x = cursor.x / (float)cam.getWidth();
        float y = cursor.y / (float)cam.getHeight();
        return !(x < x1 || x > x2 || y < y1 || y > y2);
    }

    protected float[] getZBounds(Spatial s) {
        BoundingVolume bv = s.getWorldBound();
        if (bv == null) {
            return new float[]{0.0f, 1.0f};
        }
        Vector3f center = bv.getCenter();
        if (bv instanceof BoundingBox) {
            BoundingBox bb = (BoundingBox)bv;
            return new float[]{center.z - bb.getZExtent(), center.z + bb.getZExtent()};
        }
        if (bv instanceof BoundingSphere) {
            BoundingSphere bs = (BoundingSphere)bv;
            return new float[]{center.z - bs.getRadius(), center.z + bs.getRadius()};
        }
        throw new UnsupportedOperationException("Bounding volume type not supported for:" + bv);
    }

    protected Ray getPickRay(RootEntry rootEntry, Vector2f cursor) {
        Camera cam;
        Ray result;
        if (this.isTraceEnabled()) {
            this.trace("getPickRay(" + rootEntry + ", " + cursor + ")");
        }
        if ((result = this.rayCache.get(cam = rootEntry.viewport.getCamera())) != null) {
            return result;
        }
        if (rootEntry.root instanceof Spatial && ((Spatial)rootEntry.root).getQueueBucket() == RenderQueue.Bucket.Gui) {
            this.trace("Creating GuiBucket ray.");
            float[] range = this.getZBounds((Spatial)rootEntry.root);
            range[0] = range[0] - 1.0f;
            range[1] = range[1] + 1.0f;
            result = new Ray(new Vector3f(cursor.x, cursor.y, range[1]), new Vector3f(0.0f, 0.0f, -1.0f));
        } else if (this.viewContains(cam, cursor)) {
            Vector3f clickDir;
            Vector3f clickFar = cam.getWorldCoordinates(cursor, 1.0f);
            Vector3f clickNear = cam.getWorldCoordinates(cursor, 0.0f);
            if (this.isTraceEnabled()) {
                this.trace("Creating Viewport ray, clickNear:" + clickNear + " clickFar:" + clickFar);
            }
            if ((clickDir = clickFar.subtractLocal(clickNear).normalizeLocal()).isUnitVector()) {
                result = new Ray(clickNear, clickDir);
            } else {
                if (this.isTraceEnabled()) {
                    this.trace("Camera provided near/far that produced non-unit vector:" + clickDir);
                }
                result = null;
            }
        } else {
            result = null;
        }
        this.rayCache.put(cam, result);
        return result;
    }

    public boolean cursorMoved(int x, int y) {
        return this.cursorMoved(x, y, this.lastScroll);
    }

    public boolean cursorMoved(int x, int y, int scroll) {
        if (this.isTraceEnabled()) {
            this.trace("cursorMoved(" + x + ", " + y + ", scroll=" + scroll + ") capture:" + this.capture);
        }
        int scrollDelta = scroll - this.lastScroll;
        this.lastScroll = scroll;
        Vector2f cursor = new Vector2f((float)x, (float)y);
        CollisionResults results = new CollisionResults();
        Spatial firstHit = null;
        MouseMotionEvent event = null;
        Object target = null;
        this.rayCache.clear();
        this.delivered.clear();
        if (this.capture != null) {
            boolean consumed = false;
            if (this.capture.getControl(MouseEventControl.class) != null) {
                event = new MouseMotionEvent((int)cursor.x, (int)cursor.y, 0, 0, scroll, scrollDelta);
                this.delivered.add(this.capture);
                ((MouseEventControl)this.capture.getControl(MouseEventControl.class)).mouseMoved(event, this.capture, this.capture);
                if (event.isConsumed()) {
                    consumed = true;
                }
            }
            if (this.capture.getControl(CursorEventControl.class) != null) {
                RootEntry captureRoot = this.findRootEntry(this.capture);
                if (captureRoot == null) {
                    return consumed;
                }
                Ray mouseRay = this.getPickRay(captureRoot, cursor);
                if (mouseRay != null) {
                    int count = this.capture.collideWith((Collidable)mouseRay, results);
                    CollisionResult cr = null;
                    if (count > 0) {
                        cr = results.getClosestCollision();
                        results.clear();
                    }
                    CursorMotionEvent cme = new CursorMotionEvent(captureRoot.viewport, this.capture, cursor.x, cursor.y, scroll, scrollDelta, cr);
                    this.delivered.add(this.capture);
                    ((CursorEventControl)this.capture.getControl(CursorEventControl.class)).cursorMoved(cme, this.capture, this.capture);
                    if (cme.isConsumed()) {
                        consumed = true;
                    }
                }
            }
            if (consumed) {
                return true;
            }
        }
        for (RootEntry e : (RootEntry[])this.getRootList().getArray()) {
            Camera cam = e.viewport.getCamera();
            Ray mouseRay = this.getPickRay(e, cursor);
            if (this.isTraceEnabled()) {
                this.trace("Picking against:" + e + " with:" + mouseRay);
            }
            if (mouseRay == null) continue;
            int count = e.root.collideWith((Collidable)mouseRay, results);
            if (count > 0) {
                for (CollisionResult cr : results) {
                    Geometry geom = cr.getGeometry();
                    if (this.isTraceEnabled()) {
                        this.trace("Collision geometry:" + geom);
                    }
                    Spatial hit = this.findHitTarget((Spatial)geom);
                    if (this.isTraceEnabled()) {
                        this.trace("Hit:" + hit);
                    }
                    if (hit == null) continue;
                    if (firstHit == null) {
                        this.setCurrentHitTarget(e.viewport, hit, cursor, cr);
                        firstHit = hit;
                    }
                    if (!this.delivered.add(hit)) continue;
                    boolean consumed = false;
                    if (hit.getControl(MouseEventControl.class) != null) {
                        if (event == null) {
                            event = new MouseMotionEvent((int)cursor.x, (int)cursor.y, 0, 0, scroll, scrollDelta);
                        }
                        ((MouseEventControl)hit.getControl(MouseEventControl.class)).mouseMoved(event, hit, this.capture);
                        if (event.isConsumed()) {
                            consumed = true;
                        }
                    }
                    if (hit.getControl(CursorEventControl.class) != null) {
                        CursorMotionEvent cme = new CursorMotionEvent(e.viewport, hit, cursor.x, cursor.y, scroll, scrollDelta, cr);
                        ((CursorEventControl)hit.getControl(CursorEventControl.class)).cursorMoved(cme, hit, this.capture);
                        if (cme.isConsumed()) {
                            consumed = true;
                        }
                    }
                    if (!consumed) continue;
                    return true;
                }
            } else {
                this.trace("No collisions.");
            }
            results.clear();
        }
        if (firstHit == null) {
            this.setCurrentHitTarget(null, null, cursor, null);
        }
        return false;
    }

    public boolean buttonEvent(int buttonIndex, int x, int y, boolean pressed) {
        AbstractCursorEvent event1 = null;
        MouseButtonEvent event2 = null;
        this.cursorMoved(x, y);
        if (pressed) {
            this.capture = this.hitTarget;
        } else if (this.capture != null) {
            Spatial tempCapture = this.capture;
            this.capture = null;
            boolean consumed = false;
            if (tempCapture.getControl(MouseEventControl.class) != null) {
                event2 = new MouseButtonEvent(buttonIndex, pressed, x, y);
                ((MouseEventControl)tempCapture.getControl(MouseEventControl.class)).mouseButtonEvent(event2, this.hitTarget, tempCapture);
                if (event2.isConsumed()) {
                    consumed = true;
                }
            }
            if (tempCapture.getControl(CursorEventControl.class) != null) {
                event1 = new CursorButtonEvent(buttonIndex, pressed, this.findViewPort(this.hitTarget), this.hitTarget, x, y, null);
                ((CursorEventControl)tempCapture.getControl(CursorEventControl.class)).cursorButtonEvent((CursorButtonEvent)event1, this.hitTarget, tempCapture);
                if (event1.isConsumed()) {
                    consumed = true;
                }
            }
            if (consumed) {
                return true;
            }
            if (tempCapture == this.hitTarget) {
                return false;
            }
        }
        if (this.hitTarget == null) {
            return false;
        }
        boolean consumed = false;
        if (this.hitTarget.getControl(MouseEventControl.class) != null) {
            if (event2 == null) {
                event2 = new MouseButtonEvent(buttonIndex, pressed, x, y);
            }
            ((MouseEventControl)this.hitTarget.getControl(MouseEventControl.class)).mouseButtonEvent(event2, this.hitTarget, this.capture);
            if (event2.isConsumed()) {
                consumed = true;
            }
        }
        if (this.hitTarget.getControl(CursorEventControl.class) != null) {
            if (event1 == null) {
                event1 = new CursorButtonEvent(buttonIndex, pressed, this.findViewPort(this.hitTarget), this.hitTarget, x, y, null);
            }
            ((CursorEventControl)this.hitTarget.getControl(CursorEventControl.class)).cursorButtonEvent((CursorButtonEvent)event1, this.hitTarget, this.capture);
            if (event1.isConsumed()) {
                consumed = true;
            }
        }
        return consumed;
    }

    public static class RootEntry {
        public ViewPort viewport;
        public Collidable root;
        public String layer;

        public RootEntry(Collidable root, ViewPort viewport, String layer) {
            this.viewport = viewport;
            this.root = root;
            this.layer = layer;
        }

        public String toString() {
            return "RootEntry[viewport=" + this.viewport + ", root=" + this.root + ", layer=" + this.layer + "]";
        }
    }
}

