/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Insets3f;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.ProgressBar;
import com.simsilica.lemur.RangedValueModel;
import com.simsilica.lemur.component.BorderLayout;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.style.ElementId;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import mythruna.client.GuiState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(ProgressState.class);
    private Container progressWindow;
    private Container progressContainer;
    private ColorRGBA background = new ColorRGBA(0.0f, 0.0f, 0.0f, 0.5f);
    private Map<String, ProgressTracker> trackerIndex = new ConcurrentHashMap<String, ProgressTracker>();
    private LinkedList<ProgressTracker> active = new LinkedList();
    private ConcurrentLinkedQueue<ProgressTracker> pendingDone = new ConcurrentLinkedQueue();
    private volatile boolean invalid;
    private Thread renderThread;

    public ProgressState() {
        this.setEnabled(false);
    }

    public ProgressTracker createTracker(String id, String text) {
        if (this.trackerIndex.containsKey(id)) {
            throw new IllegalArgumentException("Tracker already exists for:" + id);
        }
        ProgressTracker result = new ProgressTracker(id, text);
        this.trackerIndex.put(id, result);
        this.runOnRender(() -> {
            this.markActive(result);
            this.setEnabled(true);
        });
        return result;
    }

    public ProgressTracker getTracker(String id, boolean create) {
        ProgressTracker result = this.trackerIndex.get(id);
        if (result == null && create) {
            result = this.createTracker(id, "");
        }
        return result;
    }

    public ProgressTracker getTracker(String id) {
        return this.getTracker(id, false);
    }

    public void closeTracker(String id) {
        ProgressTracker tracker = this.getTracker(id);
        if (tracker == null) {
            return;
        }
        tracker.close();
    }

    public boolean isRenderThread() {
        return Thread.currentThread() == this.renderThread;
    }

    protected void runOnRender(Runnable r) {
        if (this.isRenderThread()) {
            r.run();
        } else {
            this.getApplication().enqueue(r);
        }
    }

    protected void initialize(Application app) {
        this.renderThread = Thread.currentThread();
        this.progressWindow = new Container((GuiLayout)new BorderLayout(), new ElementId("popup"));
        this.progressWindow.setLocalScale(1.5f);
        this.progressContainer = new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.Last, FillMode.Even), new ElementId("progress.container"));
        this.progressWindow.addChild((Node)this.progressContainer, new Object[0]);
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        ((GuiState)this.getState(GuiState.class)).center((Panel)this.progressWindow);
        GuiGlobals.getInstance().getPopupState().showModalPopup((Spatial)this.progressWindow, this.background);
    }

    protected void onDisable() {
        GuiGlobals.getInstance().getPopupState().closePopup((Spatial)this.progressWindow);
    }

    public void update(float tpf) {
        if (!this.trackerIndex.isEmpty()) {
            for (ProgressTracker tracker : this.trackerIndex.values()) {
                if (tracker.isDone()) {
                    tracker.close();
                    continue;
                }
                if (!tracker.update()) continue;
                this.markActive(tracker);
            }
        }
        if (!this.pendingDone.isEmpty()) {
            ProgressTracker tracker = null;
            while ((tracker = this.pendingDone.poll()) != null) {
                this.remove(tracker);
            }
        }
        if (this.invalid) {
            this.validate();
        }
    }

    protected void validate() {
        this.progressContainer.clearChildren();
        if (this.active.isEmpty()) {
            this.setEnabled(false);
            return;
        }
        for (ProgressTracker tracker : this.active) {
            this.progressContainer.addChild((Node)tracker.label, new Object[0]);
            if (tracker.value == null) continue;
            this.progressContainer.addChild((Node)tracker.progress, new Object[0]);
        }
        ((GuiState)this.getState(GuiState.class)).center((Panel)this.progressWindow);
    }

    protected void remove(ProgressTracker tracker) {
        this.active.remove(tracker);
        this.trackerIndex.remove(tracker.id);
        this.invalid = true;
    }

    protected void markDone(ProgressTracker tracker) {
        this.pendingDone.add(tracker);
    }

    protected void markActive(ProgressTracker tracker) {
        this.active.remove(tracker);
        if (!this.trackerIndex.containsKey(tracker.id)) {
            return;
        }
        this.active.addFirst(tracker);
        if (this.active.size() > 3) {
            this.active.removeLast();
        }
        this.invalid = true;
    }

    public class ProgressTracker {
        private String id;
        private VersionedHolder<String> text;
        private RangedValueModel value;
        private VersionedReference<String> textRef;
        private VersionedReference<Double> valueRef;
        private Label label;
        private ProgressBar progress;

        public ProgressTracker(String id, String text) {
            this.id = id;
            this.text = new VersionedHolder((Object)text);
            this.textRef = this.text.createReference();
            this.label = new Label(text, new ElementId("progress.label"));
            this.label.setFontSize(24.0f);
            this.label.setInsets(new Insets3f(5.0f, 15.0f, 5.0f, 15.0f));
            this.progress = new ProgressBar();
        }

        public boolean update() {
            boolean changed = false;
            if (this.textRef.update()) {
                this.label.setText((String)this.textRef.get());
                changed = true;
            }
            if (this.valueRef != null && this.valueRef.update()) {
                changed = true;
            }
            return changed;
        }

        public void setText(String text) {
            ProgressState.this.runOnRender(() -> this.text.updateObject((Object)text));
        }

        public String getText() {
            return (String)this.text.getObject();
        }

        public void setValue(RangedValueModel value) {
            if (this.value == value) {
                return;
            }
            this.value = value;
            ProgressState.this.runOnRender(() -> {
                this.progress.setModel(value);
                ProgressState.this.markActive(this);
            });
        }

        public RangedValueModel getValue() {
            return this.value;
        }

        public boolean isDone() {
            if (this.text.getObject() == null) {
                return true;
            }
            return this.value != null && this.value.getPercent() >= 1.0;
        }

        public void close() {
            ProgressState.this.markDone(this);
        }
    }
}

