/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.props.PropertyPanel;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.mworld.view.FarTerrainState;
import com.simsilica.mworld.view.FogSettings;
import com.simsilica.mworld.view.PointCloudState;
import com.simsilica.mworld.view.TerrainState;
import com.simsilica.mworld.view.TreeState;
import com.simsilica.state.BlackboardState;
import mythruna.client.GameSessionState;
import mythruna.client.GameSettingsState;
import mythruna.client.GuiState;
import mythruna.client.MythrunaConfig;
import mythruna.client.view.HudStatsState;
import mythruna.client.view.WorldViewState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InGameMenuState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(InGameMenuState.class);
    private Container window;
    private Container inGameDebug;
    private Label farTerrainTriangleCountLabel;
    private VersionedReference<Integer> farTerrainTriangleCount;
    private Label farFluidTriangleCountLabel;
    private VersionedReference<Integer> farFluidTriangleCount;
    private Label nearTriangleCountLabel;
    private VersionedReference<Integer> nearTriangleCount;
    private int terrainLevel = 2;

    public InGameMenuState() {
        this.setEnabled(false);
    }

    public void toggleEnabled() {
        this.setEnabled(!this.isEnabled());
    }

    protected void resume() {
        ((GameSessionState)this.getState(GameSessionState.class)).trigger("returnToGame");
    }

    protected void leaveWorld() {
        log.info("Leave world...");
        ((GameSessionState)this.getState(GameSessionState.class)).exit();
    }

    protected void settings() {
        this.setEnabled(false);
        ((GameSessionState)this.getState(GameSessionState.class)).trigger("openSettingsMenu");
    }

    protected void exit() {
        log.info("Exit.");
        ((GameSessionState)this.getState(GameSessionState.class)).exit();
        this.getApplication().stop();
    }

    protected void initialize(Application app) {
        this.window = new Container(new ElementId("popup"));
        this.window.addChild((Node)new Label("Game Menu", new ElementId("window.title")), new Object[0]);
        Container menu = (Container)this.window.addChild((Node)new Container(), new Object[0]);
        menu.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "resume")), new Object[0]);
        menu.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "leaveWorld")), new Object[0]);
        menu.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "settings")), new Object[0]);
        menu.addChild((Node)new ActionButton((Action)new CallMethodAction("Exit Game", (Object)this, "exit")), new Object[0]);
        this.inGameDebug = new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y)){

            public void updateLogicalState(float tpf) {
                super.updateLogicalState(tpf);
                InGameMenuState.this.updateCounts();
            }
        };
        MythrunaConfig config = MythrunaConfig.getInstance();
        Container column = (Container)this.inGameDebug.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.Last, FillMode.Even)), new Object[0]);
        PropertyPanel general = (PropertyPanel)column.addChild((Node)new PropertyPanel(null), new Object[0]);
        ((HudStatsState)this.getState(HudStatsState.class, true)).setEnabled(config.getStartupSetting("HudStatsState.enabled", true));
        general.addBooleanProperty("Show Debug HUD", (Object)this.getState(HudStatsState.class, true), "enabled");
        general.addBooleanProperty("Shader Debug/Test Mode", (Object)this.getState(WorldViewState.class, true), "debugTestEnabled");
        column.addChild((Node)new Label("Blocks:"), new Object[0]);
        PropertyPanel blockDebug = (PropertyPanel)column.addChild((Node)new PropertyPanel(null), new Object[0]);
        ((WorldViewState)this.getState(WorldViewState.class, true)).setEnabled(config.getStartupSetting("WorldViewState.enabled", true));
        blockDebug.addBooleanProperty("Enabled", (Object)this.getState(WorldViewState.class, true), "enabled");
        ((WorldViewState)this.getState(WorldViewState.class, true)).setViewRadius(config.getStartupSetting("WorldViewState.viewRadius", 3));
        blockDebug.addIntProperty("Clip", (Object)this.getState(WorldViewState.class, true), "viewRadius", 1, 7, 1);
        ((WorldViewState)this.getState(WorldViewState.class, true)).setSmoothLighting(config.getStartupSetting("WorldViewState.smoothLighting", true));
        blockDebug.addBooleanProperty("Smooth Lighting", (Object)this.getState(WorldViewState.class, true), "smoothLighting");
        blockDebug.addBooleanProperty("View Mask Debug", (Object)this.getState(WorldViewState.class, true), "maskDebug");
        column.addChild((Node)new Label("Level of Detail:"), new Object[0]);
        PropertyPanel lodDebug = (PropertyPanel)column.addChild((Node)new PropertyPanel(null), new Object[0]);
        ((TreeState)this.getState(TreeState.class, true)).setEnabled(config.getStartupSetting("TreeState.enabled", true).booleanValue());
        lodDebug.addBooleanProperty("Far Trees", (Object)this.getState(TreeState.class, true), "enabled");
        ((PointCloudState)this.getState(PointCloudState.class, true)).setEnabled(config.getStartupSetting("PointCloudState.enabled", true).booleanValue());
        lodDebug.addBooleanProperty("Far Structures", (Object)this.getState(PointCloudState.class, true), "enabled");
        this.setTerrainLevel2(config.getStartupSetting("DebugSettings.terrainLevel", 2.0));
        lodDebug.addIntProperty("Terrain Level", (Object)this, "terrainLevel", 0, 2, 1);
        TerrainState nearTerrain = (TerrainState)this.getState(TerrainState.class);
        FarTerrainState farTerrain = (FarTerrainState)this.getState(FarTerrainState.class);
        this.farTerrainTriangleCount = farTerrain.getTerrainTriangleCount();
        this.farFluidTriangleCount = farTerrain.getFluidTriangleCount();
        this.nearTriangleCount = nearTerrain.getTriangleCount();
        column.addChild((Node)new Label(""), new Object[0]);
        column = (Container)this.inGameDebug.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.Last, FillMode.Even)), new Object[0]);
        column.addChild((Node)new Label("Mid Terrain:"), new Object[0]);
        PropertyPanel nearDebug = (PropertyPanel)column.addChild((Node)new PropertyPanel(null), new Object[0]);
        nearDebug.addBooleanProperty("Wire Frame", (Object)nearTerrain, "wireframe");
        nearDebug.addIntProperty("Radials", (Object)nearTerrain, "radials", 90, 1440, 90);
        nearDebug.addDoubleProperty("Ring Min. Step", (Object)nearTerrain, "minStep", 0.1, 5.0, 0.1);
        nearDebug.addDoubleProperty("Ring Growth", (Object)nearTerrain, "growth", 0.1, 5.0, 0.1);
        nearDebug.addFloatProperty("Horz. Limit", (Object)nearTerrain, "horizontalLimit", 0.0f, 1.0f, 0.001f);
        nearDebug.addFloatProperty("Vert. Limit", (Object)nearTerrain, "verticalLimit", 0.0f, 1.0f, 0.001f);
        nearDebug.getContainer().addChild((Node)new Label("Mesh:"), new Object[0]);
        this.nearTriangleCountLabel = (Label)nearDebug.getContainer().addChild((Node)new Label(String.format("%,d tris", this.nearTriangleCount.get())), new Object[]{1});
        column.addChild((Node)new Label("Far Terrain:"), new Object[0]);
        PropertyPanel farDebug = (PropertyPanel)column.addChild((Node)new PropertyPanel(null), new Object[0]);
        farDebug.addBooleanProperty("Wire Frame", (Object)farTerrain, "wireframe");
        farDebug.addIntProperty("Radials", (Object)farTerrain, "radials", 90, 1440, 90);
        farDebug.addDoubleProperty("Ring Min. Step", (Object)farTerrain, "minStep", 0.1, 5.0, 0.1);
        farDebug.addDoubleProperty("Ring Growth", (Object)farTerrain, "growth", 0.1, 5.0, 0.1);
        farDebug.addFloatProperty("Horz. Limit", (Object)farTerrain, "horizontalLimit", 0.0f, 1.0f, 0.001f);
        farDebug.addFloatProperty("Vert. Limit", (Object)farTerrain, "verticalLimit", 0.0f, 1.0f, 0.001f);
        farDebug.getContainer().addChild((Node)new Label("Terrain mesh:"), new Object[0]);
        this.farTerrainTriangleCountLabel = (Label)farDebug.getContainer().addChild((Node)new Label(String.format("%,d tris", this.farTerrainTriangleCount.get())), new Object[]{1});
        farDebug.getContainer().addChild((Node)new Label("Fluid mesh:"), new Object[0]);
        this.farFluidTriangleCountLabel = (Label)farDebug.getContainer().addChild((Node)new Label(String.format("%,d tris", this.farFluidTriangleCount.get())), new Object[]{1});
        column.addChild((Node)new Label(""), new Object[0]);
        ((GameSettingsState)this.getState(GameSettingsState.class)).getDebugPanel().addChild((Node)this.inGameDebug, new Object[0]);
    }

    public void setTerrainLevel2(double terrainLevel) {
        this.setTerrainLevel((int)terrainLevel);
    }

    public void setTerrainLevel(int terrainLevel) {
        if (this.terrainLevel == terrainLevel) {
            return;
        }
        this.terrainLevel = terrainLevel;
        this.resetTerrainLevel();
    }

    public int getTerrainLevel() {
        return this.terrainLevel;
    }

    protected void resetTerrainLevel() {
        FogSettings fogSettings = (FogSettings)((BlackboardState)this.getState(BlackboardState.class)).get(FogSettings.class);
        switch (this.terrainLevel) {
            case 0: {
                ((FarTerrainState)this.getState(FarTerrainState.class)).setEnabled(false);
                ((TerrainState)this.getState(TerrainState.class)).setEnabled(false);
                fogSettings.setFogDistance(((WorldViewState)this.getState(WorldViewState.class, true)).getViewRadius() * 32);
                ((PointCloudState)this.getState(PointCloudState.class)).setClipDistance((float)(((WorldViewState)this.getState(WorldViewState.class, true)).getViewRadius() * 32));
                ((TreeState)this.getState(TreeState.class)).setClipDistance((float)(((WorldViewState)this.getState(WorldViewState.class, true)).getViewRadius() * 32));
                break;
            }
            case 1: {
                ((FarTerrainState)this.getState(FarTerrainState.class)).setEnabled(false);
                ((TerrainState)this.getState(TerrainState.class)).setEnabled(true);
                fogSettings.setFogDistance(512);
                ((PointCloudState)this.getState(PointCloudState.class)).setClipDistance(512.0f);
                ((TreeState)this.getState(TreeState.class)).setClipDistance(512.0f);
                break;
            }
            default: {
                ((TerrainState)this.getState(TerrainState.class)).setEnabled(true);
                ((FarTerrainState)this.getState(FarTerrainState.class)).setEnabled(true);
                fogSettings.setFogDistance(3072);
                ((PointCloudState)this.getState(PointCloudState.class)).setClipDistance(3072.0f);
                ((TreeState)this.getState(TreeState.class)).setClipDistance(3072.0f);
            }
        }
    }

    protected void updateCounts() {
        if (this.farTerrainTriangleCount.update()) {
            this.farTerrainTriangleCountLabel.setText(String.format("%,d tris", this.farTerrainTriangleCount.get()));
        }
        if (this.farFluidTriangleCount.update()) {
            this.farFluidTriangleCountLabel.setText(String.format("%,d tris", this.farFluidTriangleCount.get()));
        }
        if (this.nearTriangleCount.update()) {
            this.nearTriangleCountLabel.setText(String.format("%,d tris", this.nearTriangleCount.get()));
        }
    }

    protected void cleanup(Application app) {
        ((GameSettingsState)this.getState(GameSettingsState.class)).getDebugPanel().removeChild((Node)this.inGameDebug);
    }

    protected void onEnable() {
        this.getApplication().enqueue(() -> {
            ((GuiState)this.getState(GuiState.class)).center((Panel)this.window);
            GuiGlobals.getInstance().getPopupState().showModalPopup((Spatial)this.window, new ColorRGBA(0.0f, 0.0f, 0.0f, 0.75f));
        });
    }

    public void update(float tpf) {
    }

    protected void onDisable() {
        this.window.removeFromParent();
    }
}

