/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.renderer.Camera;
import com.simsilica.bpos.BodyPosition;
import com.simsilica.bpos.ChildPositionTransition3d;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.WatchedEntity;
import com.simsilica.ext.mphys.SpawnPosition;
import com.simsilica.input.AbstractMovementTarget;
import com.simsilica.input.MovementState;
import com.simsilica.input.MovementTarget;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.input.Button;
import com.simsilica.lemur.input.FunctionId;
import com.simsilica.lemur.input.InputMapper;
import com.simsilica.lemur.input.InputState;
import com.simsilica.mathd.GridCell;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Rayd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.trans.PositionTransition3d;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mblock.phys.Collider;
import com.simsilica.mblock.phys.MBlockCollisionSystem;
import com.simsilica.mblock.phys.collision.ColliderFactories;
import com.simsilica.mworld.BlockIterator;
import com.simsilica.mworld.World;
import com.simsilica.state.BlackboardState;
import com.simsilica.state.CameraState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import mythruna.GameConstants;
import mythruna.client.GameSessionState;
import mythruna.client.GameSettingsState;
import mythruna.client.MainGameFunctions;
import mythruna.client.net.ConnectionState;
import mythruna.client.net.HostedGameState;
import mythruna.client.net.TimeState;
import mythruna.client.view.ShellState;
import mythruna.es.MovementInput;
import mythruna.net.DefaultGameSessionListener;
import mythruna.net.GameSession;
import mythruna.net.GameSessionListener;
import mythruna.shell.AbstractShellCommand;
import mythruna.shell.CommandShell;
import mythruna.shell.ShellCommand;
import mythruna.sim.PathBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvatarState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(AvatarState.class);
    public static final FunctionId F_SUPER_RUN = new FunctionId("Movement", "Super Run");
    public static final FunctionId F_JUMP = new FunctionId("Movement", "Jump");
    public static final double DISTANCE_EPSILON = 1.0E-4;
    public static final double DISTANCE_EPSILON_SQ = 1.0E-8;
    private EntityData ed;
    private EntityId avatarId;
    private GameSession session;
    private SessionObserver sessionObserver = new SessionObserver();
    private World world;
    private MBlockCollisionSystem collisionSystem;
    private VersionedHolder<Vec3d> viewPosition = new VersionedHolder((Object)new Vec3d());
    private VersionedHolder<Quatd> viewOrientation = new VersionedHolder((Object)new Quatd());
    private Camera camera;
    private WalkHandler movementHandler = new WalkHandler();
    private VersionedHolder<Vec3d> eyePosition = new VersionedHolder((Object)new Vec3d());
    private VersionedHolder<Quatd> cameraOrientation = new VersionedHolder((Object)new Quatd());
    private WatchedEntity self;
    private TimeState time;
    private PathBuffer pathBuffer;
    private TapeTask tape;
    private boolean playback = false;
    private boolean thirdPerson = false;
    private VersionedReference<Boolean> invertYRef;

    public EntityId getAvatarId() {
        return this.avatarId;
    }

    public void toggleThirdPerson() {
        this.thirdPerson = !this.thirdPerson;
    }

    public Vec3d getPosition() {
        return (Vec3d)this.viewPosition.getObject();
    }

    public Vec3d getEyePosition() {
        return (Vec3d)this.eyePosition.getObject();
    }

    public Quatd getViewFacing() {
        return (Quatd)this.viewOrientation.getObject();
    }

    public Quatd getCameraFacing() {
        return (Quatd)this.cameraOrientation.getObject();
    }

    public VersionedReference<Vec3d> createPositionReference() {
        return this.viewPosition.createReference();
    }

    public VersionedReference<Quatd> createOrientationReference() {
        return this.viewOrientation.createReference();
    }

    public VersionedReference<Vec3d> createEyePositionReference() {
        return this.eyePosition.createReference();
    }

    public VersionedReference<Quatd> createCameraOrientationReference() {
        return this.cameraOrientation.createReference();
    }

    public Rayd getViewRay() {
        Vec3d dir = this.movementHandler.rotation.mult(Vec3d.UNIT_Z);
        dir.normalizeLocal();
        Rayd ray = new Rayd((Vec3d)this.eyePosition.getObject(), dir);
        return ray;
    }

    public Iterator<BlockIterator.Intersection> pick(Rayd ray, int distance) {
        if (this.world == null) {
            List empty = Collections.emptyList();
            return empty.iterator();
        }
        return this.collisionSystem.rayIterator(ray, (double)distance);
    }

    public Iterator<BlockIterator.Intersection> pick(int distance) {
        if (this.world == null) {
            List empty = Collections.emptyList();
            return empty.iterator();
        }
        return this.pick(this.getViewRay(), distance);
    }

    public void record() {
        log.info("record()");
        this.pathBuffer = new PathBuffer();
        this.tape = new RecordTask(this.pathBuffer);
    }

    public void play() {
        log.info("play()");
        if (this.pathBuffer == null) {
            return;
        }
        this.tape = new PlayTask(this.pathBuffer);
    }

    public void stop() {
        log.info("stop()");
        this.tape = null;
        this.playback = false;
    }

    protected void initialize(Application app) {
        this.invertYRef = ((GameSettingsState)this.getState(GameSettingsState.class, true)).createInvertYRef();
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.map(F_SUPER_RUN, 29, new Object[0]);
        inputMapper.map(F_SUPER_RUN, 157, new Object[0]);
        inputMapper.map(F_JUMP, 57, new Object[0]);
        inputMapper.map(F_JUMP, Button.JOYSTICK_BUTTON2, new Object[0]);
        ((BlackboardState)this.getState(BlackboardState.class)).set("position", this.viewPosition);
        ((BlackboardState)this.getState(BlackboardState.class)).set("orientation", this.viewOrientation);
        this.camera = ((CameraState)this.getState(CameraState.class, true)).getCamera();
        this.ed = ((ConnectionState)this.getState(ConnectionState.class, true)).getEntityData();
        this.time = (TimeState)this.getState(TimeState.class, true);
        GameSessionState sessionState = (GameSessionState)this.getState(GameSessionState.class, true);
        sessionState.addGameSessionListener((GameSessionListener)this.sessionObserver);
        this.session = sessionState.getGameSession();
        this.avatarId = this.session.getAvatar();
        this.world = sessionState.getWorld();
        Collider[] colliders = new ColliderFactories(true).createColliders(BlockTypeIndex.getTypes());
        this.collisionSystem = new MBlockCollisionSystem(this.world, colliders);
        log.info("Avatar:" + this.avatarId);
        SpawnPosition pos = (SpawnPosition)this.ed.getComponent(this.avatarId, SpawnPosition.class);
        log.info("spawn:" + pos);
        this.viewPosition.setObject((Object)pos.getLocation().add(0.0, 0.8, 0.0));
        this.viewOrientation.setObject((Object)pos.getOrientation());
        this.self = this.ed.watchEntity(this.avatarId, new Class[]{BodyPosition.class});
        log.info("self:" + this.self);
        BodyPosition bPos = (BodyPosition)this.self.get(BodyPosition.class);
        log.info("self pos:" + bPos);
        if (bPos != null) {
            bPos.initialize(this.avatarId, 12);
        }
        if (this.getState(HostedGameState.class) != null && ((HostedGameState)this.getState(HostedGameState.class)).isSinglePlayer()) {
            CommandShell clientShell = ((ShellState)this.getState(ShellState.class, true)).getClientShell();
            clientShell.addCommand("record", (ShellCommand)new RecordCommand());
            clientShell.addCommand("stop", (ShellCommand)new StopCommand());
            clientShell.addCommand("play", (ShellCommand)new PlayCommand());
        }
    }

    protected void cleanup(Application app) {
        GameSessionState sessionState = (GameSessionState)this.getState(GameSessionState.class, false);
        if (sessionState != null) {
            sessionState.removeGameSessionListener((GameSessionListener)this.sessionObserver);
        }
    }

    protected void onEnable() {
        ((MovementState)this.getState(MovementState.class, true)).setMovementTarget((MovementTarget)this.movementHandler);
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.addDelegate(F_SUPER_RUN, (Object)this.movementHandler, "setSuperRun", true);
        inputMapper.addDelegate(F_JUMP, (Object)this.movementHandler, "setJump", true);
        inputMapper.addDelegate(MainGameFunctions.F_THIRD_PERSON, (Object)this, "toggleThirdPerson");
        ((MovementState)this.getState(MovementState.class, true)).setInvertPitch(((Boolean)this.invertYRef.get()).booleanValue());
    }

    protected void onDisable() {
        ((MovementState)this.getState(MovementState.class, true)).setMovementTarget(null);
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.removeDelegate(F_SUPER_RUN, (Object)this.movementHandler, "setSuperRun");
        inputMapper.removeDelegate(F_JUMP, (Object)this.movementHandler, "setJump");
        inputMapper.removeDelegate(MainGameFunctions.F_THIRD_PERSON, (Object)this, "toggleThirdPerson");
    }

    public void update(float tpf) {
        if (this.invertYRef.update()) {
            ((MovementState)this.getState(MovementState.class, true)).setInvertPitch(((Boolean)this.invertYRef.get()).booleanValue());
        }
        if (this.tape != null && !this.tape.update(this.time.getTime())) {
            this.tape = null;
        }
        if (!this.playback) {
            this.movementHandler.send();
            this.camera.setRotation(this.movementHandler.rotation.toQuaternion());
        }
        if (this.self.applyChanges()) {
            log.info("self changes");
            BodyPosition bPos = (BodyPosition)this.self.get(BodyPosition.class);
            log.info("self pos update:" + bPos);
            if (bPos != null) {
                bPos.initialize(this.avatarId, 12);
            }
        } else {
            BodyPosition bPos = (BodyPosition)this.self.get(BodyPosition.class);
            this.updateAvatarPosition(bPos);
        }
    }

    protected void updateAvatarPosition(BodyPosition bPos) {
        long t = this.time.getTime();
        if (bPos == null) {
            log.warn("Body position is null");
            return;
        }
        ChildPositionTransition3d frame = bPos.getFrame(t);
        if (frame == null) {
            if (t != 0L) {
                log.warn("no transition frame for time:" + t);
            }
            return;
        }
        Vec3d v = frame.getPosition(t, true);
        if (v.distanceSq((Vec3d)this.viewPosition.getObject()) > 1.0E-8) {
            this.viewPosition.setObject((Object)v.clone());
            this.eyePosition.setObject((Object)v.add(this.calculateEyeOffset()));
        }
        Quatd q = frame.getRotation(t, true);
        this.viewOrientation.setObject((Object)q.clone());
        GridCell cell = GameConstants.LEAF_GRID.getContainingCell(v);
        v.x -= (double)cell.getWorldOrigin().x;
        v.z -= (double)cell.getWorldOrigin().z;
        v.addLocal(this.calculateCameraOffset());
        this.camera.setLocation(v.toVector3f());
    }

    protected Vec3d calculateEyeOffset() {
        return new Vec3d(0.0, 1.5, 0.0);
    }

    protected Vec3d calculateCameraOffset() {
        Vec3d eye = new Vec3d(0.0, 1.5, 0.0);
        if (this.thirdPerson) {
            Vec3d back = new Vec3d(this.camera.getDirection().mult(-3.0f));
            eye.addLocal(back);
        } else {
            Vec3d fwd = new Vec3d(this.camera.getDirection().mult(0.1f));
            eye.addLocal(fwd);
        }
        return eye;
    }

    private class SessionObserver
    extends DefaultGameSessionListener {
        private SessionObserver() {
        }

        public void setAvatar(EntityId avatar) {
            log.info("setAvatar(" + avatar + ")");
        }
    }

    public class WalkHandler
    extends AbstractMovementTarget {
        private Quatd rotation = new Quatd();
        private Vec3d forces = new Vec3d();
        private MovementInput lastSent = null;
        private boolean superRun = false;
        private boolean jump = false;
        private int flags = 0;

        public void setSuperRun(InputState state) {
            this.superRun = state == InputState.Positive;
        }

        public void setJump(InputState state) {
            this.jump = state == InputState.Positive;
            this.resetFlags();
        }

        protected void resetFlags() {
            this.flags = 0;
            if (this.jump) {
                this.flags |= 1;
            }
        }

        public void move(Quatd rotation, Vec3d movementForces, double tpf) {
            this.rotation.set(rotation);
            if (this.superRun) {
                this.forces.set(movementForces.mult(4.0));
            } else {
                this.forces.set(movementForces);
            }
        }

        public void setRotation(Quatd rotation) {
            this.rotation.set(rotation);
            AvatarState.this.cameraOrientation.setObject((Object)this.rotation);
        }

        public Quatd getRotation() {
            return this.rotation;
        }

        public void send() {
            MovementInput move = new MovementInput(this.forces.clone(), this.rotation.clone(), (byte)this.flags);
            if (move.equals((Object)this.lastSent)) {
                return;
            }
            this.lastSent = move;
            AvatarState.this.session.setMovementInput(move);
        }
    }

    private class RecordTask
    implements TapeTask {
        PathBuffer buffer;

        public RecordTask(PathBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public long getDuration() {
            return this.buffer.getDuration();
        }

        @Override
        public boolean update(long time) {
            Vec3d pos = new Vec3d(AvatarState.this.camera.getLocation());
            Quatd quat = new Quatd(AvatarState.this.camera.getRotation());
            this.buffer.addFrame(time, pos, quat);
            return true;
        }
    }

    private static interface TapeTask {
        public boolean update(long var1);

        public long getDuration();
    }

    private class PlayTask
    implements TapeTask {
        PathBuffer buffer;
        private List<PositionTransition3d> frames = new ArrayList<PositionTransition3d>();
        private PositionTransition3d currentFrame;
        private Long startTime = null;
        private long currentTime;
        private int currentIndex;

        public PlayTask(PathBuffer buffer) {
            this.buffer = buffer;
            this.frames = buffer.getFrames();
            this.currentTime = 0L;
            this.currentIndex = 0;
            this.currentFrame = this.frames.get(this.currentIndex);
            AvatarState.this.playback = true;
        }

        @Override
        public long getDuration() {
            return this.startTime == null ? -1L : this.currentTime - this.startTime;
        }

        @Override
        public boolean update(long time) {
            if (!this.advance(time)) {
                AvatarState.this.playback = false;
                return false;
            }
            AvatarState.this.camera.setLocation(this.currentFrame.getPosition(this.currentTime, true).toVector3f());
            AvatarState.this.camera.setRotation(this.currentFrame.getRotation(this.currentTime, true).toQuaternion());
            return true;
        }

        protected boolean advance(long time) {
            if (this.startTime == null) {
                this.startTime = time;
                time = 0L;
            } else {
                time -= this.startTime.longValue();
            }
            if (this.currentFrame.containsTime(time)) {
                this.currentTime = time;
                return true;
            }
            while (this.currentIndex < this.frames.size()) {
                this.currentFrame = this.frames.get(this.currentIndex);
                if (this.currentFrame.containsTime(time)) {
                    this.currentTime = time;
                    return true;
                }
                ++this.currentIndex;
            }
            return false;
        }
    }

    private class RecordCommand
    extends AbstractShellCommand {
        public RecordCommand() {
            super(new String[]{"Records the movement of the player."});
        }

        public Object execute(CommandShell shell, String args) {
            AvatarState.this.session.executeCommand("record", AvatarState.this.avatarId, new Object[0]);
            AvatarState.this.record();
            return null;
        }
    }

    private class StopCommand
    extends AbstractShellCommand {
        public StopCommand() {
            super(new String[]{"Stops and playback or recording."});
        }

        public Object execute(CommandShell shell, String args) {
            AvatarState.this.session.executeCommand("stop", AvatarState.this.avatarId, new Object[0]);
            AvatarState.this.stop();
            return null;
        }
    }

    private class PlayCommand
    extends AbstractShellCommand {
        public PlayCommand() {
            super(new String[]{"Plays back previously recorded player movement."});
        }

        public Object execute(CommandShell shell, String args) {
            AvatarState.this.session.executeCommand("play", AvatarState.this.avatarId, new Object[0]);
            AvatarState.this.play();
            return null;
        }
    }
}

