/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view;

import com.simsilica.es.EntityId;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Rayd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mworld.BlockIterator;
import java.util.Iterator;
import mythruna.client.view.AvatarState;
import mythruna.client.view.ManipulatorType;
import mythruna.client.view.ModelViewState;
import mythruna.client.view.PickedObject;
import mythruna.net.GameSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandManipulator
implements ManipulatorType {
    static Logger log = LoggerFactory.getLogger(HandManipulator.class);
    private GameSession session;
    private EntityId target;
    private AvatarState avatar;
    private ModelViewState models;
    private PickedObject selected;
    private boolean dragging;
    private BlockIterator.Intersection lastHit;
    private Vec3d clickPos = new Vec3d();
    private Vec3d objectPos = new Vec3d();
    private Quatd objectFacing = new Quatd();

    public HandManipulator(GameSession session, AvatarState avatar, ModelViewState models) {
        this.session = session;
        this.avatar = avatar;
        this.models = models;
    }

    @Override
    public void setTarget(EntityId target) {
        this.target = target;
    }

    public EntityId getTarget() {
        return this.target;
    }

    protected GameSession getSession() {
        return this.session;
    }

    @Override
    public void update(float tpf) {
    }

    protected void captureClick() {
        Vec3d pos = this.models.getModelPosition(this.selected.entityId);
        log.info("Clicked model position:" + pos);
        if (pos == null) {
            log.warn("Unabled to determine position of clicked model:" + this.selected);
            return;
        }
        Quatd orient = this.models.getModelRotation(this.selected.entityId);
        Vec3d avatarPos = this.avatar.getEyePosition();
        this.clickPos.set(this.selected.location).subtractLocal(avatarPos);
        this.objectPos.set(pos).subtractLocal(avatarPos);
        log.info("Raw relative click pos:" + this.clickPos + "  objectPos:" + this.objectPos);
        Quatd facing = this.avatar.getCameraFacing();
        log.info("dir:" + facing.mult(new Vec3d(0.0, 0.0, 1.0)));
        Quatd inverse = facing.inverse();
        inverse.mult(this.clickPos, this.clickPos);
        inverse.mult(this.objectPos, this.objectPos);
        this.objectFacing = inverse.mult(orient);
        log.info("Click pos:" + this.clickPos + "  objectPos:" + this.objectPos);
    }

    protected Object[] getDragArgs(Vec3d pos, Quatd facing) {
        Vec3d v1 = facing.mult(this.objectPos).addLocal(pos);
        Vec3d v2 = facing.mult(this.clickPos).addLocal(pos);
        Quatd q = facing.mult(this.objectFacing);
        return new Object[]{this.selected.entityId, v1, q, v2};
    }

    protected void startDragging(Vec3d pos, Quatd facing) {
        this.dragging = true;
        this.session.runAction(this.target, "dragStart", this.getDragArgs(pos, facing));
    }

    protected void drag(Vec3d pos, Quatd facing) {
        this.session.runAction(this.target, "drag", this.getDragArgs(pos, facing));
    }

    protected void stopDragging() {
        this.session.runAction(this.target, "dragEnd", new Object[]{this.selected.entityId});
        this.dragging = false;
        this.selected = null;
    }

    protected void altPressObject(PickedObject object) {
        this.selected = object;
        this.captureClick();
    }

    protected void altClickObject(PickedObject object) {
        this.session.runAction(this.target, "contextAction", new Object[]{object.entityId, object.location});
    }

    protected void altPressGround(BlockIterator.Intersection hit) {
        this.session.runAction(this.target, "altPressGround", new Object[]{hit.getPoint()});
    }

    protected void altClickGround(BlockIterator.Intersection hit) {
        this.session.runAction(this.target, "altClickGround", new Object[]{hit.getPoint()});
    }

    @Override
    public void viewChanged(Vec3d pos, Quatd facing) {
        if (this.selected != null) {
            if (this.dragging) {
                this.drag(pos, facing);
            } else {
                this.startDragging(pos, facing);
            }
        }
    }

    @Override
    public void activate(boolean pressed) {
    }

    @Override
    public void altActivate(boolean pressed) {
        if (pressed) {
            Rayd view = this.avatar.getViewRay();
            Vec3d place = null;
            Vec3d angle = null;
            int distance = 10;
            Iterator<BlockIterator.Intersection> it = this.avatar.pick(view, distance);
            this.lastHit = null;
            if (it.hasNext()) {
                BlockIterator.Intersection hit = this.lastHit = it.next();
                log.info("hit:" + hit);
                place = hit.getPoint();
                angle = hit.getNormal();
                log.info("origin:" + view.getOrigin());
                log.info("hit:" + place);
                log.info("distance:" + view.getOrigin().distance(place));
                distance = (int)Math.max(1.0, Math.ceil(view.getOrigin().distance(place)));
            }
            log.info("Need to check for object hits from:" + view + "  limit:" + distance);
            PickedObject picked = this.models.pickObject(this.avatar.getAvatarId(), view.getOrigin(), view.getDirection(), distance);
            log.info("Found:" + picked);
            if (picked != null) {
                this.altPressObject(picked);
            } else if (this.lastHit != null) {
                this.altPressGround(this.lastHit);
            }
        } else {
            if (this.selected != null) {
                if (this.dragging) {
                    log.info("Stop dragging");
                    this.stopDragging();
                } else {
                    this.altClickObject(this.selected);
                }
            } else if (this.lastHit != null && !this.dragging) {
                this.altClickGround(this.lastHit);
            }
            this.selected = null;
            this.lastHit = null;
        }
    }

    @Override
    public void change(int delta) {
        if (!this.dragging || this.selected == null) {
            this.session.runAction(this.target, "rotate", new Object[]{delta});
            return;
        }
        Vec3d avatarPos = this.avatar.getEyePosition();
        Quatd facing = this.avatar.getCameraFacing();
        this.objectFacing = this.objectFacing.mult(new Quatd().fromAngles(0.0, (double)delta * (Math.PI / 180), 0.0));
        this.session.runAction(this.target, "drag", this.getDragArgs(avatarPos, facing));
    }
}

