/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.ext.mblock;

import com.simsilica.es.EntityData;
import com.simsilica.ext.mphys.Mass;
import com.simsilica.ext.mphys.ShapeFactory;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.db.CellArrayId;
import com.simsilica.mblock.db.CellArrayStorage;
import com.simsilica.mblock.io.BlocksFileFormat;
import com.simsilica.mblock.phys.MBlockShape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellArrayShapeFactory
implements ShapeFactory<MBlockShape> {
    static Logger log = LoggerFactory.getLogger(CellArrayShapeFactory.class);
    private EntityData ed;
    private CellArrayStorage cellArrayStorage;

    public CellArrayShapeFactory(EntityData ed) {
        this(ed, null);
    }

    public CellArrayShapeFactory(EntityData ed, CellArrayStorage cellArrayStorage) {
        this.ed = ed;
        this.cellArrayStorage = cellArrayStorage;
    }

    public MBlockShape createShape(ShapeInfo info, Mass mass) {
        log.info("createShape(" + info.toString(this.ed) + ", " + mass + ")");
        String name = info.getShapeName(this.ed);
        double m = mass == null ? 0.0 : mass.getMass();
        CellArray cells = this.loadCells(name);
        return MBlockShape.createShape((String)name, (CellArray)cells, (double)info.getScale(), (double)m);
    }

    protected CellArray loadCells(String name) {
        if (name.endsWith(".ca")) {
            if (this.cellArrayStorage == null) {
                throw new IllegalArgumentException("No CellArrayStorage has been configued for .ca resource:" + name);
            }
            int split = name.lastIndexOf("_");
            if (split >= 0) {
                name = name.substring(split + 1);
            }
            CellArrayId id = CellArrayId.fromFileName((String)name);
            log.info("Loading:" + id);
            return this.cellArrayStorage.get(id);
        }
        try {
            log.info("loading:" + this.getClass().getResource(name));
            return BlocksFileFormat.loadCellArray((String)name);
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading block resource:" + name, e);
        }
    }
}

