/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.es.net;

import com.jme3.network.serializing.Serializer;
import com.simsilica.es.EntityChange;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityId;
import com.simsilica.es.net.TransientUtils;
import java.io.IOException;
import java.nio.ByteBuffer;

public class EntityChangeSerializer
extends Serializer {
    private Serializer idSerializer;
    private Serializer classSerializer;

    public void initialize(Class type) {
        this.idSerializer = Serializer.getSerializer(EntityId.class, (boolean)false);
        this.classSerializer = Serializer.getSerializer(Class.class, (boolean)true);
    }

    public <T> T readObject(ByteBuffer data, Class<T> c) throws IOException {
        EntityId id = (EntityId)this.idSerializer.readObject(data, EntityId.class);
        Class type = (Class)this.classSerializer.readObject(data, Class.class);
        Object component = Serializer.readClassAndObject((ByteBuffer)data);
        return c.cast(new EntityChange(id, type, (EntityComponent)component));
    }

    public void writeObject(ByteBuffer buffer, Object object) throws IOException {
        EntityChange change = (EntityChange)object;
        this.idSerializer.writeObject(buffer, (Object)change.getEntityId());
        this.classSerializer.writeObject(buffer, (Object)change.getComponentType());
        Serializer.writeClassAndObject((ByteBuffer)buffer, (Object)TransientUtils.clean(change.getComponent()));
    }
}

