/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.fsm;

import com.google.common.base.Predicate;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.simsilica.fsm.TransitionEvent;
import com.simsilica.fsm.TransitionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateMachine<K, T> {
    static Logger log = LoggerFactory.getLogger(StateMachine.class);
    private Map<K, State> states = new HashMap<K, State>();
    private Map<T, State> defaultTransitions = new HashMap<T, State>();
    private Multimap<TransitionPredicate, TransitionListener<T>> listeners = MultimapBuilder.linkedHashKeys().arrayListValues().build();
    private List<TransitionListener<T>> stopListeners = new ArrayList<TransitionListener<T>>();
    private State currentState;
    private State start;

    protected void needsRunning() {
        if (!this.isRunning()) {
            throw new IllegalStateException("StateMachine is not running");
        }
    }

    protected void needsNotRunning() {
        if (this.isRunning()) {
            throw new IllegalStateException("StateMachine is running");
        }
    }

    public void start() {
        this.start(null);
    }

    public void start(Object payload) {
        this.needsNotRunning();
        this.setCurrentState(this.start, null, payload);
    }

    public void trigger(T trigger) {
        this.trigger(trigger, null);
    }

    public void trigger(T trigger, Object payload) {
        this.needsRunning();
        if (log.isTraceEnabled()) {
            log.trace("trigger(" + trigger + ", " + payload + ")");
        }
        State to = null;
        if (this.currentState.transitions.containsKey(trigger)) {
            to = (State)this.currentState.transitions.get(trigger);
        } else if (this.defaultTransitions.containsKey(trigger)) {
            to = this.defaultTransitions.get(trigger);
        } else {
            throw new IllegalArgumentException("Trigger:[" + trigger + "] does not transition from:" + this.currentState);
        }
        this.setCurrentState(to, trigger, payload);
    }

    protected void setCurrentState(State to, T cause, Object payload) {
        if (log.isTraceEnabled()) {
            log.trace("setCurrentState(" + to + ", " + cause + ", " + payload + ")");
        }
        State from = this.currentState;
        this.currentState = to;
        log.info("currentState:" + this.currentState);
        this.fireTransition(from, to, cause, payload);
    }

    public StateMachine addDefaultTransition(T trigger, State to) {
        this.needsNotRunning();
        this.defaultTransitions.put(trigger, to);
        return this;
    }

    public StateMachine addDefaultTransition(T trigger, K to) {
        this.needsNotRunning();
        this.defaultTransitions.put(trigger, this.getState(to));
        return this;
    }

    public StateMachine addDefaultTermination(T trigger) {
        this.needsNotRunning();
        this.defaultTransitions.put(trigger, null);
        return this;
    }

    public StateMachine addTransitionListener(State from, State to, T trigger, Class payloadType, TransitionListener<T> l) {
        this.needsNotRunning();
        TransitionPredicate p = new TransitionPredicate(from, to, trigger, payloadType);
        this.listeners.put((Object)p, l);
        return this;
    }

    public StateMachine removeTransitionListener(State from, State to, T trigger, Class payloadType, TransitionListener<T> l) {
        this.needsNotRunning();
        TransitionPredicate p = new TransitionPredicate(from, to, trigger, payloadType);
        this.listeners.remove((Object)p, l);
        return this;
    }

    public StateMachine onStop(TransitionListener<T> l) {
        this.stopListeners.add(l);
        return this;
    }

    public StateMachine onStop(Runnable r) {
        return this.onStop(new TransitionListenerRunnableAdapter(r));
    }

    protected void fireTransition(State from, State to, T trigger, Object payload) {
        TransitionEvent<T> event = new TransitionEvent<T>(this, from, to, trigger, payload);
        for (TransitionPredicate transitionPredicate : this.listeners.keySet()) {
            if (transitionPredicate.to != null || !transitionPredicate.apply(event)) continue;
            for (TransitionListener l : this.listeners.get((Object)transitionPredicate)) {
                l.transition(event);
            }
        }
        for (TransitionPredicate transitionPredicate : this.listeners.keySet()) {
            if (transitionPredicate.to == null || !transitionPredicate.apply(event)) continue;
            for (TransitionListener l : this.listeners.get((Object)transitionPredicate)) {
                l.transition(event);
            }
        }
        if (to == null) {
            for (TransitionListener transitionListener : this.stopListeners) {
                transitionListener.transition(event);
            }
        }
    }

    public boolean isRunning() {
        return this.currentState != null;
    }

    public State getCurrentState() {
        return this.currentState;
    }

    public State getState(K id) {
        return this.getState(id, true);
    }

    public State getState(K id, boolean create) {
        if (id == null) {
            return null;
        }
        State result = this.states.get(id);
        if (result == null && create) {
            this.needsNotRunning();
            result = new State(id);
            this.states.put(id, result);
        }
        return result;
    }

    public State setStart(K id) {
        return this.setStart(this.getState(id));
    }

    public State setStart(State start) {
        this.needsNotRunning();
        this.start = start;
        return start;
    }

    public State getStart() {
        return this.start;
    }

    public Set<State> findOrphanStates() {
        HashSet<State> results = new HashSet<State>();
        for (State state : this.states.values()) {
            if (!state.transitions.isEmpty()) continue;
            results.add(state);
        }
        return results;
    }

    private class TransitionListenerRunnableAdapter<T>
    implements TransitionListener<T> {
        private Runnable delegate;

        public TransitionListenerRunnableAdapter(Runnable delegate) {
            this.delegate = delegate;
        }

        @Override
        public void transition(TransitionEvent event) {
            this.delegate.run();
        }
    }

    private class TransitionPredicate
    implements Predicate<TransitionEvent> {
        private State from;
        private State to;
        private T trigger;
        private Class payloadType;

        public TransitionPredicate(State from, State to, T trigger, Class payloadType) {
            this.from = from;
            this.to = to;
            this.trigger = trigger;
            this.payloadType = payloadType;
        }

        public boolean apply(TransitionEvent event) {
            Object payload;
            if (this.from != null && !Objects.equals(this.from, event.getFrom())) {
                return false;
            }
            if (this.to != null && !Objects.equals(this.to, event.getTo())) {
                return false;
            }
            if (this.trigger != null && !Objects.equals(this.trigger, event.getTrigger())) {
                return false;
            }
            return this.payloadType == null || (payload = event.getPayload(this.payloadType)) != null;
        }

        public int hashCode() {
            return Objects.hash(this.from, this.to, this.trigger, this.payloadType);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            TransitionPredicate other = (TransitionPredicate)o;
            if (!Objects.equals(other.from, this.from)) {
                return false;
            }
            if (!Objects.equals(other.to, this.to)) {
                return false;
            }
            if (!Objects.equals(other.trigger, this.trigger)) {
                return false;
            }
            return Objects.equals(other.payloadType, this.payloadType);
        }
    }

    public class State {
        private K id;
        private Map<T, State> transitions = new HashMap();

        public State(K id) {
            this.id = id;
        }

        public K getId() {
            return this.id;
        }

        public State addTransition(T trigger, State to) {
            this.transitions.put(trigger, to);
            return this;
        }

        public State addTransition(T trigger, K to) {
            this.transitions.put(trigger, StateMachine.this.getState(to));
            return this;
        }

        public State addTermination(T trigger) {
            this.transitions.put(trigger, null);
            return this;
        }

        public State onEnter(TransitionListener<T> l) {
            StateMachine.this.addTransitionListener(null, this, null, null, l);
            return this;
        }

        public State onExit(TransitionListener<T> l) {
            StateMachine.this.addTransitionListener(this, null, null, null, l);
            return this;
        }

        public State onEnter(Runnable r) {
            return this.onEnter(new TransitionListenerRunnableAdapter(r));
        }

        public State onExit(Runnable r) {
            return this.onExit(new TransitionListenerRunnableAdapter(r));
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            State other = (State)o;
            return Objects.equals(other.id, this.id);
        }

        public String toString() {
            return "State[" + this.id + "]";
        }
    }
}

