/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.opencl.lwjgl;

import com.jme3.opencl.Event;
import com.jme3.opencl.OpenCLObject;
import com.jme3.opencl.lwjgl.Utils;
import java.util.logging.Logger;
import org.lwjgl.opencl.CL10;
import org.lwjgl.opencl.CLEvent;

public class LwjglEvent
extends Event {
    private static final Logger LOG = Logger.getLogger(LwjglEvent.class.getName());
    private CLEvent event;

    public LwjglEvent(CLEvent event) {
        super((OpenCLObject.ObjectReleaser)new ReleaserImpl(event));
        this.event = event;
    }

    public CLEvent getEvent() {
        return this.event;
    }

    public void waitForFinished() {
        if (this.event == null) {
            return;
        }
        CL10.clWaitForEvents((CLEvent)this.event);
        this.release();
    }

    public boolean isCompleted() {
        if (this.event == null) {
            return true;
        }
        int status = this.event.getInfoInt(4563);
        if (status == 0) {
            this.release();
            return true;
        }
        if (status < 0) {
            Utils.checkError(status, "EventStatus");
            return false;
        }
        return false;
    }

    private static class ReleaserImpl
    implements OpenCLObject.ObjectReleaser {
        private CLEvent event;

        private ReleaserImpl(CLEvent event) {
            this.event = event;
        }

        public void release() {
            if (this.event != null && this.event.isValid()) {
                int ret = CL10.clReleaseEvent((CLEvent)this.event);
                this.event = null;
                Utils.reportError(ret, "clReleaseEvent");
                LOG.finer("Event deleted");
            }
        }
    }
}

