/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view;

import com.simsilica.es.EntityId;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Rayd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.BlockType;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mworld.BlockIterator;
import java.util.Iterator;
import java.util.Objects;
import mythruna.client.view.AvatarState;
import mythruna.client.view.ManipulatorType;
import mythruna.client.view.WorldMarkerState;
import mythruna.net.GameSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiggerManipulator
implements ManipulatorType {
    static Logger log = LoggerFactory.getLogger(DiggerManipulator.class);
    private WorldMarkerState markers;
    private GameSession session;
    private AvatarState avatar;
    private EntityId target;
    private float timer = 0.0f;
    private float timeout = 0.1f;
    private boolean valid = false;
    private Vec3d lastViewPos = new Vec3d();
    private BlockType hitType;
    private Vec3i hitLoc;

    public DiggerManipulator(WorldMarkerState markers, GameSession session, AvatarState avatar) {
        this.markers = markers;
        this.session = session;
        this.avatar = avatar;
    }

    @Override
    public void setTarget(EntityId target) {
        this.target = target;
        if (target == null) {
            this.setHit(null, null);
        }
    }

    @Override
    public void update(float tpf) {
        if (!this.valid) {
            this.timer += tpf;
            if (this.timer > this.timeout) {
                this.validate();
            }
        }
    }

    protected void setHit(Vec3i loc, BlockType type) {
        if (Objects.equals(this.hitLoc, loc) && this.hitType == type) {
            return;
        }
        if (this.hitLoc != null) {
            this.markers.removeBlockMarker(this.hitLoc);
        }
        this.hitLoc = loc;
        this.hitType = type;
        if (this.hitLoc != null) {
            this.markers.addBlockMarker(this.hitLoc, this.hitType);
        }
    }

    protected void validate() {
        this.valid = true;
        Rayd view = this.avatar.getViewRay();
        Iterator<BlockIterator.Intersection> it = this.avatar.pick(view, 10);
        if (it.hasNext()) {
            BlockIterator.Intersection hit = it.next();
            if (log.isDebugEnabled()) {
                log.debug("hit:" + hit);
            }
            this.setHit(hit.getBlock(), BlockTypeIndex.get((int)hit.getType()));
        } else {
            this.setHit(null, null);
        }
    }

    @Override
    public void viewChanged(Vec3d pos, Quatd facing) {
        this.valid = false;
        this.timer = 0.0f;
        if (this.lastViewPos.distanceSq(pos) > 1.0) {
            this.lastViewPos.set(pos);
            this.setHit(null, null);
        }
    }

    @Override
    public void activate(boolean pressed) {
        if (pressed) {
            this.session.runAction(this.target, "startDigging", new Object[0]);
        } else {
            this.session.runAction(this.target, "stopDigging", new Object[0]);
        }
    }

    @Override
    public void altActivate(boolean pressed) {
        if (pressed) {
            this.session.runAction(this.target, "startFilling", new Object[0]);
        } else {
            this.session.runAction(this.target, "stopFilling", new Object[0]);
        }
    }

    @Override
    public void change(int delta) {
        this.session.runAction(this.target, "rotate", new Object[]{delta});
    }
}

