/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.BaseAppState;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.debug.WireBox;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.mathd.Grid;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.BlockType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import mythruna.GameConstants;
import mythruna.client.view.AvatarState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldMarkerState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(WorldMarkerState.class);
    private VersionedReference<Vec3d> posRef;
    private Grid grid = GameConstants.PHYSICS_GRID;
    private Node markerRoot;
    private Vec3i centerCell = new Vec3i(0, -10000, 0);
    private Vec3i centerWorld;
    private Map<Vec3d, WireBox> boxes = new HashMap<Vec3d, WireBox>();
    private ColorRGBA markerColor = new ColorRGBA(1.0f, 1.0f, 0.0f, 1.0f);
    private Material wireMaterial;
    private float cycle = 0.0f;
    private List<Marker> markers = new ArrayList<Marker>();

    public void addBlockMarker(Vec3i world, BlockType type) {
        if (log.isTraceEnabled()) {
            log.trace("addBlockMarker(" + world + ", " + type + ")");
        }
        this.markers.add(new Marker(world, type));
    }

    public void removeBlockMarker(Vec3i world) {
        if (log.isTraceEnabled()) {
            log.trace("removeBlockMarker(" + world + ")");
        }
        Iterator<Marker> it = this.markers.iterator();
        while (it.hasNext()) {
            Marker m = it.next();
            if (!Objects.equals(world, m.world)) continue;
            it.remove();
            m.release();
        }
    }

    protected Node getRoot() {
        return ((SimpleApplication)this.getApplication()).getRootNode();
    }

    protected void initialize(Application app) {
        this.posRef = ((AvatarState)this.getState(AvatarState.class)).createPositionReference();
        this.markerRoot = new Node("WorldMarkerRoot");
        this.updateViewPosition((Vec3d)this.posRef.get(), true);
        this.wireMaterial = GuiGlobals.getInstance().createMaterial(this.markerColor, false).getMaterial();
        this.wireMaterial.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        this.wireMaterial.getAdditionalRenderState().setPolyOffset(-1.0f, -1.0f);
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        this.getRoot().attachChild((Spatial)this.markerRoot);
    }

    protected void onDisable() {
        this.markerRoot.removeFromParent();
    }

    public void update(float tpf) {
        if (this.posRef.update()) {
            this.updateViewPosition((Vec3d)this.posRef.get(), false);
        }
        this.cycle += tpf * 0.5f;
        if (this.cycle > 1.0f) {
            this.cycle -= 1.0f;
        }
        this.updateColors();
    }

    protected void updateColors() {
        float t = (double)this.cycle < 0.5 ? this.cycle * 2.0f : (1.0f - this.cycle) * 2.0f;
        t = t * t * (3.0f - 2.0f * t);
        this.markerColor.a = 0.25f + t * 0.5f;
    }

    protected void updateViewPosition(Vec3d center, boolean forceUpdate) {
        Vec3i newCenter = this.grid.worldToCell(center);
        if (!forceUpdate && newCenter.equals((Object)this.centerCell)) {
            return;
        }
        this.centerCell.set(newCenter);
        this.centerWorld = this.grid.cellToWorld(this.centerCell);
        this.resetRelativeCoordinates();
    }

    protected void resetRelativeCoordinates() {
        for (Marker m : this.markers) {
            m.updateRelativePosition();
        }
    }

    protected WireBox getBox(Vec3d size) {
        WireBox box = this.boxes.get(size);
        if (box == null) {
            box = new WireBox((float)(size.x * 0.5), (float)(size.y * 0.5), (float)(size.z * 0.5));
            this.boxes.put(size, box);
        }
        return box;
    }

    private class Marker {
        private Vec3i world;
        private BlockType type;
        private Vector3f offset;
        private Geometry geom;

        public Marker(Vec3i world, BlockType type) {
            this.world = world;
            this.type = type;
            Vec3d min = type.getFactory().getMin();
            Vec3d max = type.getFactory().getMax();
            Vec3d size = max.subtract(min);
            WireBox box = WorldMarkerState.this.getBox(size);
            this.offset = min.add(max).multLocal(0.5).toVector3f();
            this.geom = new Geometry("marker", (Mesh)box);
            this.geom.setMaterial(WorldMarkerState.this.wireMaterial);
            WorldMarkerState.this.markerRoot.attachChild((Spatial)this.geom);
            this.updateRelativePosition();
        }

        public void release() {
            this.geom.removeFromParent();
        }

        public void updateRelativePosition() {
            Vec3i loc = this.world.subtract(WorldMarkerState.this.centerWorld);
            this.geom.setLocalTranslation((float)loc.x + this.offset.x, (float)loc.y + this.offset.y, (float)loc.z + this.offset.z);
        }
    }
}

