/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.fractal;

import com.simsilica.fractal.Sampler;

public class SamplerRange {
    public static final SamplerRange INFINITY = new SamplerRange(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    public static final SamplerRange POSITIVE_INFINITY = new SamplerRange(0.0, Double.POSITIVE_INFINITY);
    private double min;
    private double max;

    public SamplerRange(double min, double max) {
        this.min = min;
        this.max = max;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public SamplerRange max(SamplerRange range) {
        return new SamplerRange(Math.max(this.min, range.min), Math.max(this.max, range.max));
    }

    public SamplerRange add(SamplerRange range) {
        return new SamplerRange(this.min + range.min, this.max + range.max);
    }

    public SamplerRange subtract(SamplerRange range) {
        double a = this.min - range.min;
        double b = this.min - range.max;
        double c = this.max - range.min;
        double d = this.max - range.max;
        return new SamplerRange(Math.min(Math.min(a, b), Math.min(c, d)), Math.max(Math.max(a, b), Math.max(c, d)));
    }

    public SamplerRange mult(double val) {
        return new SamplerRange(this.min * val, this.max * val);
    }

    public SamplerRange mult(SamplerRange range) {
        double a = this.min * range.min;
        double b = this.min * range.max;
        double c = this.max * range.min;
        double d = this.max * range.max;
        return new SamplerRange(Math.min(Math.min(a, b), Math.min(c, d)), Math.max(Math.max(a, b), Math.max(c, d)));
    }

    public SamplerRange div(SamplerRange range) {
        double a = this.min / range.min;
        double b = this.min / range.max;
        double c = this.max / range.min;
        double d = this.max / range.max;
        return new SamplerRange(Math.min(Math.min(a, b), Math.min(c, d)), Math.max(Math.max(a, b), Math.max(c, d)));
    }

    public static SamplerRange addRanges(Sampler ... samplers) {
        double min = samplers[0].getRange().min;
        double max = samplers[0].getRange().max;
        for (int i = 1; i < samplers.length; ++i) {
            min += samplers[i].getRange().min;
            max += samplers[i].getRange().max;
        }
        return new SamplerRange(min, max);
    }

    public static SamplerRange maxRanges(Sampler ... samplers) {
        double min = samplers[0].getRange().min;
        double max = samplers[0].getRange().max;
        for (int i = 1; i < samplers.length; ++i) {
            min = Math.max(min, samplers[i].getRange().min);
            max = Math.max(max, samplers[i].getRange().max);
        }
        return new SamplerRange(min, max);
    }

    public String toString() {
        return String.format("[%.1f, %.1f]", this.min, this.max);
    }
}

