/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world;

import com.simsilica.fractal.AbstractSampler;
import com.simsilica.fractal.FractalSum;
import com.simsilica.fractal.PerlinNoise;
import com.simsilica.fractal.Sampler;
import com.simsilica.fractal.Samplers;
import com.simsilica.mathd.Vec3d;
import mythruna.world.DefaultWorldFractal;
import mythruna.world.WorldFractal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldFractalFactory {
    static Logger log = LoggerFactory.getLogger(WorldFractalFactory.class);

    public static WorldFractal sineWaves(long seed) {
        AbstractSampler elevation;
        Sampler resampled;
        Sampler sinX = Samplers.sin((Sampler)Samplers.dot((Vec3d)Vec3d.UNIT_X));
        Sampler sinZ = Samplers.sin((Sampler)Samplers.dot((Vec3d)Vec3d.UNIT_Z));
        Sampler combined = Samplers.mult((Sampler)sinX, (Sampler)sinZ);
        Sampler pow = Samplers.mult((Sampler)combined, (Sampler)combined);
        pow = Samplers.mult((Sampler)pow, (Sampler)combined);
        final Sampler base = resampled = Samplers.resample((Sampler)pow, (double)0.01227184630308513, (double)1.0, (double)0.01227184630308513);
        AbstractSampler estimated = elevation = new AbstractSampler(-128.0, 512.0){

            public double getSample(double x, double y, double z) {
                double e = base.getSample(x, y, z);
                if (e < 0.0) {
                    return e * 128.0;
                }
                return e * 512.0;
            }

            public String toString() {
                return "ElevationRemapping[]";
            }
        };
        double temperatureWidth = 32768.0;
        double temperatureHeight = 16384.0;
        resampled = Samplers.resample((Sampler)new PerlinNoise(seed), (double)(1.0 / temperatureWidth), (double)0.0, (double)(1.0 / temperatureHeight));
        Sampler temperature = Samplers.scale((Sampler)Samplers.add((Sampler)resampled, (Sampler)Samplers.constant((double)1.0)), (double)0.5);
        double wetnessWidth = 16384.0;
        double wetnessHeight = 32768.0;
        Sampler unnormalizedWetness = resampled = Samplers.resample((Sampler)new PerlinNoise(seed + 1L), (double)(1.0 / wetnessWidth), (double)0.0, (double)(1.0 / wetnessHeight));
        Sampler weather = Samplers.scale((Sampler)Samplers.add((Sampler)unnormalizedWetness, (Sampler)Samplers.constant((double)1.0)), (double)0.5);
        Sampler veg1 = resampled = Samplers.resample((Sampler)new PerlinNoise(seed), (double)0.0625, (double)1.0, (double)0.0625);
        Sampler veg2 = resampled = Samplers.resample((Sampler)new PerlinNoise(seed), (double)0.0078125, (double)1.0, (double)0.0078125);
        Sampler veg3 = resampled = Samplers.resample((Sampler)new PerlinNoise(seed), (double)9.765625E-4, (double)1.0, (double)9.765625E-4);
        Object veg = Samplers.scale((Sampler)Samplers.add((Sampler)veg1, (Sampler)veg2), (double)0.5);
        veg = Samplers.scale((Sampler)Samplers.add((Sampler)veg, (Sampler)veg3), (double)0.5);
        final Sampler vegBase = veg = Samplers.add((Sampler)veg, (Sampler)Samplers.scale((Sampler)unnormalizedWetness, (double)0.5));
        double snowLine = 500.0;
        double treeLine = 500.0;
        double deepWater = -100.0;
        veg = new AbstractSampler(-1.0, 1.0){

            public double getSample(double x, double y, double z) {
                double height = y;
                if (height > 500.0) {
                    return 0.0;
                }
                if (height < -100.0) {
                    return 0.0;
                }
                double result = vegBase.getSample(x, 0.0, z);
                if (height < 0.0) {
                    result *= 0.5;
                }
                return result;
            }

            public String toString() {
                return "VegRemapping[500.0, 500.0, -100.0]";
            }
        };
        veg = Samplers.clamp((Sampler)veg, (double)0.0, (double)1.0);
        Sampler waterLevel = Samplers.constant((double)0.0);
        return new DefaultWorldFractal((Sampler)estimated, (Sampler)elevation, waterLevel, temperature, weather, (Sampler)veg);
    }

    public static WorldFractal createSample(long seed) {
        Object veg;
        PerlinNoise noise1 = new PerlinNoise(seed);
        PerlinNoise noise2 = new PerlinNoise(seed + 1L);
        FractalSum fractal1 = new FractalSum((Sampler)noise1);
        fractal1.setFrequencyIterations(2);
        FractalSum fractal2 = new FractalSum((Sampler)noise2);
        fractal2.setFrequencyIterations(2);
        Sampler resampled = Samplers.resample((Sampler)fractal1, (double)2.44140625E-4, (double)1.0, (double)2.44140625E-4);
        Sampler resampled2 = Samplers.resample((Sampler)fractal2, (double)2.44140625E-4, (double)1.0, (double)2.44140625E-4);
        resampled = Samplers.add((Sampler)resampled, (Sampler)resampled2);
        double raiseWidth = 40096.0;
        double raiseHeight = 40096.0;
        Sampler raise = Samplers.resample((Sampler)noise1, (double)(1.0 / raiseWidth), (double)1.0, (double)(1.0 / raiseHeight));
        raise = Samplers.subtract((Sampler)raise, (Sampler)Samplers.constant((double)0.1));
        resampled = Samplers.add((Sampler)resampled, (Sampler)Samplers.scale((Sampler)raise, (double)3.0));
        Sampler estimatedElevation = Samplers.scale((Sampler)resampled, (double)200.0);
        FractalSum bumpier = new FractalSum((Sampler)noise1, 8);
        bumpier = Samplers.resample((Sampler)bumpier, (double)9.765625E-4, (double)1.0, (double)9.761811792268644E-4);
        bumpier = Samplers.scale((Sampler)bumpier, (double)150.0);
        Sampler elevation = Samplers.add((Sampler)estimatedElevation, (Sampler)bumpier);
        elevation = Samplers.clamp((Sampler)elevation, (double)-188.0, (double)1000.0);
        elevation = Samplers.reflect((Sampler)elevation, (double)-128.0, (double)512.0);
        double temperatureWidth = 32768.0;
        double temperatureHeight = 16384.0;
        resampled = Samplers.resample((Sampler)noise1, (double)(1.0 / temperatureWidth), (double)0.0, (double)(1.0 / temperatureHeight));
        Sampler temperature = Samplers.scale((Sampler)Samplers.add((Sampler)resampled, (Sampler)Samplers.constant((double)1.0)), (double)0.5);
        double weatherWidth = 16384.0;
        double weatherHeight = 32768.0;
        Sampler unnormalizedWetness = resampled = Samplers.resample((Sampler)noise2, (double)(1.0 / weatherWidth), (double)0.0, (double)(1.0 / weatherHeight));
        Sampler weather = Samplers.scale((Sampler)Samplers.add((Sampler)resampled, (Sampler)Samplers.constant((double)1.0)), (double)0.5);
        Sampler veg1 = resampled = Samplers.resample((Sampler)new PerlinNoise(seed), (double)0.0625, (double)1.0, (double)0.0625);
        Sampler veg2 = resampled = Samplers.resample((Sampler)new PerlinNoise(seed), (double)0.0078125, (double)1.0, (double)0.0078125);
        Sampler veg3 = resampled = Samplers.resample((Sampler)new PerlinNoise(seed), (double)9.765625E-4, (double)1.0, (double)9.765625E-4);
        final Sampler vegBase = veg = Samplers.scale((Sampler)Samplers.add((Sampler)veg1, (Sampler)veg2), (double)0.5);
        double snowLine = 500.0;
        double treeLine = 500.0;
        double deepWater = -100.0;
        veg = new AbstractSampler(-1.0, 1.0){

            public double getSample(double x, double y, double z) {
                double height = y;
                if (height > 500.0) {
                    return 0.0;
                }
                if (height < -100.0) {
                    return 0.0;
                }
                double result = vegBase.getSample(x, 0.0, z);
                if (height < 0.0) {
                    result *= 0.5;
                }
                return result;
            }

            public String toString() {
                return "VegRemapping[500.0, -100.0]";
            }
        };
        veg = Samplers.clamp((Sampler)veg, (double)0.0, (double)1.0);
        Sampler waterLevel = Samplers.constant((double)128.0);
        estimatedElevation = Samplers.add((Sampler)estimatedElevation, (Sampler)waterLevel);
        estimatedElevation = Samplers.clamp((Sampler)estimatedElevation, (double)0.0, (double)640.0);
        elevation = Samplers.add((Sampler)elevation, (Sampler)waterLevel);
        return new DefaultWorldFractal(estimatedElevation, elevation, waterLevel, temperature, weather, (Sampler)veg);
    }
}

