/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldTime
implements Cloneable {
    static Logger log = LoggerFactory.getLogger(WorldTime.class);
    public static final double NANOS_PER_SECOND = 1.0E9;
    public static final double REAL_SECS_PER_GAME_SECOND = 0.016666666666666666;
    private static final double TO_GAME_SECONDS = 6.000000000000001E-8;
    private static final double TO_MINUTES = 0.016666666666666666;
    private static final double TO_HOURS = 2.777777777777778E-4;
    private static final double TO_DAYS = 1.1574074074074073E-5;
    public static final int MONTHS_IN_A_YEAR = 4;
    public static final int DAYS_IN_A_WEEK = 7;
    public static final int DAYS_IN_A_MONTH = 28;
    public static final int DAYS_IN_A_YEAR = 112;
    private long baseOffset;
    private long realTimeNanos;

    public WorldTime() {
    }

    public WorldTime(int year, int month, int day) {
        long days = year * 112;
        days += (long)(month * 28);
        double gameSeconds = (double)(days += (long)day) / 1.1574074074074073E-5;
        double nanos = gameSeconds / 6.000000000000001E-8;
        this.realTimeNanos = (long)nanos;
    }

    public WorldTime clone() {
        try {
            return (WorldTime)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("What are you going to do about it?", e);
        }
    }

    public void setRealTimeNanos(long realTimeNanos) {
        this.realTimeNanos = realTimeNanos;
    }

    public long getRealTimeNanos() {
        return this.realTimeNanos;
    }

    public void setBaseOffset(long baseOffset) {
        this.baseOffset = baseOffset;
    }

    public long getBaseOffset() {
        return this.baseOffset;
    }

    public int getYear() {
        double seconds = this.getGameTime();
        int days = (int)(seconds * 1.1574074074074073E-5);
        return days / 112;
    }

    public int getMonth() {
        double seconds = this.getGameTime();
        int days = (int)(seconds * 1.1574074074074073E-5);
        return days % 112 / 28;
    }

    public int getDay() {
        double seconds = this.getGameTime();
        int days = (int)(seconds * 1.1574074074074073E-5);
        return days % 28;
    }

    public double getGameTime() {
        return (double)(this.baseOffset + this.realTimeNanos) * 6.000000000000001E-8;
    }

    public String asFullString() {
        double seconds = this.getGameTime();
        int minute = (int)(seconds * 0.016666666666666666) % 60;
        int hour = (int)(seconds * 2.777777777777778E-4) % 24;
        int days = (int)(seconds * 1.1574074074074073E-5);
        int day = 1 + days % 28;
        int month = 1 + days % 112 / 28;
        int year = days / 112;
        return String.format("%03d/%02d/%02d %02d:%02d", year, month, day, hour, minute);
    }
}

