/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world;

import com.simsilica.mathd.Vec3d;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import mythruna.world.WorldFractal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldUtils {
    static Logger log = LoggerFactory.getLogger(WorldUtils.class);

    public static Vec3d findSpawn(WorldFractal fractal) {
        Vec3d result = WorldUtils.findSpawn(fractal, 1015808.0, 1015808.0, 32768.0, 1024.0);
        result = WorldUtils.findSpawn(fractal, result.x, result.z, 1024.0, 32.0);
        return result;
    }

    public static Vec3d findSpawn(WorldFractal fractal, double xStart, double zStart, double radius, double resolution) {
        Vec3d best = null;
        double max = 0.0;
        double step = radius * 2.0 / resolution;
        for (double x = xStart - radius; x <= xStart + radius; x += step) {
            for (double z = zStart - radius; z <= zStart + radius; z += step) {
                double y = fractal.getEstimatedElevation(x, z);
                if (best == null) {
                    max = y;
                    best = new Vec3d(x, y, z);
                    continue;
                }
                if (!(y > max)) continue;
                max = y;
                best.set(x, y, z);
            }
        }
        best.addLocal(0.5, 0.0, 0.5);
        return best;
    }

    public static BufferedImage createMapImage(WorldFractal fractal, int imageSize, double xStart, double zStart, double mapSize) {
        ByteBuffer data = ByteBuffer.wrap(WorldUtils.createPreview(fractal, imageSize, xStart, zStart, mapSize));
        BufferedImage image = new BufferedImage(imageSize, imageSize, 2);
        int[] outArray = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        IntBuffer argbBuff = data.asIntBuffer();
        argbBuff.clear();
        argbBuff.get(outArray);
        return image;
    }

    public static byte[] createPreview(WorldFractal fractal, int imageSize, double xStart, double zStart, double mapSize) {
        int c;
        int b;
        int j;
        int fade;
        int[][] type = new int[imageSize][imageSize];
        int[][] color = new int[imageSize][imageSize];
        double size = mapSize;
        double scale = size / (double)imageSize;
        double x = xStart;
        double z = zStart + size - scale;
        for (int i = 0; i < imageSize; ++i) {
            x = xStart;
            for (int j2 = 0; j2 < imageSize; ++j2) {
                double w;
                double y = fractal.getEstimatedElevation(x, z);
                type[j2][i] = y > (w = fractal.getWaterLevel(x, y, z)) ? (int)y : -((int)y);
                x += scale;
            }
            z -= scale;
        }
        int margin = imageSize / 16;
        double mult = 255.0 / (double)margin;
        for (int i = 0; i < imageSize; ++i) {
            boolean last = type[0][i] > 0;
            fade = 0;
            for (j = 0; j < imageSize; ++j) {
                boolean val;
                boolean bl = val = type[j][i] > 0;
                if (val == last && fade > 0) {
                    double s = (double)fade / (double)margin;
                    if (last) {
                        int g = color[j][i] >> 8 & 0xFF;
                        color[j][i] = Math.max(g, (int)(s * 255.0) & 0xFF) << 8;
                    } else {
                        b = color[j][i] & 0xFF;
                        color[j][i] = Math.max(b, (int)(s * 255.0) & 0xFF);
                    }
                    --fade;
                } else if (val != last) {
                    color[j][i] = -1;
                    if (j > 0) {
                        color[j - 1][i] = -1;
                    }
                    fade = margin;
                }
                last = val;
            }
            last = type[imageSize - 1][i] > 0;
            fade = 0;
            for (j = imageSize - 1; j >= 0; --j) {
                boolean val;
                c = color[j][i];
                boolean bl = val = type[j][i] > 0;
                if (val == last && fade > 0) {
                    double s = (double)fade / (double)margin;
                    if (last) {
                        int g = c >> 8 & 0xFF;
                        color[j][i] = Math.max(g, (int)(s * 255.0) & 0xFF) << 8;
                    } else {
                        int b2 = c & 0xFF;
                        color[j][i] = Math.max(b2, (int)(s * 255.0) & 0xFF);
                    }
                    --fade;
                } else if (val != last) {
                    color[j][i] = -1;
                    if (j > 0) {
                        color[j - 1][i] = -1;
                    }
                    fade = margin;
                }
                last = val;
            }
        }
        for (int j3 = 0; j3 < imageSize; ++j3) {
            double s;
            int g;
            boolean val;
            int i;
            boolean last = type[j3][0] > 0;
            fade = 0;
            for (i = 0; i < imageSize; ++i) {
                c = color[j3][i];
                boolean bl = val = type[j3][i] > 0;
                if (val == last) {
                    g = c >> 8 & 0xFF;
                    b = c & 0xFF;
                    if (c > 0) {
                        fade = val ? Math.max(fade, (int)((double)g / mult)) : Math.max(fade, (int)((double)b / mult));
                        fade = Math.min(margin, fade);
                    }
                    if (fade > 0) {
                        s = (double)fade / (double)margin;
                        color[j3][i] = last ? Math.max(g, (int)(s * 255.0) & 0xFF) << 8 : Math.max(b, (int)(s * 255.0) & 0xFF);
                    }
                    --fade;
                } else if (val != last) {
                    color[j3][i] = -1;
                    if (i > 0) {
                        color[j3][i - 1] = -1;
                    }
                    fade = margin;
                }
                last = val;
            }
            last = type[j3][imageSize - 1] > 0;
            fade = 0;
            for (i = imageSize - 1; i >= 0; --i) {
                c = color[j3][i];
                boolean bl = val = type[j3][i] > 0;
                if (val == last) {
                    g = c >> 8 & 0xFF;
                    b = c & 0xFF;
                    if (c > 0) {
                        fade = val ? Math.max(fade, (int)((double)g / mult)) : Math.max(fade, (int)((double)b / mult));
                        fade = Math.min(margin, fade);
                    }
                    if (fade > 0) {
                        s = (double)fade / (double)margin;
                        color[j3][i] = last ? Math.max(g, (int)(s * 255.0) & 0xFF) << 8 : Math.max(b, (int)(s * 255.0) & 0xFF);
                    }
                    --fade;
                } else if (val != last) {
                    color[j3][i] = -1;
                    if (i > 0) {
                        color[j3][i - 1] = -1;
                    }
                    fade = margin;
                }
                last = val;
            }
        }
        byte[] img = new byte[imageSize * imageSize * 4];
        int pos = 0;
        for (int i = 0; i < imageSize; ++i) {
            for (j = 0; j < imageSize; ++j) {
                c = color[j][i];
                if (c < 0) {
                    img[pos++] = -1;
                    img[pos++] = 0;
                    img[pos++] = 0;
                    img[pos++] = 0;
                    continue;
                }
                boolean r = false;
                int g = c >> 8 & 0xFF;
                b = c & 0xFF;
                double a = (double)Math.max(g, b) / 255.0;
                if (g > 0) {
                    g = 597;
                    b = 0;
                    a *= a;
                    a *= 196.0;
                } else if (b > 0) {
                    g = 0;
                    b = 597;
                    a *= 64.0;
                }
                img[pos++] = (byte)a;
                img[pos++] = (byte)(r ? 1 : 0);
                img[pos++] = (byte)g;
                img[pos++] = (byte)b;
            }
        }
        return img;
    }
}

