/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.tile.insert;

import com.google.common.base.MoreObjects;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.BlockDataId;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.TileId;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockInsert
implements Cloneable {
    static Logger log = LoggerFactory.getLogger(BlockInsert.class);
    public static final int CARVE_NONE = 0;
    public static final int CARVE_BELOW = 1;
    public static final int CARVE_INNER = 2;
    public static final int CARVE_ABOVE = 4;
    public static final int CARVE_EXTEND_DOWN = 8;
    public static final int CARVE_EXTEND_UP = 16;
    public Vec3i world;
    public BlockDataId blockDataId;
    public long objectId;
    public int carveFlags;
    public byte xSize;
    public byte ySize;
    public byte zSize;
    public boolean aboveGround;
    public byte groundLevel;

    public BlockInsert(Vec3i world, BlockDataId blockDataId, int carveFlags, int xSize, int ySize, int zSize, long objectId) {
        this(world, blockDataId, carveFlags, xSize, ySize, zSize, true, ySize, objectId);
    }

    public BlockInsert(Vec3i world, BlockDataId blockDataId, int carveFlags, int xSize, int ySize, int zSize, boolean aboveGround, int groundLevel, long objectId) {
        this.world = world;
        this.blockDataId = blockDataId;
        this.carveFlags = carveFlags;
        this.xSize = (byte)xSize;
        this.ySize = (byte)ySize;
        this.zSize = (byte)zSize;
        this.aboveGround = aboveGround;
        this.groundLevel = (byte)groundLevel;
        this.objectId = objectId;
    }

    public BlockInsert clone() {
        try {
            BlockInsert result = (BlockInsert)super.clone();
            result.world = this.world.clone();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Checked exceptions, hurray", e);
        }
    }

    public Iterable<Short> getAffectedColumns(TileId tileId) {
        ArrayList<Short> results = new ArrayList<Short>();
        Vec3i origin = tileId.getWorld(null);
        int xMin = this.world.x - origin.x;
        int zMin = this.world.z - origin.z;
        int xMax = xMin + this.xSize;
        int zMax = zMin + this.zSize;
        if (xMax < 0 || zMax < 0) {
            return results;
        }
        if (xMin >= 1024 || zMin >= 1024) {
            return results;
        }
        xMin = Math.max(0, xMin);
        xMax = Math.min(xMax, 1023);
        zMin = Math.max(0, zMin);
        zMax = Math.min(zMax, 1023);
        Vec3i min = ColumnId.GRID.worldToCell((double)xMin, 0.0, (double)zMin);
        Vec3i max = ColumnId.GRID.worldToCell((double)xMax, 0.0, (double)zMax);
        for (int x = min.x; x <= max.x; ++x) {
            for (int z = min.z; z <= max.z; ++z) {
                short id = ColumnId.toTileLocalIndexId(x, z);
                results.add(id);
                ColumnId colId = ColumnId.fromTileLocalIndex(tileId, x, z);
                if (tileId.getId() == colId.getTileId().getId()) continue;
                log.warn("Tile mismatch for (" + x + ", " + z + ") tile:" + tileId + "  min:" + min + "  max:" + max);
            }
        }
        return results;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("world", (Object)this.world).add("blockDataId", (Object)this.blockDataId).add("carveFlags", (Object)Integer.toBinaryString(this.carveFlags)).add("objectId", this.objectId).add("xSize", (int)this.xSize).add("zSize", (int)this.zSize).toString();
    }
}

