/*
 * Decompiled with CFR 0.152.
 */
package mythruna.server;

import com.google.common.base.Supplier;
import com.jme3.network.HostedConnection;
import com.jme3.network.Network;
import com.jme3.network.Server;
import com.jme3.network.serializing.Serializer;
import com.jme3.network.serializing.serializers.ArraySerializer;
import com.jme3.network.serializing.serializers.EnumSerializer;
import com.jme3.network.serializing.serializers.FieldSerializer;
import com.jme3.network.service.HostedService;
import com.jme3.network.service.rmi.RmiHostedService;
import com.jme3.network.service.rpc.RpcHostedService;
import com.simsilica.account.AccountManager;
import com.simsilica.action.ObjectAction;
import com.simsilica.action.ObjectType;
import com.simsilica.action.ObjectTypeRegistry;
import com.simsilica.action.Option;
import com.simsilica.action.PromptType;
import com.simsilica.bpos.BodyPosition;
import com.simsilica.bpos.LargeGridCell;
import com.simsilica.bpos.LargeObject;
import com.simsilica.bpos.mphys.BodyPositionPublisher;
import com.simsilica.bpos.mphys.LargeGridIndexSystem;
import com.simsilica.crig.es.AnimationConfig;
import com.simsilica.crig.es.LayerConfig;
import com.simsilica.crig.sim.CharacterAnimationSystem;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.Name;
import com.simsilica.es.ObservableEntityData;
import com.simsilica.es.server.EntityDataHostedService;
import com.simsilica.es.server.EntityUpdater;
import com.simsilica.ethereal.EtherealHost;
import com.simsilica.ethereal.NetworkStateListener;
import com.simsilica.ethereal.TimeSource;
import com.simsilica.ext.mphys.EntityBodyFactory;
import com.simsilica.ext.mphys.MPhysSystem;
import com.simsilica.ext.mphys.Mass;
import com.simsilica.ext.mphys.ShapeFactory;
import com.simsilica.ext.mphys.ShapeFactoryRegistry;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.ext.mphys.SpawnPosition;
import com.simsilica.ext.mphys.net.ZoneNetworkSystem;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mblock.db.CellArrayStorage;
import com.simsilica.mblock.phys.Collider;
import com.simsilica.mblock.phys.MBlockCollisionSystem;
import com.simsilica.mblock.phys.collision.ColliderFactories;
import com.simsilica.mphys.CollisionSystem;
import com.simsilica.mphys.PhysicsSpace;
import com.simsilica.mworld.World;
import com.simsilica.mworld.net.server.WorldHostedService;
import com.simsilica.net.server.ChatHostedService;
import com.simsilica.sim.GameLoop;
import com.simsilica.sim.GameSystem;
import com.simsilica.sim.GameSystemManager;
import com.simsilica.sim.common.DecaySystem;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.InetAddress;
import mythruna.GameConstants;
import mythruna.cmd.CommandSystem;
import mythruna.es.BlueprintInfo;
import mythruna.es.ClaimArea;
import mythruna.es.ClaimMarker;
import mythruna.es.ClaimPermissions;
import mythruna.es.ClaimType;
import mythruna.es.ContainedIn;
import mythruna.es.ContainerVolume;
import mythruna.es.CreationTime;
import mythruna.es.Holding;
import mythruna.es.MovementInput;
import mythruna.es.ObjectFocus;
import mythruna.es.ObjectName;
import mythruna.es.ObjectTypeInfo;
import mythruna.es.ObjectVolume;
import mythruna.es.OwnedBy;
import mythruna.net.BlueprintData;
import mythruna.net.server.AccountHostedService;
import mythruna.net.server.GameSessionHostedService;
import mythruna.server.PrebuiltObjectSetup;
import mythruna.shape.ShapeRegistryBuilder;
import mythruna.shell.CommandShell;
import mythruna.shell.Echo;
import mythruna.shell.Help;
import mythruna.shell.Say;
import mythruna.shell.ShellCommand;
import mythruna.shell.ShellService;
import mythruna.sim.AttachmentSystem;
import mythruna.sim.HoldingSystem;
import mythruna.sim.MovementSystem;
import mythruna.sim.PathRecorderSystem;
import mythruna.sim.WorldTimeService;
import mythruna.world.WorldManager;
import mythruna.world.WorldTimeSource;
import mythruna.world.es.WorldAge;
import mythruna.world.es.WorldSeed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GameServer {
    static Logger log = LoggerFactory.getLogger(GameServer.class);
    private WorldManager worldManager;
    private String description;
    private Server server;
    private GameSystemManager systems;
    private GameLoop loop;
    private CommandShell adminShell;

    public GameServer(WorldManager worldManager, Supplier<String> tokenSupplier, InetAddress hostAddress, int port, String description) throws IOException {
        this.worldManager = worldManager;
        this.description = description;
        if (worldManager.getInfo().getSpawnPoint() == null) {
            log.error("World has no spawn point:" + worldManager.getInfo());
        }
        Serializer.initialize();
        this.systems = new GameSystemManager();
        this.loop = new GameLoop(this.systems);
        this.systems.register(WorldManager.class, (Object)worldManager);
        this.server = Network.createServer((String)"Mythruna", (int)20220903, (int)port, (int)port);
        this.server.addChannel(port + 0 + 1);
        this.server.addChannel(port + 1 + 1);
        this.server.addChannel(port + 2 + 1);
        this.server.getServices().addServices(new HostedService[]{new RpcHostedService(), new RmiHostedService(), new ChatHostedService(0), new GameSessionHostedService(this.systems)});
        EtherealHost ethereal = new EtherealHost(GameConstants.OBJECT_PROTOCOL, GameConstants.ZONE_GRID, GameConstants.ZONE_RADIUS);
        ethereal.getZones().setSupportLargeObjects(true);
        ethereal.setTimeSource(new TimeSource(){

            public long getTime() {
                return GameServer.this.systems.getStepTime().getUnlockedTime(System.nanoTime());
            }
        });
        this.server.getServices().addService((HostedService)ethereal);
        ObservableEntityData ed = worldManager.getEntityData();
        this.systems.register(EntityData.class, (Object)ed);
        this.server.getServices().addService((HostedService)new EntityDataHostedService(1, ed));
        World world = worldManager.getWorld();
        this.systems.register(World.class, (Object)world);
        this.server.getServices().addService((HostedService)new WorldHostedService(world, 2));
        this.systems.register(CellArrayStorage.class, (Object)worldManager.getCellArrayStorage());
        this.systems.addSystem((GameSystem)new LargeGridIndexSystem(GameConstants.LARGE_OBJECT_GRID));
        this.systems.addSystem((GameSystem)new EntityUpdater((EntityDataHostedService)this.server.getServices().getService(EntityDataHostedService.class)));
        this.systems.addSystem((GameSystem)new DecaySystem());
        this.systems.register(WorldTimeSource.class, (Object)new WorldTimeService());
        ShapeFactoryRegistry shapeFactory = ShapeRegistryBuilder.serverRegistry((WorldManager)worldManager);
        this.systems.register(ShapeFactory.class, (Object)shapeFactory);
        EntityBodyFactory bodyFactory = new EntityBodyFactory((EntityData)ed, GameConstants.DEFAULT_GRAVITY, (ShapeFactory)shapeFactory);
        MPhysSystem mphys = new MPhysSystem(GameConstants.PHYSICS_GRID, bodyFactory);
        Collider[] colliders = new ColliderFactories(true).createColliders(BlockTypeIndex.getTypes());
        MBlockCollisionSystem collisionSystem = new MBlockCollisionSystem(worldManager.getPhysicalWorld(), colliders);
        mphys.setCollisionSystem((CollisionSystem)collisionSystem);
        this.systems.register(MPhysSystem.class, (Object)mphys);
        this.systems.register(PhysicsSpace.class, (Object)mphys.getPhysicsSpace());
        this.systems.register(EntityBodyFactory.class, (Object)bodyFactory);
        this.systems.register(ZoneNetworkSystem.class, (Object)new ZoneNetworkSystem(ethereal.getZones()));
        this.systems.addSystem((GameSystem)new BodyPositionPublisher());
        this.systems.register(MovementSystem.class, (Object)new MovementSystem());
        this.systems.register(CharacterAnimationSystem.class, (Object)new CharacterAnimationSystem());
        this.systems.register(AttachmentSystem.class, (Object)new AttachmentSystem());
        this.systems.register(PathRecorderSystem.class, (Object)new PathRecorderSystem());
        this.systems.register(HoldingSystem.class, (Object)new HoldingSystem());
        this.systems.register(ShellService.class, (Object)new ShellService());
        this.setupShell((ShellService)this.systems.get(ShellService.class), tokenSupplier != null);
        this.systems.register(CommandSystem.class, (Object)new CommandSystem());
        ObjectTypeRegistry objectTypes = new ObjectTypeRegistry().typeNameResolver(id -> {
            ObjectTypeInfo typeInfo = (ObjectTypeInfo)ed.getComponent(id, ObjectTypeInfo.class);
            return typeInfo == null ? null : typeInfo.getTypeName((EntityData)ed);
        });
        this.systems.register(ObjectTypeRegistry.class, (Object)objectTypes);
        objectTypes.setDefaultType(new ObjectType("Default", new ObjectAction[0]));
        this.registerSerializers();
        PrebuiltObjectSetup.setupTypes(this.systems);
        this.setupAdminShell();
        worldManager.getModManager().loadFromResource("/mythruna/server/server-admin.json");
        worldManager.getModManager().setGlobalBinding("gameSystems", (Object)this.systems);
        worldManager.getModManager().setGlobalBinding("server", (Object)this);
        worldManager.getModManager().initialize();
        AccountManager acctMgr = (AccountManager)this.systems.get(AccountManager.class);
        if (acctMgr != null) {
            this.server.getServices().addService((HostedService)new AccountHostedService(worldManager, (EntityData)ed, acctMgr));
        } else if (tokenSupplier != null) {
            this.server.getServices().addService((HostedService)new AccountHostedService(worldManager, (EntityData)ed, tokenSupplier));
        } else if (tokenSupplier == null) {
            throw new RuntimeException("No account manager defined, no token supplier defined.");
        }
    }

    protected void registerSerializers() {
        Serializer.registerClass(Quatd.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(Vec3d.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(Vec3i.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(Name.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(SpawnPosition.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(BodyPosition.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(ShapeInfo.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(Mass.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(Array.newInstance(EntityComponent.class, 0).getClass(), (Serializer)new ArraySerializer());
        Serializer.registerClass(LargeObject.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(LargeGridCell.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(LayerConfig.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(AnimationConfig.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(MovementInput.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(CreationTime.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(WorldSeed.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(WorldAge.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(Holding.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(ContainedIn.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(ObjectVolume.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(ContainerVolume.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(ObjectFocus.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(ObjectName.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(BlueprintInfo.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(BlueprintData.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(Option.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(PromptType.class, (Serializer)new EnumSerializer());
        Serializer.registerClass(ClaimArea.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(ClaimMarker.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(ClaimPermissions.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(ClaimType.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(OwnedBy.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(ObjectTypeInfo.class, (Serializer)new FieldSerializer());
    }

    protected void setupShell(ShellService shellService, boolean singlePlayer) {
        CommandShell global = shellService.getGlobalShell();
        global.addCommand("help", (ShellCommand)new Help());
        if (singlePlayer) {
            global.addCommand("echo", (ShellCommand)new Echo());
        }
        global.put("systems", (Object)this.systems);
    }

    protected void setupAdminShell() {
        this.adminShell = ((ShellService)this.systems.get(ShellService.class)).createChildShell((Object)this.worldManager.getWorldEntity());
        ChatHostedService chat = (ChatHostedService)this.server.getServices().getService(ChatHostedService.class);
        Say say = new Say(text -> chat.postMessage(-1, "<admin-console>", text));
        this.adminShell.addCommand("say", (ShellCommand)say);
        this.adminShell.addCommand("'", (ShellCommand)say);
    }

    public Server getServer() {
        return this.server;
    }

    public GameSystemManager getSystems() {
        return this.systems;
    }

    public CommandShell getAdminShell() {
        return this.adminShell;
    }

    public void start() {
        log.info("Starting game server...");
        this.server.start();
        this.loop.start(true);
        log.info("Game server started.");
    }

    public void close(String kickMessage) {
        log.info("Stopping game server..." + kickMessage);
        this.loop.stop();
        if (kickMessage != null) {
            for (HostedConnection conn : this.server.getConnections()) {
                conn.close(kickMessage);
            }
        }
        this.server.close();
        this.worldManager.getModManager().terminate();
        if (this.systems.isInitialized()) {
            this.systems.stop();
            this.systems.terminate();
        }
        log.info("Game server stopped.");
    }

    public void close() {
        this.close(null);
    }

    public void logStats() {
        EtherealHost host = (EtherealHost)this.server.getServices().getService(EtherealHost.class);
        for (HostedConnection conn : this.server.getConnections()) {
            log.info("Client[" + conn.getId() + "] address:" + conn.getAddress());
            NetworkStateListener listener = host.getStateListener(conn);
            if (listener == null) {
                log.info("[" + conn.getId() + "] No stats");
                continue;
            }
            log.info("[" + conn.getId() + "] Ping time: " + (double)listener.getConnectionStats().getAveragePingTime() / 1000000.0 + " ms");
            String miss = String.format("%.02f", listener.getConnectionStats().getAckMissPercent());
            log.info("[" + conn.getId() + "] Ack miss: " + miss + "%");
            log.info("[" + conn.getId() + "] Average msg size: " + listener.getConnectionStats().getAverageMessageSize() + " bytes");
        }
    }
}

