/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.fractal;

import com.simsilica.fractal.ElevationSource;
import org.progeeks.map.AbstractNoiseElevationGenerator;
import org.progeeks.map.ElevationData;

public class FractalElevationSource
implements ElevationSource {
    private AbstractNoiseElevationGenerator[] generators;
    private ElevationData baseMap = new ElevationData(1024);
    private ElevationData resultData;
    private boolean flatten = false;
    private int seaDepth = 64;
    private int maxTerrainHeight = 512;

    public FractalElevationSource(AbstractNoiseElevationGenerator ... generators) {
        this.generators = generators;
        this.baseMap.setElevationOffset(0);
        this.baseMap.setElevationScale(1);
        generators[0].setSourceData(this.baseMap);
        ElevationData lastData = null;
        for (int i = 0; i < generators.length; ++i) {
            AbstractNoiseElevationGenerator eg = generators[i];
            if (lastData != null) {
                eg.setSourceData(lastData);
            }
            lastData = eg.getGeneratedData();
            eg.invalidate();
        }
        if (lastData == null) {
            lastData = this.baseMap;
        }
        this.resultData = lastData;
    }

    public void setFlatten(boolean b) {
        this.flatten = b;
    }

    protected double getElevationRaw(double x, double y) {
        double z = 0.0;
        int sourceScale = 1;
        int sourceOffset = 0;
        int sourceElevation = 0;
        for (AbstractNoiseElevationGenerator gen : this.generators) {
            double scale = gen.getElevationScale();
            double offset = gen.getElevationOffset();
            int adjustedScale = sourceScale + (int)(scale + offset);
            int adjustedOffset = sourceOffset - (int)offset;
            double sourceZ = 0.0;
            if (gen.isAffected()) {
                sourceZ = (z - (double)sourceOffset) / (double)sourceScale;
            }
            z = !gen.isAdditive() ? (double)((int)Math.round(gen.getLayeredElevation(x, y, sourceZ) * scale + offset)) : (double)(sourceElevation + (int)Math.round(gen.getLayeredElevation(x, y, sourceZ) * scale + offset));
            sourceScale = adjustedScale;
            sourceOffset = adjustedOffset;
            sourceElevation = (int)z;
        }
        return z;
    }

    @Override
    public double getElevation(double x, double y) {
        x = x / 11.0 + 512.0;
        y = y / 11.0 + 512.0;
        double height = this.getElevationRaw(x, y);
        int minElev = -this.seaDepth;
        int maxElev = this.maxTerrainHeight + minElev;
        double maxMapElev = 20000.0;
        double minMapElev = -5000.0;
        if (height >= 0.0) {
            double t = height / maxMapElev;
            double d = Math.min(1.0, t);
            if (t > 1.0) {
                d -= t - 1.0;
            }
            if (this.flatten && d < 0.5) {
                d *= 2.0;
                d *= d;
                d *= 0.5;
            }
            d = d * (double)(maxElev - minElev) - (double)minElev;
            return d;
        }
        double d = Math.min(1.0, height / minMapElev);
        d = 1.0 - d;
        d = 1.0 - d;
        d = d * (double)minElev - (double)minElev;
        return d;
    }
}

