/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock.io;

import com.google.common.base.Charsets;
import com.simsilica.mblock.BlockName;
import com.simsilica.mblock.BlockType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockTypeData {
    public static final long formatVersion = 42L;
    static Logger log = LoggerFactory.getLogger(BlockTypeData.class);
    public int badTypeIndex;
    public BlockType[] types;

    public BlockTypeData() {
    }

    public BlockTypeData(BlockType[] types, int badTypeIndex) {
        this.types = types;
        this.badTypeIndex = badTypeIndex;
    }

    public boolean update(BlockTypeData update) {
        if (Arrays.asList(this.types).equals(Arrays.asList(update.types))) {
            return false;
        }
        BlockName updateBadType = null;
        if (update.badTypeIndex >= 0 && update.badTypeIndex < update.types.length) {
            BlockType bt = update.types[update.badTypeIndex];
            updateBadType = bt != null ? bt.getName() : null;
        }
        BlockName badType = null;
        if (this.badTypeIndex >= 0 && this.badTypeIndex < this.types.length) {
            BlockType bt = this.types[this.badTypeIndex];
            badType = bt != null ? bt.getName() : null;
        }
        HashMap<BlockName, BlockType> index = new HashMap<BlockName, BlockType>();
        for (BlockType type : this.types) {
            if (type == null) continue;
            index.put(type.getName(), type);
        }
        ArrayList<BlockType> newTypes = new ArrayList<BlockType>(Arrays.asList(this.types));
        for (BlockType type : update.types) {
            if (type == null) continue;
            BlockType existing = (BlockType)index.get(type.getName());
            if (existing == null) {
                log.info("New type:" + type.getName());
                newTypes.add(type);
                index.put(type.getName(), type);
                continue;
            }
            if (Objects.equals(type, existing)) continue;
            log.info("Replacing:" + existing.getName());
            int i = newTypes.indexOf(existing);
            if (i < 0) {
                throw new RuntimeException("Data format error: existing block type not found in type list, type:" + existing.getName());
            }
            newTypes.set(i, type);
            index.put(type.getName(), type);
        }
        if (!Objects.equals(badType, updateBadType)) {
            log.info("Updating bad type index, old type:" + badType + " new type:" + updateBadType);
            BlockType bad = updateBadType == null ? null : (BlockType)index.get(updateBadType);
            this.badTypeIndex = newTypes.indexOf(bad);
            log.info("New bad type index:" + this.badTypeIndex);
        }
        this.types = newTypes.toArray(new BlockType[0]);
        return true;
    }

    public static BlockTypeData load(InputStream rawIn) throws IOException {
        try (ObjectInputStream in = new ObjectInputStream(rawIn);){
            BlockTypeData result = new BlockTypeData();
            long version = in.readLong();
            try {
                result.types = (BlockType[])in.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Error resolving types", e);
            }
            result.badTypeIndex = in.readInt();
            BlockTypeData blockTypeData = result;
            return blockTypeData;
        }
    }

    public static BlockTypeData load(String resource) throws IOException {
        URL u = BlockTypeData.class.getResource(resource);
        if (u == null) {
            return null;
        }
        return BlockTypeData.load(u.openStream());
    }

    public static BlockTypeData load(File f) throws IOException {
        if (!f.exists()) {
            return null;
        }
        return BlockTypeData.load(new FileInputStream(f));
    }

    public static void store(BlockTypeData data, File f) throws IOException {
        BlockTypeData.store(data, new FileOutputStream(f));
    }

    public static void store(BlockTypeData data, OutputStream rawOut) throws IOException {
        try (ObjectOutputStream out = new ObjectOutputStream(rawOut);){
            out.writeLong(42L);
            out.writeObject(data.types);
            out.writeInt(data.badTypeIndex);
        }
    }

    public void writeIndex(File f) throws IOException {
        FileOutputStream fOut = new FileOutputStream(f);
        try (PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)fOut, Charsets.UTF_8));){
            out.println("# Generated:" + String.format("%1$tF %1$tT", new Date()));
            for (int i = 0; i < this.types.length; ++i) {
                BlockType type = this.types[i];
                if (type == null) continue;
                out.println("[" + i + "] " + type.getName());
            }
        }
    }
}

