/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.es.sql;

import com.simsilica.es.EntityComponent;
import com.simsilica.es.PersistentComponent;
import com.simsilica.es.PersistentEntityData;
import com.simsilica.es.base.ComponentHandler;
import com.simsilica.es.base.DefaultEntityData;
import com.simsilica.es.sql.PersistentEntityIdGenerator;
import com.simsilica.es.sql.SqlComponentHandler;
import com.simsilica.es.sql.SqlSession;
import com.simsilica.es.sql.SqlStringIndex;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlEntityData
extends DefaultEntityData
implements PersistentEntityData {
    static Logger log = LoggerFactory.getLogger(SqlEntityData.class);
    private String dbPath;
    private ThreadLocal<SqlSession> cachedSession = new ThreadLocal();
    private Set<Class> persistentTypes = new HashSet<Class>();

    public SqlEntityData(File dbPath, long writeDelay) throws SQLException {
        this(dbPath.toURI().toString(), writeDelay);
    }

    public SqlEntityData(String dbPath, long writeDelay) throws SQLException {
        super(null);
        this.dbPath = dbPath;
        try {
            Class.forName("org.hsqldb.jdbc.JDBCDriver");
        }
        catch (ClassNotFoundException e) {
            throw new SQLException("Driver not found for: org.hsqldb.jdbc.JDBCDriver", e);
        }
        this.execute("SET FILES WRITE DELAY " + writeDelay + " MILLIS");
        this.execute("SET FILES DEFRAG 50");
        this.setIdGenerator(PersistentEntityIdGenerator.create(this));
        this.setStringIndex(new SqlStringIndex(this, 100));
    }

    @Override
    public <T extends EntityComponent> void markPersistentType(Class<T> type) {
        if (this.hasHandler(type)) {
            throw new IllegalStateException("Handler already initialized for type:" + type);
        }
        this.persistentTypes.add(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(String statement) throws SQLException {
        SqlSession session = this.getSession();
        try (Statement st = session.getConnection().createStatement();){
            st.execute(statement);
        }
    }

    protected SqlSession getSession() throws SQLException {
        SqlSession session = this.cachedSession.get();
        if (session != null) {
            return session;
        }
        this.dbPath = this.dbPath.replaceAll("%20", " ");
        Connection conn = DriverManager.getConnection("jdbc:hsqldb:" + this.dbPath + "/entity_db", "SA", "");
        log.info("Created connection.  Autocommit:" + conn.getAutoCommit());
        session = new SqlSession(conn);
        this.cachedSession.set(session);
        return session;
    }

    @Override
    protected <T extends EntityComponent> ComponentHandler<T> lookupDefaultHandler(Class<T> type) {
        if (PersistentComponent.class.isAssignableFrom(type) || this.persistentTypes.contains(type)) {
            return new SqlComponentHandler<T>(this, type);
        }
        return super.lookupDefaultHandler(type);
    }

    @Override
    public void close() {
        super.close();
        try {
            SqlSession session = this.getSession();
            this.execute("SHUTDOWN COMPACT");
            session.getConnection().close();
        }
        catch (SQLException e) {
            throw new RuntimeException("Database was not shutdown cleanly", e);
        }
    }
}

