/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.es.server;

import com.jme3.network.HostedConnection;
import com.jme3.network.MessageListener;
import com.jme3.network.Server;
import com.jme3.network.service.AbstractHostedService;
import com.jme3.network.service.HostedServiceManager;
import com.simsilica.es.EntityData;
import com.simsilica.es.ObservableEntityData;
import com.simsilica.es.net.EntitySerializers;
import com.simsilica.es.server.EntityHostSettings;
import com.simsilica.es.server.HostedEntityData;
import com.simsilica.es.server.SessionDataDelegator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityDataHostedService
extends AbstractHostedService
implements EntityHostSettings {
    static Logger log = LoggerFactory.getLogger(EntityDataHostedService.class);
    private int channel;
    private final ObservableEntityData ed;
    private boolean autoHost = true;
    private int maxEntityBatchSize = 20;
    private int maxChangeBatchSize = 20;
    private SessionDataDelegator delegator;

    public EntityDataHostedService(int channel, ObservableEntityData ed) {
        this(channel, ed, true);
    }

    public EntityDataHostedService(int channel, ObservableEntityData ed, boolean autoHost) {
        this.channel = channel;
        this.ed = ed;
        this.autoHost = autoHost;
        EntitySerializers.initialize();
    }

    public EntityData getEntityData() {
        return this.ed;
    }

    @Override
    public int getChannel() {
        return this.channel;
    }

    public void sendUpdates() {
        for (HostedConnection conn : this.getServer().getConnections()) {
            HostedEntityData hed = (HostedEntityData)conn.getAttribute("hostedEntityData");
            if (hed == null) continue;
            hed.sendUpdates();
        }
    }

    public void startHostingOnConnection(HostedConnection hc) {
        log.debug("startHostingOnConnection:" + hc);
        hc.setAttribute("hostedEntityData", (Object)new HostedEntityData(this, hc, this.ed));
    }

    public void stopHostingOnConnection(HostedConnection hc) {
        HostedEntityData hed = (HostedEntityData)hc.getAttribute("hostedEntityData");
        if (hed == null) {
            return;
        }
        log.debug("stopHostingOnConnection:" + hc);
        hc.setAttribute("hostedEntityData", null);
        hed.close();
    }

    public HostedEntityData getHostedEntityData(HostedConnection hc) {
        return (HostedEntityData)hc.getAttribute("hostedEntityData");
    }

    public void setMaxEntityBatchSize(int i) {
        this.maxEntityBatchSize = i;
    }

    @Override
    public int getMaxEntityBatchSize() {
        return this.maxEntityBatchSize;
    }

    public void setMaxChangeBatchSize(int i) {
        this.maxChangeBatchSize = i;
    }

    @Override
    public int getMaxChangeBatchSize() {
        return this.maxChangeBatchSize;
    }

    public void setAutoHost(boolean b) {
        this.autoHost = b;
    }

    public boolean getAutoHost() {
        return this.autoHost;
    }

    protected void onInitialize(HostedServiceManager services) {
        this.delegator = new SessionDataDelegator(HostedEntityData.class, "hostedEntityData", true);
        this.getServer().addMessageListener((MessageListener)this.delegator, this.delegator.getMessageTypes());
    }

    public void start() {
    }

    public void stop() {
        for (HostedConnection conn : this.getServer().getConnections()) {
            this.stopHostingOnConnection(conn);
        }
    }

    public void terminate(HostedServiceManager hsm) {
        this.getServer().removeMessageListener((MessageListener)this.delegator, this.delegator.getMessageTypes());
    }

    public void connectionAdded(Server server, HostedConnection hc) {
        log.debug("Connection added:" + hc);
        if (this.autoHost) {
            this.startHostingOnConnection(hc);
        }
    }

    public void connectionRemoved(Server server, HostedConnection hc) {
        log.debug("Connection removed:" + hc);
        this.stopHostingOnConnection(hc);
    }
}

