/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.thread;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.thread.Job;
import com.simsilica.thread.WorkerPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(JobState.class);
    public static final int DEFAULT_PRIORITY = Integer.MAX_VALUE;
    private int finishPerFrame = 1;
    private WorkerPool workers;
    private VersionedHolder<Integer> queuedCount = new VersionedHolder((Object)0);
    private VersionedHolder<Integer> activeCount = new VersionedHolder((Object)0);

    public JobState() {
        this(4);
    }

    public JobState(int poolSize) {
        this(null, poolSize, 1);
    }

    public JobState(String id, int poolSize, int finishPerFrame) {
        super(id);
        this.finishPerFrame = finishPerFrame;
        this.workers = new WorkerPool(poolSize);
    }

    public void setFinishPerFrame(int finishPerFrame) {
        this.finishPerFrame = finishPerFrame;
    }

    public int getFinishPerFrame() {
        return this.finishPerFrame;
    }

    public void execute(Job job) {
        this.workers.execute(job);
    }

    public void execute(Job job, int priority) {
        this.workers.execute(job, priority);
    }

    public boolean cancel(Job job) {
        return this.workers.cancel(job);
    }

    public boolean isQueued(Job job) {
        return this.workers.isQueued(job);
    }

    public int getQueuedCount() {
        return (Integer)this.queuedCount.getObject();
    }

    public VersionedReference<Integer> createQueuedCountReference() {
        return this.queuedCount.createReference();
    }

    public int getActiveCount() {
        return (Integer)this.activeCount.getObject();
    }

    public VersionedReference<Integer> createActiveCountReference() {
        return this.activeCount.createReference();
    }

    protected void initialize(Application app) {
    }

    protected void cleanup(Application app) {
        this.workers.shutdownNow(false);
    }

    protected void onEnable() {
    }

    protected void onDisable() {
    }

    public void update(float tpf) {
        this.workers.update(this.finishPerFrame);
        this.queuedCount.updateObject((Object)this.workers.getQueuedJobCount());
        this.activeCount.updateObject((Object)this.workers.getActiveJobCount());
    }
}

