/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mphys;

import com.simsilica.mathd.filter.Filterd;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PhysicsStats {
    public static final String STAT_CONTACTS = "contacts";
    public static final String STAT_CONTACT_GEN_TIME = "contactGenTime";
    public static final String STAT_CONTACT_RES_TIME = "contactResTime";
    public static final String STAT_FRAME_TIME = "frameTime";
    public static final String STAT_BIN_COUNT = "binCount";
    public static final String STAT_ACTIVE_BIN_COUNT = "activeBinCount";
    public static final String STAT_BODY_COUNT = "bodyCount";
    public static final String STAT_ACTIVE_BODY_COUNT = "activeBodyCount";
    private Map<String, Number> stats = new ConcurrentHashMap<String, Number>();

    public PhysicsStats() {
        this.stats.put(STAT_CONTACTS, 0);
        this.stats.put(STAT_CONTACT_GEN_TIME, 0);
        this.stats.put(STAT_CONTACT_RES_TIME, 0);
        this.stats.put(STAT_FRAME_TIME, 0);
        this.stats.put(STAT_BIN_COUNT, 0);
        this.stats.put(STAT_ACTIVE_BIN_COUNT, 0);
        this.stats.put(STAT_BODY_COUNT, 0);
        this.stats.put(STAT_ACTIVE_BODY_COUNT, 0);
    }

    public Number get(String name) {
        Number num = this.stats.get(name);
        if (num == null) {
            throw new IllegalArgumentException("No such stat:" + name);
        }
        return num;
    }

    public double getDouble(String name) {
        return this.get(name).doubleValue();
    }

    public long getLong(String name) {
        return this.get(name).longValue();
    }

    protected Stat getStat(String name) {
        return new Stat(name, null);
    }

    protected Stat getStat(String name, Filterd filter) {
        return new Stat(name, filter);
    }

    public class Stat {
        private String target;
        private Filterd filter;

        public Stat(String target, Filterd filter) {
            this.target = target;
            this.filter = filter;
        }

        public void updateValue(double d) {
            if (this.filter != null) {
                this.filter.addValue(d);
                PhysicsStats.this.stats.put(this.target, this.filter.getFilteredValue());
            } else {
                PhysicsStats.this.stats.put(this.target, d);
            }
        }
    }
}

