/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.ext.mphys;

import com.simsilica.es.Entity;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.EntitySet;
import com.simsilica.ext.mphys.BinEntityManager;
import com.simsilica.ext.mphys.EntityBodyFactory;
import com.simsilica.ext.mphys.Impulse;
import com.simsilica.ext.mphys.Mass;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.mathd.Grid;
import com.simsilica.mphys.AbstractShape;
import com.simsilica.mphys.CollisionSystem;
import com.simsilica.mphys.PhysicsListener;
import com.simsilica.mphys.PhysicsSpace;
import com.simsilica.sim.AbstractGameSystem;
import com.simsilica.sim.SimTime;
import java.util.Set;

public class MPhysSystem<S extends AbstractShape>
extends AbstractGameSystem {
    private PhysicsSpace<EntityId, S> phys;
    private Grid zoneGrid;
    private EntityData ed;
    private BinEntityManager<S> binManager;
    private EntityBodyFactory<S> bodyFactory;
    private EntitySet impulses;

    public MPhysSystem(Grid zoneGrid, EntityBodyFactory<S> bodyFactory) {
        this.zoneGrid = zoneGrid;
        this.bodyFactory = bodyFactory;
        this.phys = new PhysicsSpace(zoneGrid);
    }

    public void setEntityData(EntityData ed) {
        if (this.isInitialized()) {
            throw new IllegalStateException("System is already initialized");
        }
        this.ed = ed;
    }

    public EntityData getEntityData() {
        return this.ed;
    }

    public PhysicsSpace<EntityId, S> getPhysicsSpace() {
        return this.phys;
    }

    public BinEntityManager<S> getBinEntityManager() {
        return this.binManager;
    }

    public EntityBodyFactory<S> getBodyFactory() {
        return this.bodyFactory;
    }

    public void setCollisionSystem(CollisionSystem<EntityId, S> collisionSystem) {
        this.phys.setCollisionSystem(collisionSystem);
    }

    public CollisionSystem<EntityId, S> getCollisionSystem() {
        return this.phys.getCollisionSystem();
    }

    public void addPhysicsListener(PhysicsListener<EntityId, S> l) {
        this.phys.addPhysicsListener(l);
    }

    public void removePhysicsListener(PhysicsListener<EntityId, S> l) {
        this.phys.removePhysicsListener(l);
    }

    protected void initialize() {
        if (this.ed == null) {
            this.ed = (EntityData)this.getSystem(EntityData.class, true);
        }
        this.binManager = new BinEntityManager(this.ed);
        this.phys.addBinListener(this.binManager);
        this.phys.setPhysicsFactory(this.bodyFactory);
    }

    protected void terminate() {
    }

    public void start() {
        super.start();
        this.impulses = this.ed.getEntities(new Class[]{ShapeInfo.class, Mass.class, Impulse.class});
    }

    public void update(SimTime time) {
        this.binManager.update();
        this.impulses.applyChanges();
        if (!this.impulses.isEmpty()) {
            this.applyImpulses((Set<Entity>)this.impulses);
        }
        double tpf = 0.016666666666666666;
        this.phys.integrate(time.getTime(), tpf);
    }

    public void stop() {
        super.stop();
        this.impulses.release();
    }

    protected void applyImpulses(Set<Entity> impulses) {
        for (Entity e : impulses) {
            Impulse imp = (Impulse)e.get(Impulse.class);
            if (!this.phys.applyImpulse((Object)e.getId(), imp.getLinearVelocity())) continue;
            this.ed.removeComponent(e.getId(), Impulse.class);
        }
    }
}

