/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock.geom;

import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.mesh.IndexBuffer;
import com.jme3.util.BufferUtils;
import com.simsilica.mblock.BlockType;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.Direction;
import com.simsilica.mblock.FluidType;
import com.simsilica.mblock.FluidTypeIndex;
import com.simsilica.mblock.FluidUtils;
import com.simsilica.mblock.LightUtils;
import com.simsilica.mblock.MaskUtils;
import com.simsilica.mblock.geom.ColliderlessMesh;
import com.simsilica.mblock.geom.DefaultPartBuffer;
import com.simsilica.mblock.geom.GeomPart;
import com.simsilica.mblock.geom.GeomReq;
import com.simsilica.mblock.geom.MaterialType;
import com.simsilica.mblock.geom.ScaledBuffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeometryFactory {
    static Logger log = LoggerFactory.getLogger(GeometryFactory.class);
    private Map<String, Material> materials;
    private boolean allowCollisions;

    public GeometryFactory(Map<String, Material> materials) {
        this(true, materials);
    }

    public GeometryFactory(boolean allowCollisions, Map<String, Material> materials) {
        this.allowCollisions = allowCollisions;
        this.materials = materials;
    }

    public Node generateBlocks(Node target, CellArray cells, CellData lightData, boolean smoothLighting) {
        long start = System.nanoTime();
        Node result = target;
        result.detachAllChildren();
        DefaultPartBuffer buffer = new DefaultPartBuffer();
        int xSize = cells.getSizeX();
        int ySize = cells.getSizeY();
        int zSize = cells.getSizeZ();
        for (int x = 0; x < xSize; ++x) {
            for (int y = 0; y < ySize; ++y) {
                for (int z = 0; z < zSize; ++z) {
                    BlockType blockType;
                    int val = cells.getCell(x, y, z);
                    int type = MaskUtils.getType(val);
                    if (type == 0 || (blockType = BlockTypeIndex.get(type)) == null) continue;
                    int sideMask = MaskUtils.getSideMask(val);
                    blockType.getFactory().addGeometryToBuffer(buffer, x, y, z, x, y, z, sideMask, cells, blockType);
                }
            }
        }
        LightGradient gradient = null;
        gradient = smoothLighting ? this.calculateLightGradient(cells, lightData) : new NoLightGradient(lightData);
        this.renderBuffer(result, buffer, gradient, lightData);
        long end = System.nanoTime();
        if (log.isTraceEnabled()) {
            log.trace("Generated in:" + (double)(end - start) / 1000000.0 + " ms");
        }
        return result;
    }

    public Node generateFluid(Node target, CellArray fluid, CellArray cells, CellData lightData, boolean smoothLighting) {
        if (fluid == null) {
            return target;
        }
        long start = System.nanoTime();
        Node result = target;
        result.detachAllChildren();
        DefaultPartBuffer buffer = new DefaultPartBuffer();
        int xSize = fluid.getSizeX();
        int ySize = fluid.getSizeY();
        int zSize = fluid.getSizeZ();
        for (int x = 0; x < xSize; ++x) {
            for (int y = 0; y < ySize; ++y) {
                for (int z = 0; z < zSize; ++z) {
                    FluidType fluidType;
                    int val = fluid.getCell(x, y, z);
                    int type = FluidUtils.getType(val);
                    if (type == 0 || (fluidType = FluidTypeIndex.get(type)) == null) continue;
                    int level = FluidUtils.getLevel(val);
                    int sideMask = FluidUtils.getSideMask(val);
                    fluidType.getFactory().addGeometryToBuffer(buffer, x, y, z, x, y, z, sideMask, level, cells, fluid, fluidType);
                }
            }
        }
        LightGradient gradient = null;
        gradient = smoothLighting ? this.calculateLightGradient(fluid, lightData) : new NoLightGradient(lightData);
        this.renderBuffer(result, buffer, gradient, lightData);
        long end = System.nanoTime();
        if (log.isTraceEnabled()) {
            log.trace("Generated in:" + (double)(end - start) / 1000000.0 + " ms");
        }
        return result;
    }

    protected void renderBuffer(Node target, DefaultPartBuffer buffer, LightGradient gradient, CellData lightData) {
        for (DefaultPartBuffer.PartList list : buffer.getPartLists()) {
            RenderState.BlendMode blendMode;
            if (list.list.isEmpty()) continue;
            MaterialType mt = list.materialType;
            int vertCount = list.vertCount;
            ScaledBuffer pos = mt.requires(GeomReq.LoResPositions) ? ScaledBuffer.createScaledBuffer(vertCount * 3, 0.0f, 32.0f) : ScaledBuffer.createUnscaledBuffer(vertCount * 3);
            ScaledBuffer texes = mt.requires(GeomReq.LoResTexCoords) ? ScaledBuffer.createScaledBuffer(vertCount * 2, 0.0f, 1.0f) : ScaledBuffer.createUnscaledBuffer(vertCount * 2);
            IndexBuffer indexes = IndexBuffer.createIndexBuffer((int)vertCount, (int)(list.triCount * 3));
            FloatBuffer colors = BufferUtils.createFloatBuffer((int)(vertCount * 4));
            ScaledBuffer nb = null;
            ScaledBuffer tb = null;
            ByteBuffer dirB = null;
            if (mt.requires(GeomReq.IndexedNormals)) {
                dirB = BufferUtils.createByteBuffer((int)vertCount);
            } else {
                if (mt.requires(GeomReq.Normals)) {
                    nb = mt.requires(GeomReq.LoResNormals) ? ScaledBuffer.createScaledBuffer(vertCount * 3, -1.0f, 1.0f) : ScaledBuffer.createUnscaledBuffer(vertCount * 3);
                }
                if (mt.requires(GeomReq.Tangents)) {
                    tb = mt.requires(GeomReq.LoResTangents) ? ScaledBuffer.createScaledBuffer(vertCount * 3, -1.0f, 1.0f) : ScaledBuffer.createUnscaledBuffer(vertCount * 3);
                }
            }
            int baseIndex = 0;
            for (DefaultPartBuffer.PartEntry entry : list.list) {
                int i = entry.i;
                int j = entry.j;
                int k = entry.k;
                GeomPart part = entry.part;
                byte dir = (byte)part.getDirection();
                if (dirB != null && dir < 0) {
                    throw new RuntimeException("Entry for material:" + mt + " has invalid dir:" + dir);
                }
                Direction dirEnum = dir >= 0 ? Direction.values()[dir] : null;
                int size = part.getVertexCount();
                float[] verts = part.getCoords();
                float[] norms = part.getNormals();
                float[] tangents = part.getTangents();
                int vIndex = 0;
                for (int v = 0; v < size; ++v) {
                    float x = verts[vIndex++];
                    float y = verts[vIndex++];
                    float z = verts[vIndex++];
                    pos.put((float)i + x);
                    pos.put((float)j + y);
                    pos.put((float)k + z);
                    if (dirB != null) {
                        dirB.put(dir);
                    }
                    gradient.appendLight(lightData, i, j, k, x, y, z, dirEnum, colors);
                }
                if (nb != null && norms != null) {
                    nb.put(norms);
                }
                if (tb != null && tangents != null) {
                    tb.put(tangents);
                }
                float[] texArray = part.getTexCoords();
                for (int t = 0; t < texArray.length; ++t) {
                    texes.put(texArray[t]);
                }
                for (short s : part.getIndexes()) {
                    indexes.put(baseIndex + s);
                }
                baseIndex += size;
            }
            ColliderlessMesh mesh = new ColliderlessMesh(this.allowCollisions);
            pos.applyToMesh(mesh, VertexBuffer.Type.Position, 3);
            texes.applyToMesh(mesh, VertexBuffer.Type.TexCoord, 2);
            switch (indexes.getFormat()) {
                case UnsignedInt: {
                    mesh.setBuffer(VertexBuffer.Type.Index, 3, (IntBuffer)indexes.getBuffer());
                    break;
                }
                case UnsignedShort: {
                    mesh.setBuffer(VertexBuffer.Type.Index, 3, (ShortBuffer)indexes.getBuffer());
                    break;
                }
                case UnsignedByte: {
                    mesh.setBuffer(VertexBuffer.Type.Index, 3, (ByteBuffer)indexes.getBuffer());
                }
            }
            if (dirB != null && dirB.position() != 0) {
                mesh.setBuffer(VertexBuffer.Type.Size, 1, dirB);
            }
            if (nb != null && nb.position() != 0) {
                nb.applyToMesh(mesh, VertexBuffer.Type.Normal, 3);
            }
            if (tb != null && tb.position() != 0) {
                tb.applyToMesh(mesh, VertexBuffer.Type.Tangent, 3);
            }
            mesh.setBuffer(VertexBuffer.Type.Color, 4, colors);
            mesh.setStatic();
            mesh.updateBound();
            Geometry geom = new Geometry("mesh:" + mt + ":" + (Object)((Object)list.primitiveType), (Mesh)mesh);
            Material mat = this.materials.get(mt.getId());
            if (mat == null) {
                MaterialType bad = new MaterialType("bad", mt.getGeomReqs());
                mat = this.materials.get(bad.getId());
            }
            if (mat == null) {
                log.debug("all keys:" + this.materials.keySet());
                throw new RuntimeException("Materal not found for:" + mt.getId());
            }
            geom.setMaterial(mat);
            if (mt.getLayer() != null) {
                geom.setUserData("layer", (Object)mt.getLayer());
            }
            if ((blendMode = geom.getMaterial().getAdditionalRenderState().getBlendMode()) == RenderState.BlendMode.Alpha || blendMode == RenderState.BlendMode.AlphaAdditive) {
                log.debug("Putting in transparent bucket:" + geom);
                geom.setQueueBucket(RenderQueue.Bucket.Transparent);
            }
            target.attachChild((Spatial)geom);
        }
    }

    private int average(int ... lights) {
        int s = 0;
        int r = 0;
        int g = 0;
        int b = 0;
        int count = 0;
        for (int i : lights) {
            if (i == -65536) continue;
            s += LightUtils.sun(i);
            r += LightUtils.red(i);
            g += LightUtils.green(i);
            b += LightUtils.blue(i);
            ++count;
        }
        if (count == 0) {
            return 0;
        }
        return LightUtils.toLight(s / count, r / count, g / count, b / count);
    }

    private LightGradient calculateLightGradient(CellArray cells, CellData lightData) {
        int xSize = cells.getSizeX();
        int ySize = cells.getSizeY();
        int zSize = cells.getSizeZ();
        CellArray corners = new CellArray(xSize + 1, ySize + 1, zSize + 1);
        for (int x = 0; x <= xSize; ++x) {
            for (int y = 0; y <= ySize; ++y) {
                for (int z = 0; z <= zSize; ++z) {
                    int l1 = lightData.getCell(x - 1, y - 1, z - 1);
                    int l2 = lightData.getCell(x, y - 1, z - 1);
                    int l3 = lightData.getCell(x, y, z - 1);
                    int l4 = lightData.getCell(x - 1, y, z - 1);
                    int l5 = lightData.getCell(x - 1, y - 1, z);
                    int l6 = lightData.getCell(x, y - 1, z);
                    int l7 = lightData.getCell(x, y, z);
                    int l8 = lightData.getCell(x - 1, y, z);
                    corners.setCell(x, y, z, this.average(l1, l2, l3, l4, l5, l6, l7, l8));
                }
            }
        }
        return new SmoothLightGradient(corners);
    }

    private class SmoothLightGradient
    implements LightGradient {
        CellArray corners;

        public SmoothLightGradient(CellArray corners) {
            this.corners = corners;
        }

        private float interp(float x, float x1, float x2) {
            return x1 + (x2 - x1) * x;
        }

        private float bilinearInterp(float x, float y, float nw, float ne, float se, float sw) {
            float n = this.interp(x, nw, ne);
            float s = this.interp(x, sw, se);
            return this.interp(y, n, s);
        }

        private float trilinearInterp(float x, float y, float z, float dnw, float dne, float dse, float dsw, float unw, float une, float use, float usw) {
            float d = this.bilinearInterp(x, y, dnw, dne, dse, dsw);
            float u = this.bilinearInterp(x, y, unw, une, use, usw);
            return this.interp(z, d, u);
        }

        private float accumToFloat(int accum) {
            int result = accum;
            return (float)result / 15.0f;
        }

        private float accToRed(int spread) {
            return this.accumToFloat(LightUtils.red(spread));
        }

        private float accToGreen(int spread) {
            return this.accumToFloat(LightUtils.green(spread));
        }

        private float accToBlue(int spread) {
            return this.accumToFloat(LightUtils.blue(spread));
        }

        private float accToSun(int spread) {
            return this.accumToFloat(LightUtils.sun(spread));
        }

        @Override
        public void appendLight(CellData lights, int i, int j, int k, float x, float y, float z, Direction dir, FloatBuffer colors) {
            int dnw = this.corners.getCell(i, j, k);
            int dne = this.corners.getCell(i + 1, j, k);
            int dse = this.corners.getCell(i + 1, j + 1, k);
            int dsw = this.corners.getCell(i, j + 1, k);
            int unw = this.corners.getCell(i, j, k + 1);
            int une = this.corners.getCell(i + 1, j, k + 1);
            int use = this.corners.getCell(i + 1, j + 1, k + 1);
            int usw = this.corners.getCell(i, j + 1, k + 1);
            float red = this.trilinearInterp(x, y, z, this.accToRed(dnw), this.accToRed(dne), this.accToRed(dse), this.accToRed(dsw), this.accToRed(unw), this.accToRed(une), this.accToRed(use), this.accToRed(usw));
            float green = this.trilinearInterp(x, y, z, this.accToGreen(dnw), this.accToGreen(dne), this.accToGreen(dse), this.accToGreen(dsw), this.accToGreen(unw), this.accToGreen(une), this.accToGreen(use), this.accToGreen(usw));
            float blue = this.trilinearInterp(x, y, z, this.accToBlue(dnw), this.accToBlue(dne), this.accToBlue(dse), this.accToBlue(dsw), this.accToBlue(unw), this.accToBlue(une), this.accToBlue(use), this.accToBlue(usw));
            float sun = this.trilinearInterp(x, y, z, this.accToSun(dnw), this.accToSun(dne), this.accToSun(dse), this.accToSun(dsw), this.accToSun(unw), this.accToSun(une), this.accToSun(use), this.accToSun(usw));
            colors.put(red).put(green).put(blue).put(sun);
        }
    }

    private class NoLightGradient
    implements LightGradient {
        CellData lightData;

        public NoLightGradient(CellData lightData) {
            this.lightData = lightData;
        }

        @Override
        public void appendLight(CellData lights, int i, int j, int k, float x, float y, float z, Direction dir, FloatBuffer colors) {
            if (dir != null) {
                switch (dir) {
                    case North: {
                        if (z != 0.0f) break;
                        --k;
                        break;
                    }
                    case South: {
                        if (z != 1.0f) break;
                        ++k;
                        break;
                    }
                    case East: {
                        if (x != 1.0f) break;
                        ++i;
                        break;
                    }
                    case West: {
                        if (x != 0.0f) break;
                        --i;
                        break;
                    }
                    case Up: {
                        if (y != 1.0f) break;
                        ++j;
                        break;
                    }
                    case Down: {
                        if (y != 0.0f) break;
                        --j;
                    }
                }
            }
            int l = lights.getCell(i, j, k, 61440);
            int s = l >> 12 & 0xF;
            int r = l >> 8 & 0xF;
            int g = l >> 4 & 0xF;
            int b = l & 0xF;
            colors.put((float)r / 15.0f).put((float)g / 15.0f).put((float)b / 15.0f).put((float)s / 15.0f);
        }
    }

    private static interface LightGradient {
        public void appendLight(CellData var1, int var2, int var3, int var4, float var5, float var6, float var7, Direction var8, FloatBuffer var9);
    }
}

