/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.opencl.lwjgl;

import com.jme3.opencl.MappingAccess;
import com.jme3.opencl.MemoryAccess;
import com.jme3.opencl.OpenCLException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.APPLEGLSharing;
import org.lwjgl.opencl.CL10;
import org.lwjgl.opencl.CL11;
import org.lwjgl.opencl.CL12;
import org.lwjgl.opencl.EXTDeviceFission;
import org.lwjgl.opencl.KHRGLSharing;
import org.lwjgl.opencl.KHRICD;

public class Utils {
    private static final Logger LOG = Logger.getLogger(Utils.class.getName());
    private static final Map<Integer, String> CL_ERROR_TOKENS = LWJGLUtil.getClassTokens((LWJGLUtil.TokenFilter)new LWJGLUtil.TokenFilter(){

        public boolean accept(Field field, int value) {
            return value < 0;
        }
    }, null, (Class[])new Class[]{CL10.class, CL11.class, CL12.class, KHRGLSharing.class, KHRICD.class, APPLEGLSharing.class, EXTDeviceFission.class});
    public static final ByteBuffer b80;
    public static final LongBuffer b80l;
    public static final FloatBuffer b80f;
    public static final TempBuffer[] tempBuffers;
    public static final PointerBuffer[] pointerBuffers;
    public static IntBuffer errorBuffer;

    private Utils() {
    }

    public static int getMajorVersion(String version, String prefix) {
        String s = version.substring(prefix.length());
        return Integer.parseInt(s);
    }

    public static int getMinorVersion(String version, String prefix) {
        String s = version.substring(prefix.length());
        int major = Integer.parseInt(s);
        s = s.substring((int)(Math.log10(major) + 2.0));
        return Integer.parseInt(s);
    }

    public static void checkError(IntBuffer errorBuffer, String callName) {
        Utils.checkError(errorBuffer.get(0), callName);
    }

    public static void checkError(int error, String callName) {
        if (error != 0) {
            String errorName = Utils.getErrorName(error);
            if (errorName == null) {
                errorName = "UNKNOWN";
            }
            throw new OpenCLException("OpenCL error in " + callName + ": " + errorName + " (0x" + Integer.toHexString(error) + ")", error);
        }
    }

    public static void reportError(int error, String callName) {
        if (error != 0) {
            String errorName = Utils.getErrorName(error);
            if (errorName == null) {
                errorName = "UNKNOWN";
            }
            LOG.log(Level.WARNING, "OpenCL error in {0}: {1} (0x{2})", new Object[]{callName, errorName, Integer.toHexString(error)});
        }
    }

    public static String getErrorName(int code) {
        return CL_ERROR_TOKENS.get(code);
    }

    public static long getMemoryAccessFlags(MemoryAccess ma) {
        switch (ma) {
            case READ_ONLY: {
                return 4L;
            }
            case WRITE_ONLY: {
                return 2L;
            }
            case READ_WRITE: {
                return 1L;
            }
        }
        throw new IllegalArgumentException("Unknown memory access: " + ma);
    }

    public static MemoryAccess getMemoryAccessFromFlag(long flag) {
        if ((flag & 1L) > 0L) {
            return MemoryAccess.READ_WRITE;
        }
        if ((flag & 4L) > 0L) {
            return MemoryAccess.READ_ONLY;
        }
        if ((flag & 2L) > 0L) {
            return MemoryAccess.WRITE_ONLY;
        }
        throw new OpenCLException("Unknown memory access flag: " + flag);
    }

    public static long getMappingAccessFlags(MappingAccess ma) {
        switch (ma) {
            case MAP_READ_ONLY: {
                return 1L;
            }
            case MAP_READ_WRITE: {
                return 3L;
            }
            case MAP_WRITE_ONLY: {
                return 2L;
            }
            case MAP_WRITE_INVALIDATE: {
                return 4L;
            }
        }
        throw new IllegalArgumentException("Unknown mapping access: " + ma);
    }

    static {
        tempBuffers = new TempBuffer[8];
        pointerBuffers = new PointerBuffer[8];
        for (int i = 0; i < 8; ++i) {
            Utils.tempBuffers[i] = new TempBuffer();
            Utils.pointerBuffers[i] = PointerBuffer.allocateDirect((int)4);
        }
        errorBuffer = BufferUtils.createIntBuffer((int)1);
        b80 = BufferUtils.createByteBuffer((int)80);
        b80l = b80.asLongBuffer();
        b80f = b80.asFloatBuffer();
    }

    public static final class TempBuffer {
        public final ByteBuffer b16 = BufferUtils.createByteBuffer((int)16);
        public final ShortBuffer b16s = this.b16.asShortBuffer();
        public final IntBuffer b16i = this.b16.asIntBuffer();
        public final LongBuffer b16l = this.b16.asLongBuffer();
        public final FloatBuffer b16f = this.b16.asFloatBuffer();
        public final DoubleBuffer b16d = this.b16.asDoubleBuffer();
    }
}

