/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur;

import com.google.common.base.Objects;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.Command;
import com.simsilica.lemur.DefaultRangedValueModel;
import com.simsilica.lemur.GridPanel;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.RangedValueModel;
import com.simsilica.lemur.Slider;
import com.simsilica.lemur.ValueRenderer;
import com.simsilica.lemur.component.BorderLayout;
import com.simsilica.lemur.component.QuadBackgroundComponent;
import com.simsilica.lemur.core.AbstractGuiControlListener;
import com.simsilica.lemur.core.CommandMap;
import com.simsilica.lemur.core.GuiControl;
import com.simsilica.lemur.core.GuiControlListener;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.core.VersionedObject;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.event.CursorButtonEvent;
import com.simsilica.lemur.event.CursorEventControl;
import com.simsilica.lemur.event.CursorListener;
import com.simsilica.lemur.event.CursorMotionEvent;
import com.simsilica.lemur.event.DefaultCursorListener;
import com.simsilica.lemur.grid.GridModel;
import com.simsilica.lemur.list.DefaultCellRenderer;
import com.simsilica.lemur.list.SelectionModel;
import com.simsilica.lemur.style.Attributes;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.lemur.style.StyleAttribute;
import com.simsilica.lemur.style.StyleDefaults;
import com.simsilica.lemur.style.Styles;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListBox<T>
extends Panel {
    static Logger log = LoggerFactory.getLogger(ListBox.class);
    public static final String ELEMENT_ID = "list";
    public static final String CONTAINER_ID = "container";
    public static final String ITEMS_ID = "items";
    public static final String SLIDER_ID = "slider";
    public static final String SELECTOR_ID = "selector";
    public static final String EFFECT_PRESS = "press";
    public static final String EFFECT_RELEASE = "release";
    public static final String EFFECT_CLICK = "click";
    public static final String EFFECT_ACTIVATE = "activate";
    public static final String EFFECT_DEACTIVATE = "deactivate";
    private ElementId baseElementId;
    private BorderLayout layout;
    private VersionedList<T> model;
    private VersionedReference<List<T>> modelRef;
    private ValueRenderer<T> cellRenderer;
    private SelectionModel selection;
    private VersionedReference<Set<Integer>> selectionRef;
    private ClickListener clickListener = new ClickListener();
    private BackgroundListener backgroundListener = new BackgroundListener();
    private CommandMap<ListBox, ListAction> commandMap = new CommandMap((Object)this);
    private GridPanel grid;
    private Slider slider;
    private Node selectorArea;
    private Panel selector;
    private Vector3f selectorAreaOrigin = new Vector3f();
    private Vector3f selectorAreaSize = new Vector3f();
    private RangedValueModel baseIndex;
    private VersionedReference<Double> indexRef;
    private int maxIndex;
    private boolean scrollOnHover = true;
    private boolean activated = false;
    private boolean entered = false;

    public ListBox() {
        this(true, new VersionedList(), null, new SelectionModel(), new ElementId(ELEMENT_ID), null);
    }

    public ListBox(VersionedList<T> model) {
        this(true, model, null, new SelectionModel(), new ElementId(ELEMENT_ID), null);
    }

    public ListBox(VersionedList<T> model, ValueRenderer<T> renderer, String style) {
        this(true, model, renderer, new SelectionModel(), new ElementId(ELEMENT_ID), style);
    }

    public ListBox(VersionedList<T> model, String style) {
        this(true, model, null, new SelectionModel(), new ElementId(ELEMENT_ID), style);
    }

    public ListBox(VersionedList<T> model, ElementId elementId, String style) {
        this(true, model, null, new SelectionModel(), elementId, style);
    }

    public ListBox(VersionedList<T> model, ValueRenderer<T> renderer, ElementId elementId, String style) {
        this(true, model, renderer, new SelectionModel(), elementId, style);
    }

    protected ListBox(boolean applyStyles, VersionedList<T> model, ValueRenderer<T> cellRenderer, SelectionModel selection, ElementId elementId, String style) {
        super(false, elementId.child(CONTAINER_ID), style);
        this.baseElementId = elementId;
        if (cellRenderer == null) {
            cellRenderer = new DefaultCellRenderer(this.baseElementId.child("item"), style);
        } else {
            cellRenderer.configureStyle(this.baseElementId.child("item"), style);
        }
        this.cellRenderer = cellRenderer;
        this.layout = new BorderLayout();
        ((GuiControl)this.getControl(GuiControl.class)).setLayout((GuiLayout)this.layout);
        this.grid = new GridPanel(new GridModelDelegate(), elementId.child(ITEMS_ID), style);
        this.grid.setVisibleColumns(1);
        ((GuiControl)this.grid.getControl(GuiControl.class)).addListener((GuiControlListener)new GridListener());
        this.layout.addChild((Node)this.grid, new Object[]{BorderLayout.Position.Center});
        this.baseIndex = new DefaultRangedValueModel();
        this.indexRef = this.baseIndex.createReference();
        this.slider = new Slider(this.baseIndex, Axis.Y, elementId.child(SLIDER_ID), style);
        this.layout.addChild((Node)this.slider, new Object[]{BorderLayout.Position.East});
        if (applyStyles) {
            Styles styles = GuiGlobals.getInstance().getStyles();
            styles.applyStyles((Object)this, this.getElementId(), style);
        }
        CursorEventControl.addListenersToSpatial((Spatial)this, (CursorListener[])new CursorListener[]{this.backgroundListener});
        this.selectorArea = new Node("selectorArea");
        this.attachChild((Spatial)this.selectorArea);
        this.selector = new Panel(elementId.child(SELECTOR_ID), style);
        this.setModel(model);
        this.resetModelRange();
        this.setSelectionModel(selection);
    }

    @StyleDefaults(value="list")
    public static void initializeDefaultStyles(Styles styles, Attributes attrs) {
        ElementId parent = new ElementId(ELEMENT_ID);
        QuadBackgroundComponent quad = new QuadBackgroundComponent(new ColorRGBA(0.8f, 0.9f, 0.1f, 1.0f));
        quad.getMaterial().getMaterial().getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Exclusion);
        styles.getSelector(parent.child(SELECTOR_ID), null).set("background", (Object)quad, false);
    }

    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        if (this.modelRef.update()) {
            this.resetModelRange();
        }
        boolean indexUpdate = this.indexRef.update();
        boolean selectionUpdate = this.selectionRef.update();
        if (indexUpdate) {
            int index = (int)((double)this.maxIndex - this.baseIndex.getValue());
            this.grid.setRow(index);
        }
        if (selectionUpdate || indexUpdate) {
            this.refreshSelector();
        }
        if (this.activated != this.entered) {
            this.refreshActivation();
        }
    }

    protected void gridResized(Vector3f pos, Vector3f size) {
        if (pos.equals((Object)this.selectorAreaOrigin) && size.equals((Object)this.selectorAreaSize)) {
            return;
        }
        this.selectorAreaOrigin.set(pos);
        this.selectorAreaSize.set(size);
        this.refreshSelector();
    }

    public void setModel(VersionedList<T> model) {
        if (this.model == model && model != null) {
            return;
        }
        if (this.model != null) {
            this.detachItemListeners();
        }
        if (model == null) {
            model = new VersionedList();
        }
        this.model = model;
        this.modelRef = model.createReference();
        this.grid.setLocation(0, 0);
        this.grid.setModel(new GridModelDelegate());
        this.resetModelRange();
        this.baseIndex.setValue((double)this.maxIndex);
        this.refreshSelector();
    }

    public VersionedList<T> getModel() {
        return this.model;
    }

    public Slider getSlider() {
        return this.slider;
    }

    public GridPanel getGridPanel() {
        return this.grid;
    }

    public void setSelectionModel(SelectionModel selection) {
        if (this.selection == selection) {
            return;
        }
        this.selection = selection;
        this.selectionRef = selection.createReference();
        this.refreshSelector();
    }

    public SelectionModel getSelectionModel() {
        return this.selection;
    }

    public T getSelectedItem() {
        Integer i = this.selection.getSelection();
        if (i == null) {
            return null;
        }
        if (i < 0 || i > this.getModel().size()) {
            return null;
        }
        return this.getModel().get(i);
    }

    public void addCommands(ListAction a, Command<? super ListBox> ... commands) {
        this.commandMap.addCommands((Object)a, commands);
    }

    public List<Command<? super ListBox>> getCommands(ListAction a) {
        return this.commandMap.get((Object)a, false);
    }

    public void addClickCommands(Command<? super ListBox> ... commands) {
        this.commandMap.addCommands((Object)ListAction.Click, commands);
    }

    public void removeClickCommands(Command<? super ListBox> ... commands) {
        this.getClickCommands().removeAll(Arrays.asList(commands));
    }

    public List<Command<? super ListBox>> getClickCommands() {
        return this.commandMap.get((Object)ListAction.Click, false);
    }

    @StyleAttribute(value="listCommands")
    public void setListCommands(Map<ListAction, List<Command<? super ListBox>>> map) {
        this.commandMap.clear();
        for (Map.Entry<ListAction, List<Command<? super ListBox>>> e : map.entrySet()) {
            this.commandMap.addCommands((Object)e.getKey(), (Collection)e.getValue());
        }
    }

    @StyleAttribute(value="visibleItems", lookupDefault=false)
    public void setVisibleItems(int count) {
        this.grid.setVisibleRows(count);
        this.resetModelRange();
        this.refreshSelector();
    }

    public int getVisibleItems() {
        return this.grid.getVisibleRows();
    }

    @StyleAttribute(value="cellRenderer", lookupDefault=false)
    public void setCellRenderer(ValueRenderer<T> renderer) {
        if (Objects.equal(this.cellRenderer, renderer)) {
            return;
        }
        this.cellRenderer = renderer;
        this.cellRenderer.configureStyle(this.baseElementId.child("item"), this.getStyle());
        this.grid.refreshGrid();
    }

    public ValueRenderer<T> getCellRenderer() {
        return this.cellRenderer;
    }

    public void setAlpha(float alpha, boolean recursive) {
        super.setAlpha(alpha, recursive);
        this.setChildAlpha((Spatial)this.selector, alpha);
    }

    @StyleAttribute(value="scrollOnHover", lookupDefault=false)
    public void setScrollOnHover(boolean f) {
        this.scrollOnHover = f;
    }

    public boolean getScrollOnHover() {
        return this.scrollOnHover;
    }

    protected void refreshSelector() {
        if (this.selectorArea == null) {
            return;
        }
        Panel selectedCell = null;
        if (this.selection != null && !this.selection.isEmpty()) {
            int selected = (Integer)this.selection.iterator().next();
            if (selected >= this.model.size()) {
                selected = this.model.size() - 1;
                this.selection.setSelection(selected);
            }
            selectedCell = this.grid.getCell(selected, 0);
        }
        if (selectedCell == null) {
            this.selectorArea.detachChild((Spatial)this.selector);
        } else {
            Vector3f size = selectedCell.getSize().clone();
            Vector3f loc = selectedCell.getLocalTranslation();
            Vector3f pos = this.selectorAreaOrigin.add(loc.x, loc.y, loc.z + size.z);
            this.selector.setLocalTranslation(pos);
            this.selector.setSize(size);
            this.selector.setPreferredSize(size);
            this.selectorArea.attachChild((Spatial)this.selector);
            this.selectorArea.setLocalTranslation(this.grid.getLocalTranslation());
        }
    }

    protected void resetModelRange() {
        int count = this.model == null ? 0 : this.model.size();
        int visible = this.grid.getVisibleRows();
        this.maxIndex = Math.max(0, count - visible);
        double val = this.baseIndex.getMaximum() - this.baseIndex.getValue();
        this.baseIndex.setMinimum(0.0);
        this.baseIndex.setMaximum((double)this.maxIndex);
        this.baseIndex.setValue((double)this.maxIndex - val);
    }

    protected void refreshActivation() {
        if (this.entered) {
            this.activate();
        } else {
            this.deactivate();
        }
    }

    protected Panel getListCell(int row, int col, Panel existing) {
        T value = this.model.get(row);
        Panel cell = this.cellRenderer.getView(value, false, existing);
        if (cell != existing) {
            CursorEventControl.addListenersToSpatial((Spatial)cell, (CursorListener[])new CursorListener[]{this.clickListener});
            CursorEventControl.removeListenersFromSpatial((Spatial)existing, (CursorListener[])new CursorListener[]{this.clickListener});
        }
        return cell;
    }

    protected void detachItemListeners() {
        int base = this.grid.getRow();
        for (int i = 0; i < this.grid.getVisibleRows(); ++i) {
            Panel cell = this.grid.getCell(base + i, 0);
            if (cell == null) continue;
            CursorEventControl.removeListenersFromSpatial((Spatial)cell, (CursorListener[])new CursorListener[]{this.clickListener});
        }
    }

    protected void scroll(int amount) {
        double delta = this.getSlider().getDelta();
        double value = this.getSlider().getModel().getValue();
        this.getSlider().getModel().setValue(value + delta * (double)amount);
    }

    protected void activate() {
        if (this.activated) {
            return;
        }
        this.activated = true;
        this.commandMap.runCommands((Object)ListAction.Entered);
        this.runEffect(EFFECT_ACTIVATE);
    }

    protected void deactivate() {
        if (!this.activated) {
            return;
        }
        this.activated = false;
        this.commandMap.runCommands((Object)ListAction.Exited);
        this.runEffect(EFFECT_DEACTIVATE);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "[elementId=" + this.getElementId() + "]";
    }

    protected class GridModelDelegate
    implements GridModel<Panel> {
        protected GridModelDelegate() {
        }

        @Override
        public int getRowCount() {
            if (ListBox.this.model == null) {
                return 0;
            }
            return ListBox.this.model.size();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public Panel getCell(int row, int col, Panel existing) {
            return ListBox.this.getListCell(row, col, existing);
        }

        @Override
        public void setCell(int row, int col, Panel value) {
            throw new UnsupportedOperationException("ListModel is read only.");
        }

        public long getVersion() {
            return ListBox.this.model == null ? 0L : ListBox.this.model.getVersion();
        }

        public GridModel<Panel> getObject() {
            return this;
        }

        public VersionedReference<GridModel<Panel>> createReference() {
            return new VersionedReference((VersionedObject)this);
        }
    }

    private class GridListener
    extends AbstractGuiControlListener {
        private GridListener() {
        }

        public void reshape(GuiControl source, Vector3f pos, Vector3f size) {
            ListBox.this.gridResized(pos, size);
            ListBox.this.refreshSelector();
        }
    }

    private class BackgroundListener
    extends DefaultCursorListener {
        private BackgroundListener() {
        }

        public void cursorEntered(CursorMotionEvent event, Spatial target, Spatial capture) {
            ListBox.this.entered = true;
        }

        public void cursorExited(CursorMotionEvent event, Spatial target, Spatial capture) {
            ListBox.this.entered = false;
        }

        public void cursorMoved(CursorMotionEvent event, Spatial target, Spatial capture) {
            if (event.getScrollDelta() != 0) {
                if (log.isTraceEnabled()) {
                    log.trace("Scroll delta:" + event.getScrollDelta() + "  value:" + event.getScrollValue());
                }
                if (ListBox.this.scrollOnHover) {
                    if (event.getScrollDelta() > 0) {
                        ListBox.this.scroll(Math.max(1, event.getScrollDelta() / 120));
                    } else {
                        ListBox.this.scroll(Math.min(-1, event.getScrollDelta() / 120));
                    }
                }
            }
        }
    }

    private class ClickListener
    extends DefaultCursorListener {
        private boolean pressed = false;

        private ClickListener() {
        }

        protected void click(CursorButtonEvent event, Spatial target, Spatial capture) {
            ListBox.this.commandMap.runCommands((Object)ListAction.Click);
            ListBox.this.runEffect(ListBox.EFFECT_CLICK);
        }

        public void cursorButtonEvent(CursorButtonEvent event, Spatial target, Spatial capture) {
            int base = ListBox.this.grid.getRow();
            for (int i = 0; i < ListBox.this.grid.getVisibleRows(); ++i) {
                Panel cell = ListBox.this.grid.getCell(base + i, 0);
                if (cell != target) continue;
                ListBox.this.selection.add(base + i);
            }
            event.setConsumed();
            if (event.isPressed()) {
                this.pressed = true;
                ListBox.this.commandMap.runCommands((Object)ListAction.Down);
                ListBox.this.runEffect(ListBox.EFFECT_PRESS);
            } else {
                if (target == capture || target == ListBox.this) {
                    this.click(event, target, capture);
                }
                if (this.pressed) {
                    ListBox.this.commandMap.runCommands((Object)ListAction.Up);
                    ListBox.this.runEffect(ListBox.EFFECT_RELEASE);
                    this.pressed = false;
                }
            }
        }

        public void cursorEntered(CursorMotionEvent event, Spatial target, Spatial capture) {
            ListBox.this.entered = true;
        }

        public void cursorExited(CursorMotionEvent event, Spatial target, Spatial capture) {
            ListBox.this.entered = false;
        }
    }

    public static enum ListAction {
        Down,
        Up,
        Click,
        Entered,
        Exited;

    }
}

