/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld;

import com.google.common.base.MoreObjects;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.LeafId;
import com.simsilica.mworld.transaction.CellEdit;

public class CellChangeEvent {
    private LeafId leafId;
    private CellEdit[] blockChanges;
    private CellEdit[] lightChanges;
    private CellEdit[] fluidChanges;

    private CellChangeEvent() {
    }

    public CellChangeEvent(LeafId leafId, CellEdit[] blockChanges, CellEdit[] lightChanges, CellEdit[] fluidChanges) {
        this.leafId = leafId;
        this.blockChanges = blockChanges;
        this.lightChanges = lightChanges;
        this.fluidChanges = fluidChanges;
    }

    public final LeafId getLeafId() {
        return this.leafId;
    }

    public final Vec3i getLeafWorld() {
        return this.leafId.getWorld(null);
    }

    public final CellEdit[] getBlockChanges() {
        return this.blockChanges;
    }

    public final CellEdit[] getLightChanges() {
        return this.lightChanges;
    }

    public final CellEdit[] getFluidChanges() {
        return this.fluidChanges;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("leafId", (Object)this.leafId).add("blockChangeCount", this.blockChanges == null ? 0 : this.blockChanges.length).add("lightChangeCount", this.lightChanges == null ? 0 : this.lightChanges.length).add("fluidChangeCount", this.fluidChanges == null ? 0 : this.fluidChanges.length).toString();
    }
}

