/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld;

import com.google.common.base.MoreObjects;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.Direction;
import com.simsilica.mworld.LeafId;
import com.simsilica.mworld.WorldGrids;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FluidData
implements CellData {
    static Logger log = LoggerFactory.getLogger(FluidData.class);
    private static final int SIZE = 32;
    private static final int CELL_COUNT = 32768;
    private static final boolean SLOW_CHECKS = false;
    private LeafId leafId;
    private CellArray cells;
    private int emptyCellCount;

    public FluidData(LeafId leafId) {
        this(leafId, null, 32768);
    }

    public FluidData(LeafId leafId, CellArray cells, int emptyCellCount) {
        this.leafId = leafId;
        this.cells = cells;
        this.emptyCellCount = emptyCellCount;
        if (emptyCellCount < 0) {
            this.fixCounts();
        }
        assert (this.checkCounts());
    }

    public final boolean checkCounts() {
        if (this.cells == null) {
            if (!this.isEmpty()) {
                log.error("No cells but inconsistent counts, empty:" + this.emptyCellCount);
                return false;
            }
            return true;
        }
        int e = 0;
        for (int val : this.cells.getArray()) {
            if (val != 0) continue;
            ++e;
        }
        if (e != this.emptyCellCount) {
            log.error("Cell count check failed, counted empty:" + e + "  But have empty:" + this.emptyCellCount);
            return false;
        }
        return true;
    }

    public final boolean fixCounts() {
        if (this.cells == null) {
            if (this.isEmpty()) {
                return false;
            }
            this.emptyCellCount = 32768;
            return true;
        }
        int e = 0;
        for (int val : this.cells.getArray()) {
            if (val != 0) continue;
            ++e;
        }
        if (e != this.emptyCellCount) {
            this.emptyCellCount = e;
            return true;
        }
        return false;
    }

    public LeafId getLeafId() {
        return this.leafId;
    }

    public final int getEmptyCellCount() {
        return this.emptyCellCount;
    }

    public final boolean isEmpty() {
        return this.emptyCellCount == 32768;
    }

    public final boolean containsCell(Vec3i world) {
        return this.containsCell(world.x, world.y, world.z);
    }

    public final boolean containsCell(int x, int y, int z) {
        long id = WorldGrids.LEAF_GRID.worldToId((double)x, (double)y, (double)z);
        return id == this.leafId.getId();
    }

    private boolean isValid(int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0) {
            return false;
        }
        return x < 32 && y < 32 && z < 32;
    }

    public int getCell(int x, int y, int z) {
        assert (this.isValid(x, y, z)) : "[" + x + ", " + y + ", " + z + "]";
        if (this.cells == null) {
            return 0;
        }
        return this.cells.getCell(x, y, z);
    }

    public int getCell(int x, int y, int z, int defaultValue) {
        assert (this.isValid(x, y, z)) : "[" + x + ", " + y + ", " + z + "]";
        if (this.cells == null) {
            return 0;
        }
        return this.cells.getCell(x, y, z, defaultValue);
    }

    public int getCell(int x, int y, int z, Direction dir, int defaultValue) {
        assert (this.isValid(x, y, z)) : "[" + x + ", " + y + ", " + z + "]";
        if (this.cells == null) {
            return 0;
        }
        return this.cells.getCell(x, y, z, dir, defaultValue);
    }

    public void setCell(int x, int y, int z, int value) {
        assert (this.isValid(x, y, z)) : "[" + x + ", " + y + ", " + z + "]";
        if (this.cells == null) {
            if (value == 0 && this.isEmpty()) {
                return;
            }
            this.cells = new CellArray(32);
            if (!this.isEmpty()) {
                throw new RuntimeException("Invalid state during cell array initialization");
            }
            this.cells.setCell(x, y, z, value);
            if (this.isEmpty()) {
                --this.emptyCellCount;
            }
            return;
        }
        int oldVal = this.cells.getCell(x, y, z);
        if (oldVal == value) {
            return;
        }
        this.cells.setCell(x, y, z, value);
        int oEmpty = this.emptyCellCount--;
        if (oldVal == 0) {
            // empty if block
        }
        if (value == 0) {
            ++this.emptyCellCount;
        }
    }

    public CellArray getRawCells() {
        return this.cells;
    }

    public int[] getArray() {
        return this.cells == null ? null : this.cells.getArray();
    }

    public void compact() {
        if (this.isEmpty()) {
            this.cells = null;
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("id", (Object)this.leafId).add("emptyCellCount", this.emptyCellCount).add("cells", (Object)this.cells).toString();
    }
}

