/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld;

import com.simsilica.lemur.core.VersionedObject;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.mworld.ProgressTracker;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressTrackers {
    static Logger log = LoggerFactory.getLogger(ProgressTrackers.class);
    private static ConcurrentHashMap<Thread, ThreadTrackers> trackedThreads = new ConcurrentHashMap();
    private static ThreadLocal<ThreadTrackers> threadTrackers = new ThreadLocal<ThreadTrackers>(){

        @Override
        protected ThreadTrackers initialValue() {
            ThreadTrackers trackers = new ThreadTrackers();
            trackedThreads.put(trackers.thread, trackers);
            return trackers;
        }
    };
    private static AtomicLong version = new AtomicLong();
    private static Holder versionedObject = new Holder();

    private ProgressTrackers() {
    }

    public static ProgressTracker openTracker(String name) {
        return ProgressTrackers.threadTrackers.get().openTracker(name);
    }

    public static void close(ProgressTracker tracker) {
        ProgressTrackers.threadTrackers.get().close(tracker);
    }

    public static Collection<ThreadTrackers> getThreadTrackers() {
        return Collections.unmodifiableCollection(trackedThreads.values());
    }

    public static VersionedReference<Collection<ThreadTrackers>> createReference() {
        return versionedObject.createReference();
    }

    private static class Holder
    implements VersionedObject<Collection<ThreadTrackers>> {
        private Holder() {
        }

        public long getVersion() {
            return version.get();
        }

        public Collection<ThreadTrackers> getObject() {
            return ProgressTrackers.getThreadTrackers();
        }

        public VersionedReference<Collection<ThreadTrackers>> createReference() {
            return new VersionedReference((VersionedObject)this);
        }
    }

    public static class ThreadTrackers
    implements Iterable<ProgressTracker> {
        private Thread thread;
        private List<ProgressTracker> trackers = new CopyOnWriteArrayList<ProgressTracker>();

        public ThreadTrackers() {
            this.thread = Thread.currentThread();
        }

        public Thread getThread() {
            return this.thread;
        }

        @Override
        public Iterator<ProgressTracker> iterator() {
            return Collections.unmodifiableCollection(this.trackers).iterator();
        }

        private ProgressTracker openTracker(String name) {
            ProgressTracker tracker = new ProgressTracker(name);
            this.trackers.add(tracker);
            version.incrementAndGet();
            return tracker;
        }

        private void close(ProgressTracker tracker) {
            int index = this.trackers.indexOf(tracker);
            if (index < 0) {
                throw new IllegalArgumentException("Specified tracker is not open:" + tracker);
            }
            if (index != this.trackers.size() - 1) {
                log.error("Removing tracker:" + tracker + " that is not the top of the stack:" + this.trackers.get(this.trackers.size() - 1));
            }
            this.trackers.remove(index);
            version.incrementAndGet();
        }

        public String toString() {
            return "ThreadTrackers[thread:" + this.thread + ", trackers:" + this.trackers + "]";
        }
    }
}

