/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld;

import com.simsilica.mathd.Grid;
import com.simsilica.mathd.GridCell;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.GridBasedId;
import com.simsilica.mworld.SedectileId;
import com.simsilica.mworld.WorldGrids;
import java.util.Objects;

public class TileId
implements GridBasedId {
    public static final int SIZE = 1024;
    public static final Grid GRID = WorldGrids.TILE_GRID;
    private long tileId;

    public TileId(long tileId) {
        this.tileId = tileId;
    }

    public static TileId fromWorld(Vec3i world) {
        return TileId.fromWorld(world.x, world.z);
    }

    public static TileId fromWorld(Vec3d world) {
        return TileId.fromWorld(world.x, world.z);
    }

    public static TileId fromWorld(double x, double z) {
        long id = GRID.worldToId(x, 0.0, z);
        return new TileId(id);
    }

    public static TileId fromWorld(int x, int z) {
        long id = GRID.worldToId((double)x, 0.0, (double)z);
        return new TileId(id);
    }

    public static TileId fromCell(int xCell, int zCell) {
        long id = GRID.cellToId(xCell, 0, zCell);
        return new TileId(id);
    }

    @Override
    public long getId() {
        return this.tileId;
    }

    @Override
    public Vec3i getWorld(Vec3i store) {
        Vec3i loc = GRID.idToCell(this.tileId, store);
        loc = GRID.cellToWorld(loc, loc);
        return loc;
    }

    public Vec3i getCell(Vec3i store) {
        return GRID.idToCell(this.tileId, store);
    }

    @Override
    public GridCell getGridCell() {
        return this.getGrid().getContainingCell(this.getWorld(null));
    }

    public SedectileId getSedectileId() {
        Vec3i world = this.getWorld(null);
        return SedectileId.fromWorld(world);
    }

    @Override
    public Grid getGrid() {
        return GRID;
    }

    @Override
    public Grid getParentGrid() {
        return SedectileId.GRID;
    }

    public int hashCode() {
        return Objects.hash(this.tileId);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        TileId other = (TileId)o;
        return other.tileId == this.tileId;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.tileId + "]";
    }
}

