/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.db;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.Direction;
import com.simsilica.mblock.LightUtils;
import com.simsilica.mworld.ColumnData;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.LightData;
import com.simsilica.mworld.db.ColumnDb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnLightData
implements CellData {
    static Logger log = LoggerFactory.getLogger(ColumnLightData.class);
    private ColumnDb columnDb;
    private ColumnData center;
    private ColumnData[][] columns = new ColumnData[3][3];
    private int yTop;

    public ColumnLightData(ColumnDb columnDb, ColumnData[][] columns) {
        this.columnDb = columnDb;
        this.columns = columns;
        this.center = columns[1][1];
        this.yTop = this.center.getLighting().length * 32;
    }

    public int getCeiling() {
        return this.yTop;
    }

    public static ColumnLightData loadNeighborhood(ColumnDb columnDb, ColumnData center, boolean readOnlyNeighbors) {
        Vec3i world = center.getColumnId().getWorld(null);
        int radius = 1;
        int size = radius * 2 + 1;
        ColumnData[][] columns = new ColumnData[size][size];
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (x == 0 && z == 0) {
                    columns[x + radius][z + radius] = center;
                    continue;
                }
                ColumnId id = ColumnId.fromWorld(world.x + x * 32, world.z + z * 32);
                ColumnData col = columnDb.getColumn(id);
                if (readOnlyNeighbors) {
                    LightData[] lighting = col.getLighting();
                    LightData[] empties = new LightData[lighting.length];
                    for (int i = 0; i < empties.length; ++i) {
                        empties[i] = new LightData(lighting[i].getLeafId(), null, 32768, 0);
                    }
                    col = new ColumnData(col.getColumnId(), col.getLeafs(), null, empties, col.getVersion(), col.getGenerationFlags());
                }
                columns[x + radius][z + radius] = col;
            }
        }
        return new ColumnLightData(columnDb, columns);
    }

    private ColumnData getColumn(int x, int z) {
        int i = (x + 32) / 32;
        int j = (z + 32) / 32;
        return this.columns[i][j];
    }

    public int getCell(int x, int y, int z) {
        return this.getCell(x, y, z, -1);
    }

    public int getCell(int x, int y, int z, int defaultValue) {
        if (y < 0) {
            return defaultValue;
        }
        if (y >= this.yTop) {
            return LightUtils.DIRECT_SUN;
        }
        ColumnData col = this.getColumn(x, z);
        if (col == null) {
            return defaultValue;
        }
        int k = y / 32;
        if (k >= col.getLighting().length) {
            log.info("BAD: k:" + k + " y:" + y + "  yTop:" + this.yTop + "  length:" + col.getLighting().length);
            return LightUtils.DIRECT_SUN;
        }
        LightData lighting = col.getLighting()[k];
        if (lighting.isSolidDark()) {
            return -65536;
        }
        if (lighting.isFullSun()) {
            return LightUtils.DIRECT_SUN;
        }
        if (x < 0) {
            x += 32;
        } else if (x >= 32) {
            x -= 32;
        }
        if (z < 0) {
            z += 32;
        } else if (z >= 32) {
            z -= 32;
        }
        return lighting.getCell(x, y - k * 32, z);
    }

    private int getCell2(int x, int y, int z, int defaultValue) {
        log.info("getCell2(" + x + ", " + y + ", " + z + ") yTop:" + this.yTop);
        if (y < 0) {
            return defaultValue;
        }
        if (y >= this.yTop) {
            return LightUtils.DIRECT_SUN;
        }
        ColumnData col = this.getColumn(x, z);
        log.info("getCell2() col:" + col);
        if (col == null) {
            return defaultValue;
        }
        int k = y / 32;
        if (k >= col.getLighting().length) {
            log.info("BAD: k:" + k + " y:" + y + "  yTop:" + this.yTop + "  length:" + col.getLighting().length);
        }
        LightData lighting = col.getLighting()[k];
        log.info("getCell2() lighting:" + lighting);
        if (lighting.isSolidDark()) {
            return -65536;
        }
        if (lighting.isFullSun()) {
            return LightUtils.DIRECT_SUN;
        }
        if (x < 0) {
            x += 32;
        } else if (x >= 32) {
            x -= 32;
        }
        if (z < 0) {
            z += 32;
        } else if (z >= 32) {
            z -= 32;
        }
        log.info("getCell2() on:" + lighting + " at:" + x + ", " + (y - k * 32) + ", " + z);
        return lighting.getCell(x, y - k * 32, z);
    }

    public int getCell(int x, int y, int z, Direction dir, int defaultValue) {
        Vec3i v = dir.getVec3i();
        return this.getCell(x + v.x, y + v.y, z + v.z, defaultValue);
    }

    public void setCell(int x, int y, int z, int value) {
        int ox = x;
        int oy = y;
        int oz = z;
        ColumnData col = this.getColumn(x, z);
        if (col == null) {
            throw new RuntimeException("ColumnData not found for:" + x + ", " + z);
        }
        if (x < 0) {
            x += 32;
        } else if (x >= 32) {
            x -= 32;
        }
        if (z < 0) {
            z += 32;
        } else if (z >= 32) {
            z -= 32;
        }
        int k = y / 32;
        LightData lighting = col.getLighting()[k];
        lighting.setCell(x, y - k * 32, z, value);
        int retest = lighting.getCell(x, y - k * 32, z, -1);
        if (retest != value) {
            throw new RuntimeException("Value not set for:" + lighting + " at:" + x + ", " + (y - k * 32) + ", " + z + " from:" + ox + ", " + oy + ", " + oz + " value:" + value + "  found:" + retest);
        }
        retest = this.getCell(ox, oy, oz, -1);
        if (retest != value) {
            int retest2 = this.getCell2(ox, oy, oz, -1);
            if (retest != retest2) {
                throw new RuntimeException("What the hell is going on?");
            }
            throw new RuntimeException("Value not set for:" + lighting + " at:" + x + ", " + (y - k * 32) + ", " + z + " from:" + ox + ", " + oy + ", " + oz + " value:" + value + "  found:" + retest);
        }
    }
}

