/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.db;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.GridBasedId;
import com.simsilica.mworld.db.GridCellFileFunction;
import java.io.File;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdFileFunction<T extends GridBasedId>
implements Function<T, File> {
    static Logger log = LoggerFactory.getLogger(GridCellFileFunction.class);
    private File root;
    private int shift;
    private String extension;

    public IdFileFunction(File root, int shift, String extension) {
        this.root = root;
        this.shift = shift;
        if (extension.charAt(0) == '.') {
            extension = extension.substring(1);
        }
        this.extension = extension;
    }

    @Override
    public File apply(GridBasedId id) {
        Vec3i cell = id.getGrid().idToCell(id.getId());
        File dir = new File(this.root, (cell.x >> this.shift) + "/" + (cell.z >> this.shift));
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return new File(dir, id.getId() + "." + this.extension);
    }
}

