/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.db;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.GridBasedId;
import java.io.File;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParentIdFileFunction<T extends GridBasedId>
implements Function<T, File> {
    static Logger log = LoggerFactory.getLogger(ParentIdFileFunction.class);
    private File root;
    private String extension;

    public ParentIdFileFunction(File root, String extension) {
        this.root = root;
        if (extension.charAt(0) == '.') {
            extension = extension.substring(1);
        }
        this.extension = extension;
    }

    @Override
    public File apply(GridBasedId id) {
        Vec3i world = id.getWorld(null);
        Vec3i parentCell = id.getParentGrid().worldToCell(world.toVec3d());
        File dir = new File(this.root, parentCell.x + "/" + parentCell.z);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return new File(dir, id.getId() + "." + this.extension);
    }
}

