/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.io;

import com.simsilica.ethereal.io.BitInputStream;
import com.simsilica.ethereal.io.BitOutputStream;
import com.simsilica.mworld.CellChangeEvent;
import com.simsilica.mworld.DataType;
import com.simsilica.mworld.LeafId;
import com.simsilica.mworld.io.ObjectProtocol;
import com.simsilica.mworld.transaction.CellEdit;
import java.io.IOException;

public class CellChangeEventProtocol
implements ObjectProtocol<CellChangeEvent> {
    private int protocolVersion = 1;

    @Override
    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public void write(CellChangeEvent event, BitOutputStream out) throws IOException {
        out.writeBits(this.protocolVersion, 8);
        out.writeLongBits(event.getLeafId().getId(), 64);
        this.writeChanges(event.getBlockChanges(), DataType.Block, out);
        this.writeChanges(event.getLightChanges(), DataType.Light, out);
        this.writeChanges(event.getFluidChanges(), DataType.Fluid, out);
    }

    @Override
    public CellChangeEvent read(BitInputStream in) throws IOException {
        int version = in.readBits(8);
        LeafId leafId = new LeafId(in.readLongBits(64));
        CellEdit[] blocks = this.readChanges(DataType.Block, in);
        CellEdit[] lights = this.readChanges(DataType.Light, in);
        CellEdit[] fluids = this.readChanges(DataType.Fluid, in);
        return new CellChangeEvent(leafId, blocks, lights, fluids);
    }

    protected void writeChanges(CellEdit[] edits, DataType type, BitOutputStream out) throws IOException {
        if (edits == null) {
            out.writeBits(0, 16);
            return;
        }
        out.writeBits(edits.length, 16);
        for (CellEdit edit : edits) {
            out.writeBits((int)edit.getX(), 5);
            out.writeBits((int)edit.getY(), 5);
            out.writeBits((int)edit.getZ(), 5);
            out.writeBits(edit.getValue(), 32);
        }
    }

    protected CellEdit[] readChanges(DataType type, BitInputStream in) throws IOException {
        int size = in.readBits(16);
        if (size == 0) {
            return null;
        }
        CellEdit[] edits = new CellEdit[size];
        for (int i = 0; i < size; ++i) {
            byte x = (byte)in.readBits(5);
            byte y = (byte)in.readBits(5);
            byte z = (byte)in.readBits(5);
            int value = in.readBits(32);
            edits[i] = new CellEdit(x, y, z, value);
        }
        return edits;
    }
}

