/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.net.client;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.io.BlockTypeData;
import com.simsilica.mblock.io.FluidTypeData;
import com.simsilica.mworld.CellChangeEvent;
import com.simsilica.mworld.FluidData;
import com.simsilica.mworld.LeafChangeEvent;
import com.simsilica.mworld.LeafData;
import com.simsilica.mworld.LeafId;
import com.simsilica.mworld.LightData;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.base.AbstractWorld;
import com.simsilica.mworld.io.ProtocolSerializers;
import com.simsilica.mworld.net.WorldDataSession;
import com.simsilica.mworld.tile.Resolution;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.TerrainImageType;
import com.simsilica.mworld.tile.TileChangeEvent;
import com.simsilica.mworld.tile.pc.PointCloudLayer;
import com.simsilica.mworld.tile.tree.TreeLayer;
import com.simsilica.mworld.tile.tree.TreeTypeIndex;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteWorldData
extends AbstractWorld {
    static Logger log = LoggerFactory.getLogger(RemoteWorldData.class);
    private WorldDataSession delegate;
    private int yMax;
    private AtomicLong nextRequestId = new AtomicLong(42L);
    private Map<Long, PacketCollector> packetCollectors = new ConcurrentHashMap<Long, PacketCollector>();
    private ProtocolSerializers protocols = new ProtocolSerializers();
    private LoadingCache<LeafId, LeafData> leafCache = CacheBuilder.newBuilder().removalListener((RemovalListener)new RemovalListener<LeafId, LeafData>(){

        public void onRemoval(RemovalNotification<LeafId, LeafData> notification) {
            if (log.isTraceEnabled()) {
                log.trace("cacheRemoval(" + notification + ") reason:" + notification.getCause());
            }
        }
    }).weakValues().build((CacheLoader)new CacheLoader<LeafId, LeafData>(){

        public LeafData load(LeafId key) {
            return RemoteWorldData.this.loadLeaf(key);
        }
    });
    private LoadingCache<LeafId, LightData> lightCache = CacheBuilder.newBuilder().removalListener((RemovalListener)new RemovalListener<LeafId, LightData>(){

        public void onRemoval(RemovalNotification<LeafId, LightData> notification) {
            if (log.isTraceEnabled()) {
                log.trace("cacheRemoval(" + notification + ") reason:" + notification.getCause());
            }
        }
    }).weakValues().build((CacheLoader)new CacheLoader<LeafId, LightData>(){

        public LightData load(LeafId key) {
            return RemoteWorldData.this.loadLight(key);
        }
    });
    private LoadingCache<LeafId, FluidData> fluidCache = CacheBuilder.newBuilder().removalListener((RemovalListener)new RemovalListener<LeafId, FluidData>(){

        public void onRemoval(RemovalNotification<LeafId, FluidData> notification) {
            if (log.isTraceEnabled()) {
                log.trace("cacheRemoval(" + notification + ") reason:" + notification.getCause());
            }
        }
    }).weakValues().build((CacheLoader)new CacheLoader<LeafId, FluidData>(){

        public FluidData load(LeafId key) {
            return RemoteWorldData.this.loadFluid(key);
        }
    });

    public void start(WorldDataSession delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("World cannot be started with null WorldDataSession");
        }
        this.delegate = delegate;
    }

    @Override
    public int getMaxY() {
        if (this.yMax == 0 && this.delegate != null) {
            this.yMax = this.delegate.getMaxY();
        }
        return this.yMax;
    }

    @Override
    public int setWorldCell(Vec3d world, int cellType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public LeafData getLeaf(LeafId leafId) {
        return (LeafData)this.leafCache.getUnchecked((Object)leafId);
    }

    @Override
    public LightData getLight(LeafId leafId) {
        return (LightData)this.lightCache.getUnchecked((Object)leafId);
    }

    @Override
    public FluidData getFluid(LeafId leafId) {
        return (FluidData)this.fluidCache.getUnchecked((Object)leafId);
    }

    @Override
    public TerrainImage getTerrainImage(TileId id, TerrainImageType type, Resolution res) {
        return this.loadTerrainImage(id, type, res);
    }

    @Override
    public TreeLayer getTrees(TileId id, Resolution res) {
        return this.loadTrees(id, res);
    }

    @Override
    public PointCloudLayer getPointCloudLayer(TileId id, Resolution res) {
        return this.loadPointCloudLayer(id, res);
    }

    protected CellChangeEvent cellChanged(long leafId, byte[] data) {
        try {
            CellChangeEvent event = this.protocols.fromBytes(CellChangeEvent.class, data, false);
            this.applyChange(event);
            return event;
        }
        catch (IOException e) {
            throw new RuntimeException("Error deserializing cell change event data for:" + leafId, e);
        }
    }

    protected TileChangeEvent tileChanged(Class dataType, long tileId, long dataVersion, Resolution res) {
        TileChangeEvent event = new TileChangeEvent(dataType, new TileId(tileId), dataVersion, res);
        return event;
    }

    protected void applyChange(CellChangeEvent event) {
        log.info("applyChange(" + event + ")");
    }

    protected void applyChange(LeafChangeEvent event) {
        this.leafCache.invalidate((Object)event.getLeafId());
        this.lightCache.invalidate((Object)event.getLeafId());
        this.fluidCache.invalidate((Object)event.getLeafId());
    }

    protected WorldDataSession getDelegate() {
        if (this.delegate == null) {
            throw new IllegalStateException("Not started");
        }
        return this.delegate;
    }

    protected void partReceived(long requestId, byte part, byte total, byte[] data) {
        PacketCollector collector;
        if (log.isTraceEnabled()) {
            log.trace("partReceived(" + requestId + ", " + part + ", " + total + ", " + data + ")");
            log.trace("Received array length:" + (data == null ? "null" : String.valueOf(data.length)));
        }
        if ((collector = this.packetCollectors.get(requestId)) == null) {
            throw new RuntimeException("No collector found for:" + requestId);
        }
        collector.packetReceived(part, total, data);
    }

    protected PacketCollector newCollector() {
        long requestId = this.nextRequestId.incrementAndGet();
        PacketCollector collector = new PacketCollector(requestId);
        this.packetCollectors.put(requestId, collector);
        return collector;
    }

    protected <T> T waitForData(Class<T> type, PacketCollector collector) {
        byte[][] array = collector.getData();
        if (array == null) {
            return null;
        }
        this.packetCollectors.remove(collector.requestId);
        return this.protocols.fromPackets(type, Arrays.asList(array), true);
    }

    public BlockTypeData getBlockTypeData() {
        PacketCollector collector = this.newCollector();
        this.getDelegate().requestIndexData(collector.requestId, WorldDataSession.IndexType.BlockType);
        return this.waitForData(BlockTypeData.class, collector);
    }

    public FluidTypeData getFluidTypeData() {
        PacketCollector collector = this.newCollector();
        this.getDelegate().requestIndexData(collector.requestId, WorldDataSession.IndexType.FluidType);
        return this.waitForData(FluidTypeData.class, collector);
    }

    public TreeTypeIndex getTreeTypeIndex() {
        PacketCollector collector = this.newCollector();
        this.getDelegate().requestIndexData(collector.requestId, WorldDataSession.IndexType.TreeType);
        return this.waitForData(TreeTypeIndex.class, collector);
    }

    protected LeafData loadLeaf(LeafId leafId) {
        PacketCollector collector = this.newCollector();
        this.getDelegate().requestLeafData(collector.requestId, leafId.getId());
        return this.waitForData(LeafData.class, collector);
    }

    protected LightData loadLight(LeafId leafId) {
        PacketCollector collector = this.newCollector();
        this.getDelegate().requestLightData(collector.requestId, leafId.getId());
        return this.waitForData(LightData.class, collector);
    }

    protected FluidData loadFluid(LeafId leafId) {
        PacketCollector collector = this.newCollector();
        this.getDelegate().requestFluidData(collector.requestId, leafId.getId());
        return this.waitForData(FluidData.class, collector);
    }

    protected TerrainImage loadTerrainImage(TileId id, TerrainImageType type, Resolution res) {
        PacketCollector collector = this.newCollector();
        this.getDelegate().requestTerrainImage(collector.requestId, id.getId(), type, res);
        return this.waitForData(TerrainImage.class, collector);
    }

    protected TreeLayer loadTrees(TileId id, Resolution res) {
        PacketCollector collector = this.newCollector();
        this.getDelegate().requestTrees(collector.requestId, id.getId(), res);
        return this.waitForData(TreeLayer.class, collector);
    }

    protected PointCloudLayer loadPointCloudLayer(TileId id, Resolution res) {
        PacketCollector collector = this.newCollector();
        this.getDelegate().requestPointCloudLayer(collector.requestId, id.getId(), res);
        return this.waitForData(PointCloudLayer.class, collector);
    }

    private class PacketCollector {
        private long requestId;
        private byte[][] buffers;
        private int received;
        private int total;

        public PacketCollector(long requestId) {
            this.requestId = requestId;
        }

        private boolean isDone() {
            return this.total > 0 && this.received == this.total;
        }

        public synchronized byte[][] getData() {
            while (!this.isDone()) {
                try {
                    if (log.isTraceEnabled()) {
                        log.trace("waiting or:" + this.requestId);
                    }
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("We were interrupted and there isn't a damn thing we can do about it", e);
                }
            }
            return this.buffers;
        }

        public synchronized void packetReceived(int part, int total, byte[] data) {
            if (log.isTraceEnabled()) {
                log.trace("packeteCollector.dataReceived(" + part + ", " + total + ") requestId:" + this.requestId);
            }
            if (data != null) {
                if (this.buffers == null) {
                    this.buffers = new byte[total][];
                    this.total = total;
                }
                this.buffers[part] = data;
            } else {
                if (part != 0 && total != 1) {
                    throw new IllegalArgumentException("Null data for part:" + part + " of:" + total);
                }
                this.total = total;
            }
            this.received = part + 1;
            if (this.isDone()) {
                this.notifyAll();
            }
        }
    }
}

