/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.tile;

import com.google.common.base.MoreObjects;
import com.simsilica.mworld.DataVersion;
import com.simsilica.mworld.tile.TerrainImageId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerrainImage {
    static Logger log = LoggerFactory.getLogger(TerrainImage.class);
    private TerrainImageId id;
    private DataVersion version;
    private int size;
    private short[] elevations;
    private byte[] types;
    private byte[] lights;

    public TerrainImage(TerrainImageId id, DataVersion version) {
        this.id = id;
        this.version = version;
        this.size = id.getResolution().getSamples();
        this.elevations = new short[this.size * this.size];
        this.types = new byte[this.size * this.size];
        this.lights = new byte[this.size * this.size];
    }

    public TerrainImageId getId() {
        return this.id;
    }

    public DataVersion getVersion() {
        return this.version;
    }

    public int getSize() {
        return this.size;
    }

    private int index(int x, int y) {
        return this.size * y + x;
    }

    public final void setElevation(int x, int y, short elevation) {
        this.elevations[this.index((int)x, (int)y)] = elevation;
    }

    public final short getElevation(int x, int y) {
        return this.elevations[this.index(x, y)];
    }

    public final void setType(int x, int y, byte type) {
        this.types[this.index((int)x, (int)y)] = type;
    }

    public final byte getType(int x, int y) {
        return this.types[this.index(x, y)];
    }

    public final void setLight(int x, int y, byte light) {
        this.lights[this.index((int)x, (int)y)] = light;
    }

    public final byte getLight(int x, int y) {
        return this.lights[this.index(x, y)];
    }

    public final short[] getElevations() {
        return this.elevations;
    }

    public final byte[] getTypes() {
        return this.types;
    }

    public final byte[] getLights() {
        return this.lights;
    }

    public void write(TerrainImage image) {
        if (image.size < this.size) {
            throw new IllegalArgumentException("Cannot extrapolate image data from a lower resolution:" + (Object)((Object)image.getId().getResolution()));
        }
        int skip = image.size / this.size;
        int src = 0;
        int target = 0;
        short[] srcElevations = image.elevations;
        byte[] srcTypes = image.types;
        byte[] srcLights = image.lights;
        for (int i = 0; i < this.size; ++i) {
            src = i * skip * image.size;
            for (int j = 0; j < this.size; ++j) {
                this.elevations[target] = srcElevations[src];
                this.types[target] = srcTypes[src];
                this.lights[target] = srcLights[src];
                ++target;
                src += skip;
            }
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("id", (Object)this.getId()).add("version", (Object)this.getVersion()).add("size", this.size).toString();
    }
}

