/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.tile.insert;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.IntCombiner;
import com.simsilica.mblock.MaskUtils;
import com.simsilica.mworld.BlockData;
import com.simsilica.mworld.BlockDataId;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.TerrainImageType;
import com.simsilica.mworld.tile.TerrainTypeFunction;
import com.simsilica.mworld.tile.Tile;
import com.simsilica.mworld.tile.TileFunction;
import com.simsilica.mworld.tile.insert.BlockInsert;
import com.simsilica.mworld.tile.insert.InsertLayer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplyInsertsFunction
implements TileFunction {
    static Logger log = LoggerFactory.getLogger(ApplyInsertsFunction.class);
    private Function<BlockDataId, BlockData> blocksFunction;
    private TerrainTypeFunction typeFunction;
    private IntCombiner typeCombiner;

    public ApplyInsertsFunction(Function<BlockDataId, BlockData> blocksFunction, TerrainTypeFunction typeFunction, IntCombiner typeCombiner) {
        this.blocksFunction = blocksFunction;
        this.typeFunction = typeFunction;
        this.typeCombiner = typeCombiner;
    }

    @Override
    public void accept(Tile tile) {
        InsertLayer layer = tile.get(InsertLayer.class);
        log.info("accept(" + tile + ")  layer:" + layer);
        if (layer.getVersion().getLoadVersion() >= 0L) {
            return;
        }
        TerrainImage terrain = tile.get((Object)TerrainImageType.Terrain, TerrainImage.class);
        TerrainImage fluid = tile.get((Object)TerrainImageType.Fluid, TerrainImage.class);
        Vec3i origin = tile.getTileId().getWorld(null);
        boolean changed = false;
        for (BlockInsert insert : layer.getInserts()) {
            if (insert.groundLevel == 0) continue;
            BlockData blocks = this.blocksFunction.apply(insert.blockDataId);
            if (blocks == null) {
                log.warn("No BlockData found for:" + insert);
                continue;
            }
            int carveFlags = insert.carveFlags;
            boolean carveBelow = (carveFlags & 1) != 0;
            boolean carveInner = (carveFlags & 2) != 0;
            boolean carveAbove = (carveFlags & 4) != 0;
            boolean extendDown = (carveFlags & 8) != 0;
            boolean extendUp = (carveFlags & 0x10) != 0;
            int x = insert.world.x - origin.x;
            int y = insert.world.y;
            int z = insert.world.z - origin.z;
            int xSize = insert.xSize;
            byte ySize = insert.ySize;
            int zSize = insert.zSize;
            int xSource = 0;
            int zSource = 0;
            if (x < 0) {
                xSize += x;
                xSource -= x;
                x = 0;
            }
            if (z < 0) {
                zSize += z;
                zSource -= z;
                z = 0;
            }
            if (x + xSize > 1024) {
                xSize = 1024 - x;
            }
            if (z + zSize > 1024) {
                zSize = 1024 - z;
            }
            CellArray cells = blocks.getCells();
            CellArray fluidCells = blocks.getFluid();
            assert (ySize > 0);
            for (int i = 0; i < xSize; ++i) {
                for (int k = 0; k < zSize; ++k) {
                    int groundLevel = insert.groundLevel - 1;
                    int elevation = y + groundLevel + 1;
                    int terrainType = -1;
                    boolean empty = true;
                    for (int j = groundLevel; j >= 0; --j) {
                        int val = cells.getCell(xSource + i, j, zSource + k);
                        int type = MaskUtils.getType((int)val);
                        if (type != 0) {
                            empty = false;
                            int xform = this.typeFunction.apply(val, type);
                            if (xform >= 0) {
                                terrainType = xform;
                                break;
                            }
                        }
                        --elevation;
                    }
                    if (empty) continue;
                    int existingTerrainType = terrain.getType(x + i, z + k) & 0xFF;
                    short existingElevation = terrain.getElevation(x + i, z + k);
                    if ((terrainType = this.typeCombiner.apply(existingTerrainType, terrainType)) == -1) {
                        terrain.setElevation(x + i, z + k, (short)elevation);
                        continue;
                    }
                    if (terrainType == -2) {
                        if (existingElevation <= elevation || elevation > y + groundLevel) continue;
                        terrain.setElevation(x + i, z + k, (short)elevation);
                        continue;
                    }
                    terrain.setType(x + i, z + k, (byte)terrainType);
                    terrain.setElevation(x + i, z + k, (short)elevation);
                }
            }
        }
        if (changed) {
            if (!terrain.getVersion().isChanged()) {
                terrain.getVersion().markChanged();
            }
            if (!fluid.getVersion().isChanged()) {
                fluid.getVersion().markChanged();
            }
        }
    }
}

