/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.tile.morph;

import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.TerrainImageType;
import com.simsilica.mworld.tile.Tile;
import com.simsilica.mworld.tile.TileFunction;
import com.simsilica.mworld.tile.morph.MorphologyLayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplyMorphologyFunction
implements TileFunction {
    static Logger log = LoggerFactory.getLogger(ApplyMorphologyFunction.class);

    @Override
    public void accept(Tile tile) {
        MorphologyLayer layer = tile.get(MorphologyLayer.class);
        if (layer.getVersion().getLoadVersion() >= 0L) {
            return;
        }
        if (layer.apply(tile)) {
            TerrainImage fluid;
            TerrainImage terrain = tile.get((Object)TerrainImageType.Terrain, TerrainImage.class);
            if (!terrain.getVersion().isChanged()) {
                terrain.getVersion().markChanged();
            }
            if (!(fluid = tile.get((Object)TerrainImageType.Fluid, TerrainImage.class)).getVersion().isChanged()) {
                fluid.getVersion().markChanged();
            }
        }
    }
}

