/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.tile.pc;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.DataVersion;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.db.SpoolingObjectDb;
import com.simsilica.mworld.tile.Resolution;
import com.simsilica.mworld.tile.pc.PointCloudLayer;
import com.simsilica.mworld.tile.pc.PointCloudLayerProtocol;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PointCloudDb
extends SpoolingObjectDb<TileId, PointCloudLayer> {
    static Logger log = LoggerFactory.getLogger(PointCloudDb.class);
    private File root;
    private PointCloudLayerProtocol protocol = new PointCloudLayerProtocol();

    public PointCloudDb(File root) {
        this.root = root;
    }

    protected File toFile(TileId id) {
        Vec3i sedectile = id.getSedectileId().getCell(null);
        String path = sedectile.x + "/" + sedectile.z;
        File dir = new File(this.root, path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String name = id.getId() + ".pc";
        return new File(dir, name);
    }

    @Override
    protected PointCloudLayer loadObject(TileId id) {
        log.info("loadObject(" + id + ")");
        File file = this.toFile(id);
        if (file.exists()) {
            return this.readObjectFile(id, file);
        }
        return new PointCloudLayer(id, new DataVersion(0L, -1L), Resolution.High);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected PointCloudLayer readObjectFile(TileId id, File file) {
        try (BufferedInputStream in = new BufferedInputStream(new GZIPInputStream(new FileInputStream(file)));){
            PointCloudLayer result = this.protocol.read(in);
            assert (id.equals(result.getTileId()));
            PointCloudLayer pointCloudLayer = result;
            return pointCloudLayer;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading object:" + id + " from:" + file, e);
        }
    }

    @Override
    protected void storeObject(TileId id, PointCloudLayer value) {
        File file = this.toFile(id);
        this.writeObjectFile(id, file, value);
        value.getVersion().resetChanged(System.currentTimeMillis());
    }

    protected void writeObjectFile(TileId id, File file, PointCloudLayer value) {
        long start = System.nanoTime();
        try (BufferedOutputStream out = new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(file)));){
            this.protocol.write(value, out);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing object:" + id + " to:" + file, e);
        }
        long end = System.nanoTime();
        log.info("Wrote [" + id + "] in " + (double)(end - start) / 1000000.0 + " ms");
    }
}

