/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.tile.tree;

import com.simsilica.ethereal.io.BitInputStream;
import com.simsilica.ethereal.io.BitOutputStream;
import com.simsilica.mworld.DataVersion;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.io.ObjectProtocol;
import com.simsilica.mworld.tile.tree.Tree;
import com.simsilica.mworld.tile.tree.TreeLayer;
import com.simsilica.mworld.tile.tree.TreeType;
import com.simsilica.mworld.tile.tree.TreeTypeIndex;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeLayerProtocol
implements ObjectProtocol<TreeLayer> {
    static Logger log = LoggerFactory.getLogger(TreeLayerProtocol.class);
    private static final int XZ_BITS = 10;
    private static final int ELEVATION_BITS = 10;
    private static final int HEIGHT_BITS = 6;
    private static final int RADIUS_BITS = 4;
    private static final int OTHER_BITS = 6;
    private int version = 42;
    private TreeTypeIndex treeTypeIndex;
    private int baseTypeBits;

    public TreeLayerProtocol() {
        this(TreeTypeIndex.getInstance());
    }

    public TreeLayerProtocol(TreeTypeIndex treeTypeIndex) {
        this.treeTypeIndex = treeTypeIndex;
        if (treeTypeIndex.isInitialized()) {
            this.baseTypeBits = 32 - Integer.numberOfLeadingZeros(treeTypeIndex.size());
            log.info("baseTypeBits:" + this.baseTypeBits + "  index size:" + treeTypeIndex.size());
        }
    }

    @Override
    public int getProtocolVersion() {
        return this.version;
    }

    private void checkBaseBits() {
        if (this.baseTypeBits == 0) {
            log.warn("baseTypeBits is 0, checking index initialized state...");
            if (!this.treeTypeIndex.isInitialized()) {
                throw new IllegalStateException("Tree type index has not been initialized, cannot write tree layers");
            }
            this.baseTypeBits = 32 - Integer.numberOfLeadingZeros(this.treeTypeIndex.size());
            log.info("baseTypeBits:" + this.baseTypeBits + "  index size:" + this.treeTypeIndex.size());
        }
    }

    @Override
    public void write(TreeLayer data, BitOutputStream out) throws IOException {
        this.checkBaseBits();
        out.writeBits(this.version, 16);
        TileId tileId = data.getTileId();
        long id = tileId.getId();
        out.writeLongBits(id, 64);
        out.writeLongBits(data.getVersion().getVersion(), 64);
        out.writeBits(this.baseTypeBits, 8);
        int size = data.getTrees().size();
        out.writeBits(size, 32);
        for (Tree tree : data.getTrees()) {
            out.writeBits((int)tree.x, 10);
            out.writeBits((int)tree.y, 10);
            out.writeBits((int)tree.z, 10);
            out.writeBits(tree.height - 1, 6);
            out.writeBits(tree.radius - 1, 4);
            out.writeBits((int)tree.other, 6);
            out.writeBits((int)tree.type.getIndex(), this.baseTypeBits);
        }
    }

    @Override
    public TreeLayer read(BitInputStream in) throws IOException {
        int version = in.readBits(16);
        TileId tileId = new TileId(in.readLongBits(64));
        long dataVersion = in.readLongBits(64);
        int typeBits = in.readBits(8);
        int size = in.readBits(32);
        ArrayList<Tree> trees = new ArrayList<Tree>(size);
        for (int i = 0; i < size; ++i) {
            int x = in.readBits(10);
            int y = in.readBits(10);
            int z = in.readBits(10);
            int height = in.readBits(6) + 1;
            int radius = in.readBits(4) + 1;
            int other = in.readBits(6);
            int typeIndex = in.readBits(typeBits);
            TreeType type = this.treeTypeIndex.getType(typeIndex);
            Tree tree = new Tree((short)x, (short)y, (short)z, (byte)height, (byte)radius, type);
            trees.add(tree);
        }
        return new TreeLayer(tileId, new DataVersion(dataVersion), trees);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(TreeLayer trees, OutputStream rawOut) throws IOException {
        try (BitOutputStream out = new BitOutputStream(rawOut);){
            this.write(trees, out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeLayer read(InputStream rawIn) throws IOException {
        try (BitInputStream in = new BitInputStream(rawIn);){
            TreeLayer treeLayer = this.read(in);
            return treeLayer;
        }
    }
}

