/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.transaction;

import com.simsilica.mworld.CellChangeEvent;
import com.simsilica.mworld.ColumnData;
import com.simsilica.mworld.DataType;
import com.simsilica.mworld.LeafId;
import com.simsilica.mworld.transaction.LeafTransaction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldTransaction {
    static Logger log = LoggerFactory.getLogger(WorldTransaction.class);
    private Map<LeafId, LeafTransaction> leafIndex = new HashMap<LeafId, LeafTransaction>();
    private Set<ColumnData> modifiedColumns = new HashSet<ColumnData>();

    public Set<ColumnData> getModifiedColumns() {
        return this.modifiedColumns;
    }

    public Set<LeafId> getModifiedLeafIds() {
        return this.leafIndex.keySet();
    }

    public List<CellChangeEvent> createCellChangeEvents() {
        ArrayList<CellChangeEvent> result = new ArrayList<CellChangeEvent>();
        for (LeafTransaction trans : this.leafIndex.values()) {
            result.add(trans.createCellChangeEvent());
        }
        return result;
    }

    public ColumnData getColumnData(LeafId leafId) {
        long searchId = leafId.getColumnId().getId();
        for (ColumnData col : this.modifiedColumns) {
            if (col.getColumnId().getId() != searchId) continue;
            return col;
        }
        return null;
    }

    protected final LeafTransaction getLeafTrans(LeafId leafId, boolean create) {
        LeafTransaction result = this.leafIndex.get(leafId);
        if (result == null && create) {
            result = new LeafTransaction(leafId);
            this.leafIndex.put(leafId, result);
        }
        return result;
    }

    public void cellChanged(ColumnData col, LeafId leafId, DataType type, int i, int j, int k, int value) {
        this.modifiedColumns.add(col);
        if (log.isTraceEnabled()) {
            log.trace("cellChanged(" + leafId + ", " + (Object)((Object)type) + ", " + i + ", " + j + ", " + k + ", " + Integer.toHexString(value) + ")");
        }
        this.getLeafTrans(leafId, true).cellChanged(type, i, j, k, value);
    }
}

