/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.export.xml;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeImporter;
import com.jme3.export.Savable;
import com.jme3.export.SavableClassUtil;
import com.jme3.export.xml.XMLImporter;
import com.jme3.util.BufferUtils;
import com.jme3.util.IntMap;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMInputCapsule
implements InputCapsule {
    private static final Logger logger = Logger.getLogger(DOMInputCapsule.class.getName());
    private Document doc;
    private Element currentElem;
    private XMLImporter importer;
    private boolean isAtRoot = true;
    private Map<String, Savable> referencedSavables = new HashMap<String, Savable>();
    private int[] classHierarchyVersions;
    private Savable savable;
    private static final String[] zeroStrings = new String[0];

    public DOMInputCapsule(Document doc, XMLImporter importer) {
        this.doc = doc;
        this.importer = importer;
        this.currentElem = doc.getDocumentElement();
        String version = this.currentElem.getAttribute("format_version");
        importer.formatVersion = version.equals("") ? 0 : Integer.parseInt(version);
    }

    public int getSavableVersion(Class<? extends Savable> desiredClass) {
        if (this.classHierarchyVersions != null) {
            return SavableClassUtil.getSavedSavableVersion((Object)this.savable, desiredClass, (int[])this.classHierarchyVersions, (int)this.importer.getFormatVersion());
        }
        return 0;
    }

    private static String decodeString(String s) {
        if (s == null) {
            return null;
        }
        s = s.replaceAll("\\&quot;", "\"").replaceAll("\\&lt;", "<").replaceAll("\\&amp;", "&");
        return s;
    }

    private Element findFirstChildElement(Element parent) {
        Node ret;
        for (ret = parent.getFirstChild(); ret != null && !(ret instanceof Element); ret = ret.getNextSibling()) {
        }
        return (Element)ret;
    }

    private Element findChildElement(Element parent, String name) {
        Node ret;
        if (parent == null) {
            return null;
        }
        for (ret = parent.getFirstChild(); !(ret == null || ret instanceof Element && ret.getNodeName().equals(name)); ret = ret.getNextSibling()) {
        }
        return (Element)ret;
    }

    private Element findNextSiblingElement(Element current) {
        for (Node ret = current.getNextSibling(); ret != null; ret = ret.getNextSibling()) {
            if (!(ret instanceof Element)) continue;
            return (Element)ret;
        }
        return null;
    }

    public byte readByte(String name, byte defVal) throws IOException {
        String tmpString = this.currentElem.getAttribute(name);
        if (tmpString == null || tmpString.length() < 1) {
            return defVal;
        }
        try {
            return Byte.parseByte(tmpString);
        }
        catch (NumberFormatException | DOMException nfe) {
            IOException io = new IOException(nfe.toString());
            io.initCause(nfe);
            throw io;
        }
    }

    public byte[] readByteArray(String name, byte[] defVal) throws IOException {
        try {
            int requiredSize;
            Element tmpEl = name != null ? this.findChildElement(this.currentElem, name) : this.currentElem;
            if (tmpEl == null) {
                return defVal;
            }
            String sizeString = tmpEl.getAttribute("size");
            String[] strings = this.parseTokens(tmpEl.getAttribute("data"));
            if (sizeString.length() > 0 && strings.length != (requiredSize = Integer.parseInt(sizeString))) {
                throw new IOException("Wrong number of bytes for '" + name + "'.  size says " + requiredSize + ", data contains " + strings.length);
            }
            byte[] tmp = new byte[strings.length];
            for (int i = 0; i < strings.length; ++i) {
                tmp[i] = Byte.parseByte(strings[i]);
            }
            return tmp;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (NumberFormatException | DOMException nfe) {
            IOException io = new IOException(nfe.toString());
            io.initCause(nfe);
            throw io;
        }
    }

    public byte[][] readByteArray2D(String name, byte[][] defVal) throws IOException {
        try {
            Element tmpEl = name != null ? this.findChildElement(this.currentElem, name) : this.currentElem;
            if (tmpEl == null) {
                return defVal;
            }
            String sizeString = tmpEl.getAttribute("size");
            NodeList nodes = this.currentElem.getChildNodes();
            ArrayList<byte[]> byteArrays = new ArrayList<byte[]>();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node n = nodes.item(i);
                if (!(n instanceof Element) || !n.getNodeName().contains("array")) continue;
                byteArrays.add(this.readByteArray(n.getNodeName(), null));
            }
            if (sizeString.length() > 0) {
                int requiredSize = Integer.parseInt(sizeString);
                if (byteArrays.size() != requiredSize) {
                    throw new IOException("String array contains wrong element count.  Specified size " + requiredSize + ", data contains " + byteArrays.size());
                }
            }
            this.currentElem = (Element)this.currentElem.getParentNode();
            return (byte[][])byteArrays.toArray((T[])new byte[0][]);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (NumberFormatException | DOMException nfe) {
            IOException io = new IOException(nfe.toString());
            io.initCause(nfe);
            throw io;
        }
    }

    public int readInt(String name, int defVal) throws IOException {
        String tmpString = this.currentElem.getAttribute(name);
        if (tmpString == null || tmpString.length() < 1) {
            return defVal;
        }
        try {
            return Integer.parseInt(tmpString);
        }
        catch (NumberFormatException | DOMException nfe) {
            IOException io = new IOException(nfe.toString());
            io.initCause(nfe);
            throw io;
        }
    }

    public int[] readIntArray(String name, int[] defVal) throws IOException {
        try {
            int requiredSize;
            Element tmpEl = name != null ? this.findChildElement(this.currentElem, name) : this.currentElem;
            if (tmpEl == null) {
                return defVal;
            }
            String sizeString = tmpEl.getAttribute("size");
            String[] strings = this.parseTokens(tmpEl.getAttribute("data"));
            if (sizeString.length() > 0 && strings.length != (requiredSize = Integer.parseInt(sizeString))) {
                throw new IOException("Wrong number of ints for '" + name + "'.  size says " + requiredSize + ", data contains " + strings.length);
            }
            int[] tmp = new int[strings.length];
            for (int i = 0; i < tmp.length; ++i) {
                tmp[i] = Integer.parseInt(strings[i]);
            }
            return tmp;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (NumberFormatException | DOMException nfe) {
            IOException io = new IOException(nfe.toString());
            io.initCause(nfe);
            throw io;
        }
    }

    public int[][] readIntArray2D(String name, int[][] defVal) throws IOException {
        try {
            Element tmpEl = name != null ? this.findChildElement(this.currentElem, name) : this.currentElem;
            if (tmpEl == null) {
                return defVal;
            }
            String sizeString = tmpEl.getAttribute("size");
            NodeList nodes = this.currentElem.getChildNodes();
            ArrayList<int[]> intArrays = new ArrayList<int[]>();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node n = nodes.item(i);
                if (!(n instanceof Element) || !n.getNodeName().contains("array")) continue;
                intArrays.add(this.readIntArray(n.getNodeName(), null));
            }
            if (sizeString.length() > 0) {
                int requiredSize = Integer.parseInt(sizeString);
                if (intArrays.size() != requiredSize) {
                    throw new IOException("String array contains wrong element count.  Specified size " + requiredSize + ", data contains " + intArrays.size());
                }
            }
            this.currentElem = (Element)this.currentElem.getParentNode();
            return (int[][])intArrays.toArray((T[])new int[0][]);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (NumberFormatException | DOMException nfe) {
            IOException io = new IOException(nfe.toString());
            io.initCause(nfe);
            throw io;
        }
    }

    public float readFloat(String name, float defVal) throws IOException {
        String tmpString = this.currentElem.getAttribute(name);
        if (tmpString == null || tmpString.length() < 1) {
            return defVal;
        }
        try {
            return Float.parseFloat(tmpString);
        }
        catch (NumberFormatException | DOMException nfe) {
            IOException io = new IOException(nfe.toString());
            io.initCause(nfe);
            throw io;
        }
    }

    public float[] readFloatArray(String name, float[] defVal) throws IOException {
        try {
            int requiredSize;
            Element tmpEl = name != null ? this.findChildElement(this.currentElem, name) : this.currentElem;
            if (tmpEl == null) {
                return defVal;
            }
            String sizeString = tmpEl.getAttribute("size");
            String[] strings = this.parseTokens(tmpEl.getAttribute("data"));
            if (sizeString.length() > 0 && strings.length != (requiredSize = Integer.parseInt(sizeString))) {
                throw new IOException("Wrong number of floats for '" + name + "'.  size says " + requiredSize + ", data contains " + strings.length);
            }
            float[] tmp = new float[strings.length];
            for (int i = 0; i < tmp.length; ++i) {
                tmp[i] = Float.parseFloat(strings[i]);
            }
            return tmp;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (DOMException de) {
            IOException io = new IOException(de.toString());
            io.initCause(de);
            throw io;
        }
    }

    public float[][] readFloatArray2D(String name, float[][] defVal) throws IOException {
        try {
            Element tmpEl = name != null ? this.findChildElement(this.currentElem, name) : this.currentElem;
            if (tmpEl == null) {
                return defVal;
            }
            int size_outer = Integer.parseInt(tmpEl.getAttribute("size_outer"));
            int size_inner = Integer.parseInt(tmpEl.getAttribute("size_outer"));
            float[][] tmp = new float[size_outer][size_inner];
            String[] strings = this.parseTokens(tmpEl.getAttribute("data"));
            for (int i = 0; i < size_outer; ++i) {
                tmp[i] = new float[size_inner];
                for (int k = 0; k < size_inner; ++k) {
                    tmp[i][k] = Float.parseFloat(strings[i]);
                }
            }
            return tmp;
        }
        catch (NumberFormatException | DOMException nfe) {
            IOException io = new IOException(nfe.toString());
            io.initCause(nfe);
            throw io;
        }
    }

    public double readDouble(String name, double defVal) throws IOException {
        String tmpString = this.currentElem.getAttribute(name);
        if (tmpString == null || tmpString.length() < 1) {
            return defVal;
        }
        try {
            return Double.parseDouble(tmpString);
        }
        catch (NumberFormatException | DOMException nfe) {
            IOException io = new IOException(nfe.toString());
            io.initCause(nfe);
            throw io;
        }
    }

    public double[] readDoubleArray(String name, double[] defVal) throws IOException {
        try {
            int requiredSize;
            Element tmpEl = name != null ? this.findChildElement(this.currentElem, name) : this.currentElem;
            if (tmpEl == null) {
                return defVal;
            }
            String sizeString = tmpEl.getAttribute("size");
            String[] strings = this.parseTokens(tmpEl.getAttribute("data"));
            if (sizeString.length() > 0 && strings.length != (requiredSize = Integer.parseInt(sizeString))) {
                throw new IOException("Wrong number of doubles for '" + name + "'.  size says " + requiredSize + ", data contains " + strings.length);
            }
            double[] tmp = new double[strings.length];
            for (int i = 0; i < tmp.length; ++i) {
                tmp[i] = Double.parseDouble(strings[i]);
            }
            return tmp;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (NumberFormatException | DOMException nfe) {
            IOException io = new IOException(nfe.toString());
            io.initCause(nfe);
            throw io;
        }
    }

    public double[][] readDoubleArray2D(String name, double[][] defVal) throws IOException {
        try {
            Element tmpEl = name != null ? this.findChildElement(this.currentElem, name) : this.currentElem;
            if (tmpEl == null) {
                return defVal;
            }
            String sizeString = tmpEl.getAttribute("size");
            NodeList nodes = this.currentElem.getChildNodes();
            ArrayList<double[]> doubleArrays = new ArrayList<double[]>();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node n = nodes.item(i);
                if (!(n instanceof Element) || !n.getNodeName().contains("array")) continue;
                doubleArrays.add(this.readDoubleArray(n.getNodeName(), null));
            }
            if (sizeString.length() > 0) {
                int requiredSize = Integer.parseInt(sizeString);
                if (doubleArrays.size() != requiredSize) {
                    throw new IOException("String array contains wrong element count.  Specified size " + requiredSize + ", data contains " + doubleArrays.size());
                }
            }
            this.currentElem = (Element)this.currentElem.getParentNode();
            return (double[][])doubleArrays.toArray((T[])new double[0][]);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (NumberFormatException | DOMException nfe) {
            IOException io = new IOException(nfe.toString());
            io.initCause(nfe);
            throw io;
        }
    }

    public long readLong(String name, long defVal) throws IOException {
        String tmpString = this.currentElem.getAttribute(name);
        if (tmpString == null || tmpString.length() < 1) {
            return defVal;
        }
        try {
            return Long.parseLong(tmpString);
        }
        catch (NumberFormatException | DOMException nfe) {
            IOException io = new IOException(nfe.toString());
            io.initCause(nfe);
            throw io;
        }
    }

    public long[] readLongArray(String name, long[] defVal) throws IOException {
        try {
            int requiredSize;
            Element tmpEl = name != null ? this.findChildElement(this.currentElem, name) : this.currentElem;
            if (tmpEl == null) {
                return defVal;
            }
            String sizeString = tmpEl.getAttribute("size");
            String[] strings = this.parseTokens(tmpEl.getAttribute("data"));
            if (sizeString.length() > 0 && strings.length != (requiredSize = Integer.parseInt(sizeString))) {
                throw new IOException("Wrong number of longs for '" + name + "'.  size says " + requiredSize + ", data contains " + strings.length);
            }
            long[] tmp = new long[strings.length];
            for (int i = 0; i < tmp.length; ++i) {
                tmp[i] = Long.parseLong(strings[i]);
            }
            return tmp;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (NumberFormatException | DOMException nfe) {
            IOException io = new IOException(nfe.toString());
            io.initCause(nfe);
            throw io;
        }
    }

    public long[][] readLongArray2D(String name, long[][] defVal) throws IOException {
        try {
            Element tmpEl = name != null ? this.findChildElement(this.currentElem, name) : this.currentElem;
            if (tmpEl == null) {
                return defVal;
            }
            String sizeString = tmpEl.getAttribute("size");
            NodeList nodes = this.currentElem.getChildNodes();
            ArrayList<long[]> longArrays = new ArrayList<long[]>();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node n = nodes.item(i);
                if (!(n instanceof Element) || !n.getNodeName().contains("array")) continue;
                longArrays.add(this.readLongArray(n.getNodeName(), null));
            }
            if (sizeString.length() > 0) {
                int requiredSize = Integer.parseInt(sizeString);
                if (longArrays.size() != requiredSize) {
                    throw new IOException("String array contains wrong element count.  Specified size " + requiredSize + ", data contains " + longArrays.size());
                }
            }
            this.currentElem = (Element)this.currentElem.getParentNode();
            return (long[][])longArrays.toArray((T[])new long[0][]);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (NumberFormatException | DOMException nfe) {
            IOException io = new IOException(nfe.toString());
            io.initCause(nfe);
            throw io;
        }
    }

    public short readShort(String name, short defVal) throws IOException {
        String tmpString = this.currentElem.getAttribute(name);
        if (tmpString == null || tmpString.length() < 1) {
            return defVal;
        }
        try {
            return Short.parseShort(tmpString);
        }
        catch (NumberFormatException | DOMException nfe) {
            IOException io = new IOException(nfe.toString());
            io.initCause(nfe);
            throw io;
        }
    }

    public short[] readShortArray(String name, short[] defVal) throws IOException {
        try {
            int requiredSize;
            Element tmpEl = name != null ? this.findChildElement(this.currentElem, name) : this.currentElem;
            if (tmpEl == null) {
                return defVal;
            }
            String sizeString = tmpEl.getAttribute("size");
            String[] strings = this.parseTokens(tmpEl.getAttribute("data"));
            if (sizeString.length() > 0 && strings.length != (requiredSize = Integer.parseInt(sizeString))) {
                throw new IOException("Wrong number of shorts for '" + name + "'.  size says " + requiredSize + ", data contains " + strings.length);
            }
            short[] tmp = new short[strings.length];
            for (int i = 0; i < tmp.length; ++i) {
                tmp[i] = Short.parseShort(strings[i]);
            }
            return tmp;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (NumberFormatException | DOMException nfe) {
            IOException io = new IOException(nfe.toString());
            io.initCause(nfe);
            throw io;
        }
    }

    public short[][] readShortArray2D(String name, short[][] defVal) throws IOException {
        try {
            Element tmpEl = name != null ? this.findChildElement(this.currentElem, name) : this.currentElem;
            if (tmpEl == null) {
                return defVal;
            }
            String sizeString = tmpEl.getAttribute("size");
            NodeList nodes = this.currentElem.getChildNodes();
            ArrayList<short[]> shortArrays = new ArrayList<short[]>();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node n = nodes.item(i);
                if (!(n instanceof Element) || !n.getNodeName().contains("array")) continue;
                shortArrays.add(this.readShortArray(n.getNodeName(), null));
            }
            if (sizeString.length() > 0) {
                int requiredSize = Integer.parseInt(sizeString);
                if (shortArrays.size() != requiredSize) {
                    throw new IOException("String array contains wrong element count.  Specified size " + requiredSize + ", data contains " + shortArrays.size());
                }
            }
            this.currentElem = (Element)this.currentElem.getParentNode();
            return (short[][])shortArrays.toArray((T[])new short[0][]);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (NumberFormatException | DOMException nfe) {
            IOException io = new IOException(nfe.toString());
            io.initCause(nfe);
            throw io;
        }
    }

    public boolean readBoolean(String name, boolean defVal) throws IOException {
        String tmpString = this.currentElem.getAttribute(name);
        if (tmpString == null || tmpString.length() < 1) {
            return defVal;
        }
        try {
            return Boolean.parseBoolean(tmpString);
        }
        catch (DOMException de) {
            IOException io = new IOException(de.toString());
            io.initCause(de);
            throw io;
        }
    }

    public boolean[] readBooleanArray(String name, boolean[] defVal) throws IOException {
        try {
            int requiredSize;
            Element tmpEl = name != null ? this.findChildElement(this.currentElem, name) : this.currentElem;
            if (tmpEl == null) {
                return defVal;
            }
            String sizeString = tmpEl.getAttribute("size");
            String[] strings = this.parseTokens(tmpEl.getAttribute("data"));
            if (sizeString.length() > 0 && strings.length != (requiredSize = Integer.parseInt(sizeString))) {
                throw new IOException("Wrong number of bools for '" + name + "'.  size says " + requiredSize + ", data contains " + strings.length);
            }
            boolean[] tmp = new boolean[strings.length];
            for (int i = 0; i < tmp.length; ++i) {
                tmp[i] = Boolean.parseBoolean(strings[i]);
            }
            return tmp;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (DOMException de) {
            IOException io = new IOException(de.toString());
            io.initCause(de);
            throw io;
        }
    }

    public boolean[][] readBooleanArray2D(String name, boolean[][] defVal) throws IOException {
        try {
            Element tmpEl = name != null ? this.findChildElement(this.currentElem, name) : this.currentElem;
            if (tmpEl == null) {
                return defVal;
            }
            String sizeString = tmpEl.getAttribute("size");
            NodeList nodes = this.currentElem.getChildNodes();
            ArrayList<boolean[]> booleanArrays = new ArrayList<boolean[]>();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node n = nodes.item(i);
                if (!(n instanceof Element) || !n.getNodeName().contains("array")) continue;
                booleanArrays.add(this.readBooleanArray(n.getNodeName(), null));
            }
            if (sizeString.length() > 0) {
                int requiredSize = Integer.parseInt(sizeString);
                if (booleanArrays.size() != requiredSize) {
                    throw new IOException("String array contains wrong element count.  Specified size " + requiredSize + ", data contains " + booleanArrays.size());
                }
            }
            this.currentElem = (Element)this.currentElem.getParentNode();
            return (boolean[][])booleanArrays.toArray((T[])new boolean[0][]);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (NumberFormatException | DOMException nfe) {
            IOException io = new IOException(nfe.toString());
            io.initCause(nfe);
            throw io;
        }
    }

    public String readString(String name, String defVal) throws IOException {
        String tmpString = this.currentElem.getAttribute(name);
        if (tmpString == null || tmpString.length() < 1) {
            return defVal;
        }
        try {
            return DOMInputCapsule.decodeString(tmpString);
        }
        catch (DOMException de) {
            IOException io = new IOException(de.toString());
            io.initCause(de);
            throw io;
        }
    }

    public String[] readStringArray(String name, String[] defVal) throws IOException {
        try {
            Element tmpEl = name != null ? this.findChildElement(this.currentElem, name) : this.currentElem;
            if (tmpEl == null) {
                return defVal;
            }
            String sizeString = tmpEl.getAttribute("size");
            NodeList nodes = tmpEl.getChildNodes();
            ArrayList<String> strings = new ArrayList<String>();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node n = nodes.item(i);
                if (!(n instanceof Element) || !n.getNodeName().contains("String")) continue;
                strings.add(((Element)n).getAttributeNode("value").getValue());
            }
            if (sizeString.length() > 0) {
                int requiredSize = Integer.parseInt(sizeString);
                if (strings.size() != requiredSize) {
                    throw new IOException("String array contains wrong element count.  Specified size " + requiredSize + ", data contains " + strings.size());
                }
            }
            return strings.toArray(new String[0]);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (NumberFormatException | DOMException nfe) {
            IOException io = new IOException(nfe.toString());
            io.initCause(nfe);
            throw io;
        }
    }

    public String[][] readStringArray2D(String name, String[][] defVal) throws IOException {
        try {
            Element tmpEl = name != null ? this.findChildElement(this.currentElem, name) : this.currentElem;
            if (tmpEl == null) {
                return defVal;
            }
            String sizeString = tmpEl.getAttribute("size");
            NodeList nodes = this.currentElem.getChildNodes();
            ArrayList<String[]> stringArrays = new ArrayList<String[]>();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node n = nodes.item(i);
                if (!(n instanceof Element) || !n.getNodeName().contains("array")) continue;
                stringArrays.add(this.readStringArray(n.getNodeName(), null));
            }
            if (sizeString.length() > 0) {
                int requiredSize = Integer.parseInt(sizeString);
                if (stringArrays.size() != requiredSize) {
                    throw new IOException("String array contains wrong element count.  Specified size " + requiredSize + ", data contains " + stringArrays.size());
                }
            }
            this.currentElem = (Element)this.currentElem.getParentNode();
            return (String[][])stringArrays.toArray((T[])new String[0][]);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (NumberFormatException | DOMException nfe) {
            IOException io = new IOException(nfe.toString());
            io.initCause(nfe);
            throw io;
        }
    }

    public BitSet readBitSet(String name, BitSet defVal) throws IOException {
        String tmpString = this.currentElem.getAttribute(name);
        if (tmpString == null || tmpString.length() < 1) {
            return defVal;
        }
        try {
            BitSet set = new BitSet();
            String[] strings = this.parseTokens(tmpString);
            for (int i = 0; i < strings.length; ++i) {
                int isSet = Integer.parseInt(strings[i]);
                if (isSet != 1) continue;
                set.set(i);
            }
            return set;
        }
        catch (NumberFormatException | DOMException nfe) {
            IOException io = new IOException(nfe.toString());
            io.initCause(nfe);
            throw io;
        }
    }

    public Savable readSavable(String name, Savable defVal) throws IOException {
        Savable ret = defVal;
        if (name != null && name.equals("")) {
            logger.warning("Reading Savable String with name \"\"?");
        }
        try {
            Element tmpEl = null;
            if (name != null) {
                tmpEl = this.findChildElement(this.currentElem, name);
                if (tmpEl == null) {
                    return defVal;
                }
            } else if (this.isAtRoot) {
                tmpEl = this.doc.getDocumentElement();
                this.isAtRoot = false;
            } else {
                tmpEl = this.findFirstChildElement(this.currentElem);
            }
            this.currentElem = tmpEl;
            ret = this.readSavableFromCurrentElem(defVal);
            this.currentElem = this.currentElem.getParentNode() instanceof Element ? (Element)this.currentElem.getParentNode() : null;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            IOException io = new IOException(e.toString());
            io.initCause(e);
            throw io;
        }
        return ret;
    }

    private Savable readSavableFromCurrentElem(Savable defVal) throws InstantiationException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IOException, IllegalAccessException {
        Savable ret = defVal;
        Savable tmp = null;
        if (this.currentElem == null || this.currentElem.getNodeName().equals("null")) {
            return null;
        }
        String reference = this.currentElem.getAttribute("ref");
        if (reference.length() > 0) {
            ret = this.referencedSavables.get(reference);
        } else {
            String refID;
            String className = this.currentElem.getNodeName();
            if (this.currentElem.hasAttribute("class")) {
                className = this.currentElem.getAttribute("class");
            } else if (defVal != null) {
                className = defVal.getClass().getName();
            }
            tmp = SavableClassUtil.fromName((String)className, null);
            String versionsStr = this.currentElem.getAttribute("savable_versions");
            if (versionsStr != null && !versionsStr.equals("")) {
                String[] versionStr = versionsStr.split(",");
                this.classHierarchyVersions = new int[versionStr.length];
                for (int i = 0; i < this.classHierarchyVersions.length; ++i) {
                    this.classHierarchyVersions[i] = Integer.parseInt(versionStr[i].trim());
                }
            } else {
                this.classHierarchyVersions = null;
            }
            if ((refID = this.currentElem.getAttribute("reference_ID")).length() < 1) {
                refID = this.currentElem.getAttribute("id");
            }
            if (refID.length() > 0) {
                this.referencedSavables.put(refID, tmp);
            }
            if (tmp != null) {
                this.savable = tmp;
                tmp.read((JmeImporter)this.importer);
                ret = tmp;
            }
        }
        return ret;
    }

    public Savable[] readSavableArray(String name, Savable[] defVal) throws IOException {
        Savable[] ret = defVal;
        try {
            Element tmpEl = this.findChildElement(this.currentElem, name);
            if (tmpEl == null) {
                return defVal;
            }
            String sizeString = tmpEl.getAttribute("size");
            ArrayList<Savable> savables = new ArrayList<Savable>();
            this.currentElem = this.findFirstChildElement(tmpEl);
            while (this.currentElem != null) {
                savables.add(this.readSavableFromCurrentElem(null));
                this.currentElem = this.findNextSiblingElement(this.currentElem);
            }
            if (sizeString.length() > 0) {
                int requiredSize = Integer.parseInt(sizeString);
                if (savables.size() != requiredSize) {
                    throw new IOException("Wrong number of Savables for '" + name + "'.  size says " + requiredSize + ", data contains " + savables.size());
                }
            }
            ret = savables.toArray(new Savable[0]);
            this.currentElem = (Element)tmpEl.getParentNode();
            return ret;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            IOException io = new IOException(e.toString());
            io.initCause(e);
            throw io;
        }
    }

    public Savable[][] readSavableArray2D(String name, Savable[][] defVal) throws IOException {
        Savable[][] ret = defVal;
        try {
            Element tmpEl = this.findChildElement(this.currentElem, name);
            if (tmpEl == null) {
                return defVal;
            }
            int size_outer = Integer.parseInt(tmpEl.getAttribute("size_outer"));
            int size_inner = Integer.parseInt(tmpEl.getAttribute("size_outer"));
            Savable[][] tmp = new Savable[size_outer][size_inner];
            this.currentElem = this.findFirstChildElement(tmpEl);
            block3: for (int i = 0; i < size_outer; ++i) {
                for (int j = 0; j < size_inner; ++j) {
                    tmp[i][j] = this.readSavableFromCurrentElem(null);
                    if (i == size_outer - 1 && j == size_inner - 1) continue block3;
                    this.currentElem = this.findNextSiblingElement(this.currentElem);
                }
            }
            ret = tmp;
            this.currentElem = (Element)tmpEl.getParentNode();
            return ret;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            IOException io = new IOException(e.toString());
            io.initCause(e);
            throw io;
        }
    }

    public ArrayList<Savable> readSavableArrayList(String name, ArrayList defVal) throws IOException {
        try {
            Element tmpEl = this.findChildElement(this.currentElem, name);
            if (tmpEl == null) {
                return defVal;
            }
            String sizeString = tmpEl.getAttribute("size");
            ArrayList<Savable> savables = new ArrayList<Savable>();
            this.currentElem = this.findFirstChildElement(tmpEl);
            while (this.currentElem != null) {
                savables.add(this.readSavableFromCurrentElem(null));
                this.currentElem = this.findNextSiblingElement(this.currentElem);
            }
            if (sizeString.length() > 0) {
                int requiredSize = Integer.parseInt(sizeString);
                if (savables.size() != requiredSize) {
                    throw new IOException("Wrong number of Savable arrays for '" + name + "'.  size says " + requiredSize + ", data contains " + savables.size());
                }
            }
            this.currentElem = (Element)tmpEl.getParentNode();
            return savables;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            IOException io = new IOException(e.toString());
            io.initCause(e);
            throw io;
        }
    }

    public ArrayList<Savable>[] readSavableArrayListArray(String name, ArrayList[] defVal) throws IOException {
        try {
            ArrayList<Savable> sal;
            Element tmpEl = this.findChildElement(this.currentElem, name);
            if (tmpEl == null) {
                return defVal;
            }
            this.currentElem = tmpEl;
            String sizeString = tmpEl.getAttribute("size");
            int requiredSize = sizeString.length() > 0 ? Integer.parseInt(sizeString) : -1;
            ArrayList<ArrayList<Savable>> savableArrayLists = new ArrayList<ArrayList<Savable>>();
            int i = -1;
            while ((sal = this.readSavableArrayList("SavableArrayList_" + ++i, null)) != null || savableArrayLists.size() < requiredSize) {
                savableArrayLists.add(sal);
            }
            if (requiredSize > -1 && savableArrayLists.size() != requiredSize) {
                throw new IOException("String array contains wrong element count.  Specified size " + requiredSize + ", data contains " + savableArrayLists.size());
            }
            this.currentElem = (Element)tmpEl.getParentNode();
            return savableArrayLists.toArray(new ArrayList[0]);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (NumberFormatException | DOMException nfe) {
            IOException io = new IOException(nfe.toString());
            io.initCause(nfe);
            throw io;
        }
    }

    public ArrayList<Savable>[][] readSavableArrayListArray2D(String name, ArrayList[][] defVal) throws IOException {
        try {
            ArrayList<Savable>[] arr;
            Element tmpEl = this.findChildElement(this.currentElem, name);
            if (tmpEl == null) {
                return defVal;
            }
            this.currentElem = tmpEl;
            String sizeString = tmpEl.getAttribute("size");
            ArrayList<ArrayList<Savable>[]> sall = new ArrayList<ArrayList<Savable>[]>();
            int i = -1;
            while ((arr = this.readSavableArrayListArray("SavableArrayListArray_" + ++i, null)) != null) {
                sall.add(arr);
            }
            if (sizeString.length() > 0) {
                int requiredSize = Integer.parseInt(sizeString);
                if (sall.size() != requiredSize) {
                    throw new IOException("String array contains wrong element count.  Specified size " + requiredSize + ", data contains " + sall.size());
                }
            }
            this.currentElem = (Element)tmpEl.getParentNode();
            return (ArrayList[][])sall.toArray((T[])new ArrayList[0][]);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            IOException io = new IOException(e.toString());
            io.initCause(e);
            throw io;
        }
    }

    public ArrayList<FloatBuffer> readFloatBufferArrayList(String name, ArrayList<FloatBuffer> defVal) throws IOException {
        try {
            Element tmpEl = this.findChildElement(this.currentElem, name);
            if (tmpEl == null) {
                return defVal;
            }
            String sizeString = tmpEl.getAttribute("size");
            ArrayList<FloatBuffer> tmp = new ArrayList<FloatBuffer>();
            this.currentElem = this.findFirstChildElement(tmpEl);
            while (this.currentElem != null) {
                tmp.add(this.readFloatBuffer(null, null));
                this.currentElem = this.findNextSiblingElement(this.currentElem);
            }
            if (sizeString.length() > 0) {
                int requiredSize = Integer.parseInt(sizeString);
                if (tmp.size() != requiredSize) {
                    throw new IOException("String array contains wrong element count.  Specified size " + requiredSize + ", data contains " + tmp.size());
                }
            }
            this.currentElem = (Element)tmpEl.getParentNode();
            return tmp;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (NumberFormatException | DOMException nfe) {
            IOException io = new IOException(nfe.toString());
            io.initCause(nfe);
            throw io;
        }
    }

    public Map<? extends Savable, ? extends Savable> readSavableMap(String name, Map<? extends Savable, ? extends Savable> defVal) throws IOException {
        Element tempEl = name != null ? this.findChildElement(this.currentElem, name) : this.currentElem;
        HashMap<Savable, Savable> ret = new HashMap<Savable, Savable>();
        NodeList nodes = tempEl.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element elem;
            Node n = nodes.item(i);
            if (!(n instanceof Element) || !n.getNodeName().equals("MapEntry")) continue;
            this.currentElem = elem = (Element)n;
            Savable key = this.readSavable("Key", null);
            Savable val = this.readSavable("Value", null);
            ret.put(key, val);
        }
        this.currentElem = (Element)tempEl.getParentNode();
        return ret;
    }

    public Map<String, ? extends Savable> readStringSavableMap(String name, Map<String, ? extends Savable> defVal) throws IOException {
        HashMap<String, Savable> ret = null;
        Element tempEl = name != null ? this.findChildElement(this.currentElem, name) : this.currentElem;
        if (tempEl != null) {
            ret = new HashMap<String, Savable>();
            NodeList nodes = tempEl.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element elem;
                Node n = nodes.item(i);
                if (!(n instanceof Element) || !n.getNodeName().equals("MapEntry")) continue;
                this.currentElem = elem = (Element)n;
                String key = this.currentElem.getAttribute("key");
                Savable val = this.readSavable("Savable", null);
                ret.put(key, val);
            }
        } else {
            return defVal;
        }
        this.currentElem = (Element)tempEl.getParentNode();
        return ret;
    }

    public IntMap<? extends Savable> readIntSavableMap(String name, IntMap<? extends Savable> defVal) throws IOException {
        IntMap ret = null;
        Element tempEl = name != null ? this.findChildElement(this.currentElem, name) : this.currentElem;
        if (tempEl != null) {
            ret = new IntMap();
            NodeList nodes = tempEl.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element elem;
                Node n = nodes.item(i);
                if (!(n instanceof Element) || !n.getNodeName().equals("MapEntry")) continue;
                this.currentElem = elem = (Element)n;
                int key = Integer.parseInt(this.currentElem.getAttribute("key"));
                Savable val = this.readSavable("Savable", null);
                ret.put(key, (Object)val);
            }
        } else {
            return defVal;
        }
        this.currentElem = (Element)tempEl.getParentNode();
        return ret;
    }

    public FloatBuffer readFloatBuffer(String name, FloatBuffer defVal) throws IOException {
        try {
            int requiredSize;
            Element tmpEl = name != null ? this.findChildElement(this.currentElem, name) : this.currentElem;
            if (tmpEl == null) {
                return defVal;
            }
            String sizeString = tmpEl.getAttribute("size");
            String[] strings = this.parseTokens(tmpEl.getAttribute("data"));
            if (sizeString.length() > 0 && strings.length != (requiredSize = Integer.parseInt(sizeString))) {
                throw new IOException("Wrong number of float buffers for '" + name + "'.  size says " + requiredSize + ", data contains " + strings.length);
            }
            FloatBuffer tmp = BufferUtils.createFloatBuffer((int)strings.length);
            for (String s : strings) {
                tmp.put(Float.parseFloat(s));
            }
            tmp.flip();
            return tmp;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (NumberFormatException | DOMException nfe) {
            IOException io = new IOException(nfe.toString());
            io.initCause(nfe);
            throw io;
        }
    }

    public IntBuffer readIntBuffer(String name, IntBuffer defVal) throws IOException {
        try {
            int requiredSize;
            Element tmpEl = this.findChildElement(this.currentElem, name);
            if (tmpEl == null) {
                return defVal;
            }
            String sizeString = tmpEl.getAttribute("size");
            String[] strings = this.parseTokens(tmpEl.getAttribute("data"));
            if (sizeString.length() > 0 && strings.length != (requiredSize = Integer.parseInt(sizeString))) {
                throw new IOException("Wrong number of int buffers for '" + name + "'.  size says " + requiredSize + ", data contains " + strings.length);
            }
            IntBuffer tmp = BufferUtils.createIntBuffer((int)strings.length);
            for (String s : strings) {
                tmp.put(Integer.parseInt(s));
            }
            tmp.flip();
            return tmp;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (NumberFormatException | DOMException nfe) {
            IOException io = new IOException(nfe.toString());
            io.initCause(nfe);
            throw io;
        }
    }

    public ByteBuffer readByteBuffer(String name, ByteBuffer defVal) throws IOException {
        try {
            int requiredSize;
            Element tmpEl = this.findChildElement(this.currentElem, name);
            if (tmpEl == null) {
                return defVal;
            }
            String sizeString = tmpEl.getAttribute("size");
            String[] strings = this.parseTokens(tmpEl.getAttribute("data"));
            if (sizeString.length() > 0 && strings.length != (requiredSize = Integer.parseInt(sizeString))) {
                throw new IOException("Wrong number of byte buffers for '" + name + "'.  size says " + requiredSize + ", data contains " + strings.length);
            }
            ByteBuffer tmp = BufferUtils.createByteBuffer((int)strings.length);
            for (String s : strings) {
                tmp.put(Byte.valueOf(s));
            }
            tmp.flip();
            return tmp;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (NumberFormatException | DOMException nfe) {
            IOException io = new IOException(nfe.toString());
            io.initCause(nfe);
            throw io;
        }
    }

    public ShortBuffer readShortBuffer(String name, ShortBuffer defVal) throws IOException {
        try {
            int requiredSize;
            Element tmpEl = this.findChildElement(this.currentElem, name);
            if (tmpEl == null) {
                return defVal;
            }
            String sizeString = tmpEl.getAttribute("size");
            String[] strings = this.parseTokens(tmpEl.getAttribute("data"));
            if (sizeString.length() > 0 && strings.length != (requiredSize = Integer.parseInt(sizeString))) {
                throw new IOException("Wrong number of short buffers for '" + name + "'.  size says " + requiredSize + ", data contains " + strings.length);
            }
            ShortBuffer tmp = BufferUtils.createShortBuffer((int)strings.length);
            for (String s : strings) {
                tmp.put(Short.valueOf(s));
            }
            tmp.flip();
            return tmp;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (NumberFormatException | DOMException nfe) {
            IOException io = new IOException(nfe.toString());
            io.initCause(nfe);
            throw io;
        }
    }

    public ArrayList<ByteBuffer> readByteBufferArrayList(String name, ArrayList<ByteBuffer> defVal) throws IOException {
        try {
            Element tmpEl = this.findChildElement(this.currentElem, name);
            if (tmpEl == null) {
                return defVal;
            }
            String sizeString = tmpEl.getAttribute("size");
            ArrayList<ByteBuffer> tmp = new ArrayList<ByteBuffer>();
            this.currentElem = this.findFirstChildElement(tmpEl);
            while (this.currentElem != null) {
                tmp.add(this.readByteBuffer(null, null));
                this.currentElem = this.findNextSiblingElement(this.currentElem);
            }
            if (sizeString.length() > 0) {
                int requiredSize = Integer.parseInt(sizeString);
                if (tmp.size() != requiredSize) {
                    throw new IOException("Wrong number of short buffers for '" + name + "'.  size says " + requiredSize + ", data contains " + tmp.size());
                }
            }
            this.currentElem = (Element)tmpEl.getParentNode();
            return tmp;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (NumberFormatException | DOMException nfe) {
            IOException io = new IOException(nfe.toString());
            io.initCause(nfe);
            throw io;
        }
    }

    public <T extends Enum<T>> T readEnum(String name, Class<T> enumType, T defVal) throws IOException {
        T ret = defVal;
        try {
            String eVal = this.currentElem.getAttribute(name);
            if (eVal != null && eVal.length() > 0) {
                ret = Enum.valueOf(enumType, eVal);
            }
        }
        catch (Exception e) {
            IOException io = new IOException(e.toString());
            io.initCause(e);
            throw io;
        }
        return ret;
    }

    protected String[] parseTokens(String inString) {
        String[] outStrings = inString.split("\\s+");
        return outStrings.length == 1 && outStrings[0].length() == 0 ? zeroStrings : outStrings;
    }
}

