/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.fbx;

import com.jme3.animation.AnimControl;
import com.jme3.animation.Animation;
import com.jme3.animation.Bone;
import com.jme3.animation.BoneTrack;
import com.jme3.animation.Skeleton;
import com.jme3.animation.Track;
import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetLoadException;
import com.jme3.asset.AssetLoader;
import com.jme3.asset.AssetManager;
import com.jme3.asset.ModelKey;
import com.jme3.math.Matrix4f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.plugins.fbx.anim.FbxAnimCurveNode;
import com.jme3.scene.plugins.fbx.anim.FbxAnimLayer;
import com.jme3.scene.plugins.fbx.anim.FbxAnimStack;
import com.jme3.scene.plugins.fbx.anim.FbxBindPose;
import com.jme3.scene.plugins.fbx.anim.FbxLimbNode;
import com.jme3.scene.plugins.fbx.anim.FbxToJmeTrack;
import com.jme3.scene.plugins.fbx.file.FbxElement;
import com.jme3.scene.plugins.fbx.file.FbxFile;
import com.jme3.scene.plugins.fbx.file.FbxId;
import com.jme3.scene.plugins.fbx.file.FbxReader;
import com.jme3.scene.plugins.fbx.misc.FbxGlobalSettings;
import com.jme3.scene.plugins.fbx.node.FbxNode;
import com.jme3.scene.plugins.fbx.node.FbxRootNode;
import com.jme3.scene.plugins.fbx.obj.FbxObject;
import com.jme3.scene.plugins.fbx.obj.FbxObjectFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FbxLoader
implements AssetLoader {
    private static final Logger logger = Logger.getLogger(FbxLoader.class.getName());
    private AssetManager assetManager;
    private String sceneName;
    private String sceneFilename;
    private String sceneFolderName;
    private FbxGlobalSettings globalSettings;
    private final Map<FbxId, FbxObject> objectMap = new HashMap<FbxId, FbxObject>();
    private final List<FbxAnimStack> animStacks = new ArrayList<FbxAnimStack>();
    private final List<FbxBindPose> bindPoses = new ArrayList<FbxBindPose>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object load(AssetInfo assetInfo) throws IOException {
        this.assetManager = assetInfo.getManager();
        AssetKey assetKey = assetInfo.getKey();
        if (!(assetKey instanceof ModelKey)) {
            throw new AssetLoadException("Invalid asset key");
        }
        InputStream stream = assetInfo.openStream();
        try {
            this.sceneFilename = assetKey.getName();
            this.sceneFolderName = assetKey.getFolder();
            String ext = assetKey.getExtension();
            this.sceneName = this.sceneFilename.substring(0, this.sceneFilename.length() - ext.length() - 1);
            if (this.sceneFolderName != null && this.sceneFolderName.length() > 0) {
                this.sceneName = this.sceneName.substring(this.sceneFolderName.length());
            }
            this.reset();
            this.loadData(stream);
            this.applyBindPoses();
            this.updateWorldTransforms();
            this.constructSkeletons();
            Spatial scene = this.constructSceneGraph();
            this.constructAnimations();
            Spatial spatial = scene;
            return spatial;
        }
        finally {
            this.releaseObjects();
            if (stream != null) {
                stream.close();
            }
        }
    }

    private void reset() {
        this.globalSettings = new FbxGlobalSettings();
    }

    private void releaseObjects() {
        this.globalSettings = null;
        this.objectMap.clear();
        this.animStacks.clear();
    }

    private void loadData(InputStream stream) throws IOException {
        FbxFile scene = FbxReader.readFBX(stream);
        for (FbxElement e : scene.rootElements) {
            if (e.id.equals("FBXHeaderExtension")) {
                this.loadHeader(e);
                continue;
            }
            if (e.id.equals("GlobalSettings")) {
                this.loadGlobalSettings(e);
                continue;
            }
            if (e.id.equals("Objects")) {
                this.loadObjects(e);
                continue;
            }
            if (!e.id.equals("Connections")) continue;
            this.connectObjects(e);
        }
    }

    private void loadHeader(FbxElement element) {
        for (FbxElement e : element.children) {
            Integer version;
            if (!e.id.equals("FBXVersion") || (version = (Integer)e.properties.get(0)) >= 7100) continue;
            logger.log(Level.WARNING, "FBX file version is older than 7.1. Some features may not work.");
        }
    }

    private void loadGlobalSettings(FbxElement element) {
        this.globalSettings = new FbxGlobalSettings();
        this.globalSettings.fromElement(element);
    }

    private void loadObjects(FbxElement element) {
        this.objectMap.put(FbxId.ROOT, new FbxRootNode(this.assetManager, this.sceneFolderName));
        for (FbxElement e : element.children) {
            if (e.id.equals("GlobalSettings")) {
                this.globalSettings.fromElement(e);
                continue;
            }
            FbxObject object = FbxObjectFactory.createObject(e, this.assetManager, this.sceneFolderName);
            if (object != null) {
                if (this.objectMap.containsKey(object.getId())) {
                    logger.log(Level.WARNING, "An object with ID \"{0}\" has already been defined. Ignoring.", object.getId());
                }
                this.objectMap.put(object.getId(), object);
                if (object instanceof FbxAnimStack) {
                    this.animStacks.add((FbxAnimStack)object);
                    continue;
                }
                if (!(object instanceof FbxBindPose)) continue;
                this.bindPoses.add((FbxBindPose)object);
                continue;
            }
            throw new UnsupportedOperationException("Failed to create FBX object of type: " + e.id);
        }
    }

    private void connectObjects(FbxElement element) {
        if (this.objectMap.isEmpty()) {
            logger.log(Level.WARNING, "FBX file is missing object information");
            return;
        }
        if (this.objectMap.size() == 1) {
            logger.log(Level.WARNING, "FBX file has no objects");
            return;
        }
        for (FbxElement el : element.children) {
            FbxId parentId;
            FbxId childId;
            if (!el.id.equals("C") && !el.id.equals("Connect")) continue;
            String type = (String)el.properties.get(0);
            if (type.equals("OO")) {
                childId = FbxId.create(el.properties.get(1));
                parentId = FbxId.create(el.properties.get(2));
                FbxObject child = this.objectMap.get(childId);
                FbxObject parent = parentId.isNull() ? this.objectMap.get(FbxId.ROOT) : this.objectMap.get(parentId);
                if (parent == null) {
                    throw new UnsupportedOperationException("Cannot find parent object ID \"" + parentId + "\"");
                }
                parent.connectObject(child);
                continue;
            }
            if (type.equals("OP")) {
                childId = FbxId.create(el.properties.get(1));
                parentId = FbxId.create(el.properties.get(2));
                String propName = (String)el.properties.get(3);
                FbxObject child = this.objectMap.get(childId);
                FbxObject parent = this.objectMap.get(parentId);
                parent.connectObjectProperty(child, propName);
                continue;
            }
            logger.log(Level.WARNING, "Unknown connection type: {0}. Ignoring.", type);
        }
    }

    private void applyBindPoses() {
        for (FbxBindPose bindPose : this.bindPoses) {
            Map bindPoseData = (Map)bindPose.getJmeObject();
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "Applying {0} bind poses", bindPoseData.size());
            }
            for (Map.Entry entry : bindPoseData.entrySet()) {
                FbxObject obj = this.objectMap.get(entry.getKey());
                if (obj instanceof FbxNode) {
                    FbxNode node = (FbxNode)obj;
                    node.setWorldBindPose((Matrix4f)entry.getValue());
                    continue;
                }
                logger.log(Level.WARNING, "Bind pose can only be applied to FBX nodes. Ignoring.");
            }
        }
    }

    private void updateWorldTransforms() {
        FbxNode fbxRoot = (FbxNode)this.objectMap.get(FbxId.ROOT);
        fbxRoot.updateWorldTransforms(null, null);
    }

    private void constructAnimations() {
        HashMap<FbxToJmeTrack, FbxToJmeTrack> pairs = new HashMap<FbxToJmeTrack, FbxToJmeTrack>();
        for (FbxAnimStack stack : this.animStacks) {
            for (FbxAnimLayer layer : stack.getLayers()) {
                for (FbxAnimCurveNode curveNode : layer.getAnimationCurveNodes()) {
                    for (Map.Entry<FbxNode, String> nodePropertyEntry : curveNode.getInfluencedNodeProperties().entrySet()) {
                        FbxToJmeTrack lookupPair = new FbxToJmeTrack();
                        lookupPair.animStack = stack;
                        lookupPair.animLayer = layer;
                        lookupPair.node = nodePropertyEntry.getKey();
                        FbxToJmeTrack storedPair = (FbxToJmeTrack)pairs.get(lookupPair);
                        if (storedPair == null) {
                            storedPair = lookupPair;
                            pairs.put(storedPair, storedPair);
                        }
                        String property = nodePropertyEntry.getValue();
                        storedPair.animCurves.put(property, curveNode);
                    }
                }
            }
        }
        for (FbxToJmeTrack pair : pairs.values()) {
            String animName = pair.animStack.getName();
            float duration = pair.animStack.getDuration();
            duration = pair.getDuration();
            if (pair.node instanceof FbxLimbNode) {
                FbxLimbNode limbNode = (FbxLimbNode)pair.node;
                Bone bone = limbNode.getJmeBone();
                Spatial jmeSpatial = (Spatial)limbNode.getSkeletonHolder().getJmeObject();
                Skeleton skeleton = limbNode.getSkeletonHolder().getJmeSkeleton();
                AnimControl animControl = (AnimControl)jmeSpatial.getControl(AnimControl.class);
                if (animControl.getSkeleton() != skeleton) {
                    throw new UnsupportedOperationException();
                }
                Animation anim = animControl.getAnim(animName);
                if (anim == null) {
                    anim = new Animation(animName, duration);
                    animControl.addAnim(anim);
                }
                int boneIndex = skeleton.getBoneIndex(bone);
                BoneTrack bt = pair.toJmeBoneTrack(boneIndex, bone.getBindInverseTransform());
                anim.addTrack((Track)bt);
                continue;
            }
            Animation anim = new Animation(animName, duration);
            anim.setTracks(new Track[]{pair.toJmeSpatialTrack()});
            Spatial jmeSpatial = (Spatial)pair.node.getJmeObject();
            AnimControl animControl = (AnimControl)jmeSpatial.getControl(AnimControl.class);
            if (animControl == null) {
                animControl = new AnimControl(null);
                jmeSpatial.addControl((Control)animControl);
            }
            animControl.addAnim(anim);
        }
    }

    private void constructSkeletons() {
        FbxNode fbxRoot = (FbxNode)this.objectMap.get(FbxId.ROOT);
        FbxNode.createSkeletons(fbxRoot);
    }

    private Spatial constructSceneGraph() {
        FbxNode fbxRoot = (FbxNode)this.objectMap.get(FbxId.ROOT);
        Node jmeRoot = (Node)FbxNode.createScene(fbxRoot);
        jmeRoot.setName(this.sceneName + "-scene");
        return jmeRoot;
    }
}

