/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.BaseAppState;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import com.jme3.util.TangentBinormalGenerator;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.Direction;
import com.simsilica.mblock.geom.GeomPart;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugNormalsState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(DebugNormalsState.class);
    private Node normalsSource;
    private Node normalsDebug;
    private Material normalsMaterial;

    public DebugNormalsState() {
        this.setEnabled(false);
    }

    public void toggleEnabled() {
        this.setEnabled(!this.isEnabled());
    }

    protected Node getRoot() {
        return ((SimpleApplication)this.getApplication()).getRootNode();
    }

    public void updateNormalsDebug(Node normalsSource) {
        this.normalsSource = normalsSource;
        this.updateNormalsDebug();
    }

    protected void initialize(Application app) {
        this.normalsDebug = new Node("normals");
        this.normalsMaterial = new Material(app.getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        this.normalsMaterial.setColor("Color", ColorRGBA.White);
        this.normalsMaterial.setBoolean("VertexColor", true);
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        log.info("enabled");
        this.getRoot().attachChild((Spatial)this.normalsDebug);
        this.updateNormalsDebug();
    }

    protected void onDisable() {
        this.normalsDebug.removeFromParent();
    }

    protected Mesh expand(Mesh mesh) {
        VertexBuffer normalBuffer = mesh.getBuffer(VertexBuffer.Type.Normal);
        VertexBuffer dirBuffer = mesh.getBuffer(VertexBuffer.Type.Size);
        if (normalBuffer == null && dirBuffer == null) {
            throw new IllegalArgumentException("Mesh has no normals and no direction indexes");
        }
        if (normalBuffer != null || dirBuffer == null) {
            return mesh;
        }
        Mesh result = mesh.clone();
        ByteBuffer dirs = (ByteBuffer)dirBuffer.getData();
        int vertCount = dirs.limit();
        FloatBuffer normals = BufferUtils.createFloatBuffer((int)(vertCount * 3));
        FloatBuffer tangents = BufferUtils.createFloatBuffer((int)(vertCount * 3));
        for (int i = 0; i < vertCount; ++i) {
            byte d = dirs.get(i);
            Direction dir = Direction.values()[d];
            Vec3d norm = GeomPart.getNormal((Direction)dir);
            normals.put((float)norm.x).put((float)norm.y).put((float)norm.z);
            Vec3d tan = GeomPart.getTangent((Direction)dir);
            tangents.put((float)tan.x).put((float)tan.y).put((float)tan.z);
        }
        result.setBuffer(VertexBuffer.Type.Normal, 3, normals);
        result.setBuffer(VertexBuffer.Type.Tangent, 3, tangents);
        return result;
    }

    protected void updateNormalsDebug() {
        if (!this.isEnabled()) {
            return;
        }
        this.normalsDebug.detachAllChildren();
        this.normalsDebug.setLocalTranslation(this.normalsSource.getLocalTranslation());
        this.normalsDebug.setLocalScale(this.normalsSource.getLocalScale());
        this.updateNormalsDebug(this.normalsDebug, this.normalsSource);
    }

    protected void updateNormalsDebug(Node target, Node source) {
        for (Spatial child : source.getChildren()) {
            Node newChild = null;
            if (child instanceof Geometry) {
                Mesh m = ((Geometry)child).getMesh();
                m = this.expand(m);
                Mesh norms = TangentBinormalGenerator.genTbnLines((Mesh)m, (float)0.25f);
                norms.updateBound();
                newChild = new Geometry("debug", norms);
                newChild.setMaterial(this.normalsMaterial);
            } else if (child instanceof Node) {
                newChild = new Node("debug:" + child.getName());
                this.updateNormalsDebug(newChild, (Node)child);
            } else {
                log.warn("unhandled spatial type:" + child);
                continue;
            }
            newChild.setLocalTranslation(child.getLocalTranslation());
            newChild.setLocalRotation(child.getLocalRotation());
            newChild.setLocalScale(child.getLocalScale());
            target.attachChild((Spatial)newChild);
        }
    }
}

