/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.BaseAppState;
import com.jme3.light.Light;
import com.jme3.light.LightProbe;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.fx.sky.SkySettingsState;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.ListBox;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.RollupPanel;
import com.simsilica.lemur.TabbedPanel;
import com.simsilica.lemur.ValueRenderer;
import com.simsilica.lemur.component.IconComponent;
import com.simsilica.lemur.core.GuiComponent;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.list.DefaultCellRenderer;
import com.simsilica.tool.MainMenuState;
import java.util.Arrays;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentSettingsState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(EnvironmentSettingsState.class);
    private Container container;
    private TabbedPanel.Tab tab;
    private ProbeEntry defaultProbe = new ProbeEntry("Sky_Cloudy");
    private ProbeEntry[] probes = new ProbeEntry[]{new ProbeEntry("bathroom"), new ProbeEntry("City_Night_Lights"), new ProbeEntry("corsica_beach"), new ProbeEntry("dresden_station_night"), new ProbeEntry("flower_road"), new ProbeEntry("glass_passage"), new ProbeEntry("Parking_Lot"), new ProbeEntry("River_Road"), new ProbeEntry("road_in_tenerife_mountain"), this.defaultProbe, new ProbeEntry("Stonewall"), new ProbeEntry("studio")};
    private VersionedList<ProbeEntry> probeModel = new VersionedList(Arrays.asList(this.probes));
    private ListBox probeList;
    private VersionedReference<Set<Integer>> selectionRef;
    private ProbeEntry currentProbe;

    protected Node getRoot() {
        return ((SimpleApplication)this.getApplication()).getRootNode();
    }

    protected void initialize(Application app) {
        Container container = new Container();
        container.addChild((Node)this.createEnvironmentSettings(), new Object[0]);
        SkySettingsState skySettings = (SkySettingsState)this.getState(SkySettingsState.class);
        RollupPanel sky = (RollupPanel)container.addChild((Node)new RollupPanel("Sky", null), new Object[0]);
        sky.setContents((Panel)skySettings.getSettings());
        sky.setOpen(false);
        this.addSettings(container);
        ((MainMenuState)this.getState(MainMenuState.class)).getTabs().addTab("Environment", (Panel)container);
    }

    protected void addSettings(Container container) {
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
    }

    public void update(float tpf) {
        if (this.selectionRef.update()) {
            log.info("selection changed:" + this.probeList.getSelectionModel().getSelection());
            this.setProbe(this.probeList.getSelectionModel().getSelection());
        }
    }

    protected void onDisable() {
    }

    public void setProbe(int index) {
        ProbeEntry entry;
        ProbeEntry probeEntry = entry = index >= 0 ? (ProbeEntry)this.probeModel.get(index) : null;
        if (entry == this.currentProbe) {
            return;
        }
        if (this.currentProbe != null) {
            this.getRoot().removeLight((Light)this.currentProbe.getProbe());
        }
        this.currentProbe = entry;
        if (this.currentProbe != null) {
            this.getRoot().addLight((Light)this.currentProbe.getProbe());
        }
    }

    protected Panel createEnvironmentSettings() {
        this.probeList = new ListBox(this.probeModel);
        this.probeList.setVisibleItems(3);
        this.probeList.setCellRenderer((ValueRenderer)new ProbeCellRenderer());
        this.selectionRef = this.probeList.getSelectionModel().createReference();
        int defaultIndex = this.probeModel.indexOf((Object)this.defaultProbe);
        if (defaultIndex >= 0) {
            this.probeList.getSelectionModel().setSelection(Integer.valueOf(defaultIndex));
        }
        RollupPanel result = new RollupPanel("Probes", (Panel)this.probeList, null);
        Vector3f pref = result.getTitleElement().getPreferredSize();
        pref.x = Math.max(pref.x, 300.0f);
        result.getTitleElement().setPreferredSize(pref);
        return result;
    }

    public class ProbeCellRenderer
    extends DefaultCellRenderer<ProbeEntry> {
        public Panel getView(ProbeEntry value, boolean selected, Panel existing) {
            Label result = (Label)super.getView((Object)value, selected, existing);
            if (result.getIcon() != value.getIcon()) {
                result.setIcon((GuiComponent)value.getIcon());
            }
            return result;
        }
    }

    public class ProbeEntry {
        String name;
        String imageName;
        String probeName;
        IconComponent icon;
        LightProbe probe;

        public ProbeEntry(String stem) {
            this(stem, stem);
        }

        public ProbeEntry(String name, String stem) {
            this.name = name;
            this.imageName = "Probes/" + stem + ".jpg";
            this.probeName = "Probes/" + stem + ".j3o";
        }

        public String toString() {
            return this.name;
        }

        public IconComponent getIcon() {
            if (this.icon == null) {
                this.icon = new IconComponent(this.imageName);
                this.icon.setIconScale(new Vector2f(0.5f, 0.5f));
            }
            return this.icon;
        }

        public LightProbe getProbe() {
            if (this.probe == null) {
                Spatial probeHolder = EnvironmentSettingsState.this.getApplication().getAssetManager().loadModel(this.probeName);
                this.probe = (LightProbe)probeHolder.getLocalLightList().get(0);
                this.probe.setPosition(Vector3f.ZERO);
                probeHolder.removeLight((Light)this.probe);
            }
            return this.probe;
        }
    }
}

