/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.jme3.scene.Node;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.DefaultRangedValueModel;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.RangedValueModel;
import com.simsilica.lemur.SequenceModel;
import com.simsilica.lemur.SequenceModels;
import com.simsilica.lemur.Spinner;
import com.simsilica.lemur.ValueEditor;
import com.simsilica.lemur.ValueEditors;
import com.simsilica.lemur.ValueRenderer;
import com.simsilica.lemur.ValueRenderers;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiControl;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedObject;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.value.DefaultValueRenderer;
import com.simsilica.mathd.Quatd;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EulerRotationEditor
extends Panel
implements VersionedObject<Quatd> {
    static Logger log = LoggerFactory.getLogger(EulerRotationEditor.class);
    private Quatd value = new Quatd();
    private long version;
    private EditorEntry[] editors = new EditorEntry[3];

    public EulerRotationEditor() {
        this(Axis.X);
    }

    public EulerRotationEditor(Axis axis) {
        this.editors[0] = new EditorEntry(-90.0, 90.0, 0.5, 0.1);
        this.editors[1] = new EditorEntry(-180.0, 180.0, 0.5, 0.1);
        this.editors[2] = new EditorEntry(-180.0, 180.0, 0.5, 0.1);
        this.setBackground(null);
        if (axis == Axis.Y) {
            SpringGridLayout layout = new SpringGridLayout(Axis.Y, Axis.X, FillMode.Even, FillMode.Last);
            ((GuiControl)this.getControl(GuiControl.class)).setLayout((GuiLayout)layout);
            layout.addChild((Node)new Label("pitch:"), new Object[0]);
            layout.addChild(this.editors[0].editor, new Object[]{1});
            layout.addChild((Node)new Label("yaw:"), new Object[0]);
            layout.addChild(this.editors[1].editor, new Object[]{1});
            layout.addChild((Node)new Label("roll:"), new Object[0]);
            layout.addChild(this.editors[2].editor, new Object[]{1});
        } else if (axis == Axis.X) {
            SpringGridLayout layout = new SpringGridLayout(Axis.X, Axis.Y, FillMode.ForcedEven, FillMode.Last);
            ((GuiControl)this.getControl(GuiControl.class)).setLayout((GuiLayout)layout);
            Container column = (Container)layout.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y, FillMode.Last, FillMode.Last)), new Object[0]);
            column.setBackground(null);
            column.addChild((Node)new Label("pitch:"), new Object[0]);
            column.addChild(this.editors[0].editor, new Object[0]);
            column = (Container)layout.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y, FillMode.Last, FillMode.Last)), new Object[0]);
            column.setBackground(null);
            column.addChild((Node)new Label("yaw:"), new Object[0]);
            column.addChild(this.editors[1].editor, new Object[0]);
            column = (Container)layout.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y, FillMode.Last, FillMode.Last)), new Object[0]);
            column.setBackground(null);
            column.addChild((Node)new Label("roll:"), new Object[0]);
            column.addChild(this.editors[2].editor, new Object[0]);
        } else {
            throw new UnsupportedOperationException("Z axis not yet supported");
        }
    }

    public void setObject(Quatd value) {
        if (this.value == value) {
            return;
        }
        this.value.set(value);
        ++this.version;
        this.resetView();
    }

    public Quatd getObject() {
        return this.value;
    }

    public long getVersion() {
        return this.version;
    }

    public VersionedReference<Quatd> createReference() {
        return new VersionedReference((VersionedObject)this);
    }

    protected void resetView() {
        double[] angles = this.value.toAngles(null);
        for (int i = 0; i < 3; ++i) {
            this.editors[i].setRadians(angles[i]);
        }
    }

    public void setAngleModel(int angleIndex, SequenceModel<Double> model) {
        this.editors[angleIndex].setModel(model);
    }

    public SequenceModel<Double> getAngleModel(int angleIndex) {
        return this.editors[angleIndex].model;
    }

    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        boolean changed = false;
        for (EditorEntry e : this.editors) {
            if (!e.update()) continue;
            changed = true;
        }
        if (changed) {
            this.updateQuatd();
            ++this.version;
        }
    }

    protected void updateQuatd() {
        this.value.fromAngles(this.editors[0].getRadians(), this.editors[1].getRadians(), this.editors[2].getRadians());
    }

    private class EditorEntry {
        Spinner<Double> editor;
        SequenceModel<Double> model;
        VersionedReference<Double> valueRef;

        public EditorEntry(double min, double max, double step, double precision) {
            this.model = SequenceModels.rangedSequence((RangedValueModel)new DefaultRangedValueModel(min, max, 0.0), (double)step, (double)precision);
            this.valueRef = this.model.createReference();
            DefaultValueRenderer renderer = ValueRenderers.formattedRenderer((String)"%.1f", (String)"error");
            this.editor = new Spinner(this.model, (ValueRenderer)renderer);
            this.editor.setValueEditor((ValueEditor)ValueEditors.doubleEditor((String)"%.1f"));
        }

        public void setModel(SequenceModel<Double> model) {
            if (this.model == model) {
                return;
            }
            this.model = model;
            this.editor.setModel(model);
            this.valueRef = model.createReference();
        }

        public void setRadians(double d) {
            this.model.setObject((Object)Math.toDegrees(d));
        }

        public double getRadians() {
            return Math.toRadians((Double)this.model.getObject());
        }

        public boolean update() {
            return this.valueRef.update();
        }
    }
}

