/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.simsilica.lemur.GuiGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeomUtils {
    static Logger log = LoggerFactory.getLogger(GeomUtils.class);

    public static Geometry createAxis(float size, ColorRGBA xColor, ColorRGBA yColor, ColorRGBA zColor) {
        Mesh mesh = new Mesh();
        mesh.setMode(Mesh.Mode.Lines);
        mesh.setBuffer(VertexBuffer.Type.Position, 3, new float[]{0.0f, 0.0f, 0.0f, size, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, size, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, size});
        mesh.setBuffer(VertexBuffer.Type.Color, 4, new float[]{xColor.r, xColor.g, xColor.b, xColor.a, xColor.r, xColor.g, xColor.b, xColor.a, yColor.r, yColor.g, yColor.b, yColor.a, yColor.r, yColor.g, yColor.b, yColor.a, zColor.r, zColor.g, zColor.b, zColor.a, zColor.r, zColor.g, zColor.b, zColor.a});
        mesh.updateBound();
        Geometry geom = new Geometry("axis", mesh);
        Material mat = GuiGlobals.getInstance().createMaterial(ColorRGBA.White, false).getMaterial();
        mat.setBoolean("VertexColor", true);
        geom.setMaterial(mat);
        return geom;
    }
}

