/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.SceneGraphVisitor;
import com.jme3.scene.SceneGraphVisitorAdapter;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeometryInfoState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(GeometryInfoState.class);
    private Container main;
    private Container stats;

    public Container getInfo() {
        return this.main;
    }

    public void updateStats(Spatial ... targets) {
        this.stats.clearChildren();
        for (Spatial s : targets) {
            String name = s.getClass().getSimpleName() + " : " + s.getName();
            this.stats.addChild((Node)new Label(name), new Object[0]);
            this.stats.addChild((Node)this.createStats(s), new Object[0]);
        }
    }

    public void clearStats() {
        this.stats.clearChildren();
        this.stats.addChild((Node)new Label("None"), new Object[0]);
    }

    protected Container createStats(Spatial s) {
        final LinkedHashMap map = new LinkedHashMap();
        final ArrayList geoms = new ArrayList();
        s.breadthFirstTraversal((SceneGraphVisitor)new SceneGraphVisitorAdapter(){

            public void visit(Geometry geom) {
                Mesh mesh = geom.getMesh();
                if (mesh == null) {
                    return;
                }
                geoms.add(geom);
                for (VertexBuffer buff : mesh.getBufferList()) {
                    Counts counts = (Counts)map.get(buff.getBufferType());
                    if (counts == null) {
                        counts = new Counts();
                        map.put(buff.getBufferType(), counts);
                    }
                    counts.add(buff);
                }
            }
        });
        Container container = new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.Last, FillMode.Even));
        container.addChild((Node)new Label("Geometries:"), new Object[0]);
        container.addChild((Node)new Label(String.format("%,d", geoms.size())), new Object[]{1});
        int bytes = 0;
        for (Map.Entry e : map.entrySet()) {
            container.addChild((Node)new Label(String.valueOf(e.getKey()) + ":"), new Object[0]);
            Counts counts = (Counts)e.getValue();
            StringBuilder sb = new StringBuilder();
            for (String t : counts.types) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(t);
            }
            String type = sb.toString();
            String val = String.format("%,d * %,d (%s) = %,d bytes", counts.components, counts.elements, type, counts.bytes);
            container.addChild((Node)new Label(val), new Object[]{1});
            bytes += counts.bytes;
        }
        container.addChild((Node)new Label("Total:"), new Object[0]);
        container.addChild((Node)new Label(String.format("%,d bytes", bytes)), new Object[]{1});
        return container;
    }

    protected void initialize(Application app) {
        this.main = new Container();
        this.main.addChild((Node)new Label("Geometry stats:"), new Object[0]);
        this.stats = (Container)this.main.addChild((Node)new Container(), new Object[0]);
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
    }

    protected void onDisable() {
    }

    protected int bytes(Buffer buff) {
        if (buff == null) {
            return 0;
        }
        if (buff instanceof ByteBuffer) {
            return buff.capacity();
        }
        if (buff instanceof CharBuffer) {
            return buff.capacity() * 2;
        }
        if (buff instanceof DoubleBuffer) {
            return buff.capacity() * 8;
        }
        if (buff instanceof FloatBuffer) {
            return buff.capacity() * 4;
        }
        if (buff instanceof IntBuffer) {
            return buff.capacity() * 4;
        }
        if (buff instanceof LongBuffer) {
            return buff.capacity() * 8;
        }
        if (buff instanceof ShortBuffer) {
            return buff.capacity() * 2;
        }
        throw new IllegalArgumentException("Unhandled buffer type:" + buff.getClass());
    }

    protected String type(Buffer buff) {
        if (buff == null) {
            return "null";
        }
        if (buff instanceof ByteBuffer) {
            return "byte";
        }
        if (buff instanceof CharBuffer) {
            return "char";
        }
        if (buff instanceof DoubleBuffer) {
            return "double";
        }
        if (buff instanceof FloatBuffer) {
            return "float";
        }
        if (buff instanceof IntBuffer) {
            return "int";
        }
        if (buff instanceof LongBuffer) {
            return "long";
        }
        if (buff instanceof ShortBuffer) {
            return "short";
        }
        throw new IllegalArgumentException("Unhandled buffer type:" + buff.getClass());
    }

    private class Counts {
        int components;
        int elements;
        int bytes;
        Set<String> types = new LinkedHashSet<String>();

        private Counts() {
        }

        public void add(VertexBuffer buff) {
            this.components += buff.getNumComponents();
            this.elements += buff.getNumElements();
            this.bytes += GeometryInfoState.this.bytes(buff.getData());
            this.types.add(GeometryInfoState.this.type(buff.getData()));
        }
    }
}

