/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.BaseAppState;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Quad;
import com.jme3.texture.Texture;
import com.simsilica.lemur.GuiGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GridState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(GridState.class);
    private Node root;
    private Node gridRoot;
    private Spatial grid;
    private Quad quad;

    public Quad getQuad() {
        return this.quad;
    }

    public Node getGrid() {
        return this.gridRoot;
    }

    protected Node getRoot() {
        if (this.root == null) {
            this.root = ((SimpleApplication)this.getApplication()).getRootNode();
        }
        return this.root;
    }

    protected void initialize(Application app) {
        GuiGlobals globals = GuiGlobals.getInstance();
        this.gridRoot = new Node("gridRoot");
        this.gridRoot.setShadowMode(RenderQueue.ShadowMode.Receive);
        this.quad = new Quad(10.0f, 10.0f);
        this.grid = new Geometry("grid", (Mesh)this.quad);
        Texture gridTexture = globals.loadTexture("Textures/grid.png", true, true);
        Material mat = globals.createMaterial(gridTexture, false).getMaterial();
        mat.setColor("Color", new ColorRGBA(0.1f, 0.4f, 0.2f, 0.5f));
        mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        this.grid.setMaterial(mat);
        this.grid.setQueueBucket(RenderQueue.Bucket.Transparent);
        this.grid.rotate(-1.5707964f, 0.0f, 0.0f);
        this.grid.move(-5.0f, 0.0f, 5.0f);
        this.gridRoot.attachChild(this.grid);
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        this.getRoot().attachChild((Spatial)this.gridRoot);
    }

    protected void onDisable() {
        this.gridRoot.removeFromParent();
    }
}

